/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.ftp;

import gnu.java.net.protocol.ftp.DTP;
import gnu.java.net.protocol.ftp.DTPOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class BlockOutputStream
extends DTPOutputStream {
    static final byte RECORD = -128;
    static final byte EOF = 64;

    public void write(int c) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] byArray = new byte[4];
        byArray[0] = -128;
        byArray[2] = 1;
        byArray[3] = (byte)c;
        byte[] buf = byArray;
        this.out.write(buf, 0, 4);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] buf = new byte[len + 3];
        buf[0] = -128;
        buf[1] = (byte)((len & 0xFF) >> 8);
        buf[2] = (byte)(len & 0xFF00);
        System.arraycopy(b, off, buf, 3, len);
        this.out.write(buf, 0, len);
    }

    public void close() throws IOException {
        byte[] byArray = new byte[3];
        byArray[0] = 64;
        byte[] buf = byArray;
        this.out.write(buf, 0, 3);
        super.close();
    }

    BlockOutputStream(DTP dtp, OutputStream out) {
        super(dtp, out);
    }
}

