/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class BasicToggleButtonUI
extends BasicButtonUI {
    public static ComponentUI createUI(JComponent component) {
        return new BasicToggleButtonUI();
    }

    protected String getPropertyPrefix() {
        return "ToggleButton.";
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Rectangle tr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle vr = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        if (b.isBorderPainted()) {
            SwingUtilities.calculateInnerArea(b, vr);
        } else {
            vr = SwingUtilities.getLocalBounds(b);
        }
        String text = SwingUtilities.layoutCompoundLabel(c, g.getFontMetrics(f), b.getText(), BasicToggleButtonUI.currentIcon(b), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), vr, ir, tr, b.getIconTextGap() + this.defaultTextShiftOffset);
        if (b.getModel().isArmed() && b.getModel().isPressed() || b.isSelected()) {
            this.paintButtonPressed(g, b);
        }
        this.paintIcon(g, b, ir);
        if (text != null) {
            this.paintText(g, b, tr, text);
        }
        if (b.isFocusOwner() && b.isFocusPainted()) {
            this.paintFocus(g, b, vr, tr, ir);
        }
    }

    protected void paintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
        super.paintIcon(g, b, iconRect);
    }
}

