/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.tools.msstyles;

import com.l2fprod.tools.ImageUtils;
import com.l2fprod.tools.ThemeConverter;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MsStylesToSkinLF
extends ThemeConverter {
    private Document msstyle;
    private String msstyleDirectory;
    private String msstyleFile;
    private Element lastElement;

    public MsStylesToSkinLF() {
        super("MS{", "}");
    }

    public void setMsStyleDirectory(String directory) {
        this.msstyleDirectory = directory;
    }

    public String getMsStyleDirectory() {
        return this.msstyleDirectory;
    }

    public void setMsStyleXML(String file) throws Exception {
        this.msstyleFile = file;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.msstyle = builder.parse(new FileInputStream(file));
    }

    public void process() throws Exception {
        super.process();
        System.out.println("Fixing Window borders");
        this.postProcessWindowDecorations();
    }

    private Element locateElement(String xpath) throws Exception {
        if (xpath.startsWith("//")) {
            this.lastElement = (Element)XPathAPI.selectSingleNode((Node)this.msstyle.getDocumentElement(), (String)xpath);
            return this.lastElement;
        }
        return (Element)XPathAPI.selectSingleNode((Node)this.lastElement, (String)xpath);
    }

    private String getPropertyValue(Element part, String property) throws Exception {
        Element element = (Element)XPathAPI.selectSingleNode((Node)part, (String)("Property[@Name='" + property + "']"));
        if (element == null) {
            return null;
        }
        return element.getAttribute("Value");
    }

    protected String handleProperty(String path) throws Exception {
        Element element = this.locateElement(path);
        return element.getAttribute("Value");
    }

    protected String handleImage(String path, int index, int count, String outputname) throws Exception {
        Element element = this.locateElement(path);
        if (element == null) {
            throw new Exception("Node " + path + " not found");
        }
        boolean vertical = true;
        String imageFile = null;
        if ("Property".equalsIgnoreCase(element.getTagName())) {
            imageFile = element.getAttribute("Value");
        } else if ("Part".equalsIgnoreCase(element.getTagName()) || "Class".equalsIgnoreCase(element.getTagName())) {
            String layout;
            imageFile = this.getPropertyValue(element, "ImageFile1");
            if (imageFile == null) {
                imageFile = this.getPropertyValue(element, "ImageFile");
            }
            if ((layout = this.getPropertyValue(element, "ImageLayout")) == null) {
                layout = this.getPropertyValue(element, "Imagelayout");
            }
            vertical = "vertical".equalsIgnoreCase(layout);
            String countProperty = this.getPropertyValue(element, "ImageCount");
            if (countProperty != null) {
                count = Integer.parseInt(countProperty);
            }
        }
        if (imageFile == null || "".equals(imageFile)) {
            throw new Exception("No value found for " + path + " (" + imageFile + ")");
        }
        File file = new File(this.getMsStyleDirectory(), imageFile);
        if (!file.exists() && imageFile.toLowerCase().endsWith(".bmp")) {
            imageFile = imageFile.substring(0, imageFile.length() - 4) + ".png";
            file = new File(this.getMsStyleDirectory(), imageFile);
            if (!file.exists()) {
                imageFile = imageFile.substring(0, imageFile.length() - 4) + ".gif";
            }
        }
        ImageUtils.createPicture(this.getMsStyleDirectory() + File.separator + imageFile, index, count, new File(this.getCurrentOutputDirectory(), outputname).getAbsolutePath(), vertical);
        return outputname;
    }

    private void postProcessWindowDecorations() throws Exception {
        Image top = ImageUtils.loadPng(new File(this.getSkinDirectory(), "kde/titlebar_selected.png").getAbsolutePath());
        Image topUnselected = ImageUtils.loadPng(new File(this.getSkinDirectory(), "kde/titlebar_unselected.png").getAbsolutePath());
        Image left = ImageUtils.loadPng(new File(this.getSkinDirectory(), "kde/window_left.png").getAbsolutePath());
        Image right = ImageUtils.loadPng(new File(this.getSkinDirectory(), "kde/window_right.png").getAbsolutePath());
        Image topleft = ImageUtils.grab(top, 0, 0, left.getWidth(null), top.getHeight(null));
        ImageUtils.savePng(topleft, new File(this.getSkinDirectory(), "kde/window_topleft.png").getAbsolutePath());
        Image topright = ImageUtils.grab(top, top.getWidth(null) - right.getWidth(null), 0, right.getWidth(null), top.getHeight(null));
        ImageUtils.savePng(topright, new File(this.getSkinDirectory(), "kde/window_topright.png").getAbsolutePath());
        top = ImageUtils.grab(top, left.getWidth(null), 0, top.getWidth(null) - left.getWidth(null) - right.getWidth(null), top.getHeight(null));
        ImageUtils.savePng(top, new File(this.getSkinDirectory(), "kde/titlebar_selected.png").getAbsolutePath());
        topUnselected = ImageUtils.grab(topUnselected, left.getWidth(null), 0, top.getWidth(null) - left.getWidth(null) - right.getWidth(null), top.getHeight(null));
        ImageUtils.savePng(topUnselected, new File(this.getSkinDirectory(), "kde/titlebar_unselected.png").getAbsolutePath());
        Image bottom = ImageUtils.loadPng(new File(this.getSkinDirectory(), "kde/window_bottom.png").getAbsolutePath());
        Image bottomLeft = ImageUtils.grab(bottom, 0, 0, left.getWidth(null), bottom.getHeight(null));
        ImageUtils.savePng(bottomLeft, new File(this.getSkinDirectory(), "kde/window_bottomleft.png").getAbsolutePath());
        Image bottomRight = ImageUtils.grab(bottom, bottom.getWidth(null) - right.getWidth(null), 0, right.getWidth(null), bottom.getHeight(null));
        ImageUtils.savePng(bottomRight, new File(this.getSkinDirectory(), "kde/window_bottomright.png").getAbsolutePath());
        bottom = ImageUtils.grab(bottom, left.getWidth(null), 0, bottom.getWidth(null) - left.getWidth(null) - right.getWidth(null), bottom.getHeight(null));
        ImageUtils.savePng(bottom, new File(this.getSkinDirectory(), "kde/window_bottom.png").getAbsolutePath());
    }

    protected String paramString() {
        return super.paramString() + ",msstyleDirectory=" + this.msstyleDirectory + ",msstyleFile=" + this.msstyleFile;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("usage: msstylestoskinlf <styledirectory> <style.xml> <skinfolder>");
            System.exit(1);
        }
        String msstyleDir = args[0];
        String msstyles = args[1];
        String out = args[2];
        File outDir = new File(out);
        outDir.mkdirs();
        MsStylesToSkinLF converter = new MsStylesToSkinLF();
        converter.setMsStyleDirectory(msstyleDir);
        converter.setMsStyleXML(msstyles);
        converter.setSkinDirectory(outDir);
        System.out.println(converter.toString());
        converter.process();
        System.exit(0);
    }
}

