/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.completion;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JList;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.fw.completion.TextComponentProvider;

public class CompletionFocusHandler {
    private TextComponentProvider _txtComp;
    private JList _completionList;
    private FocusListener _completionFocusListener;
    private Timer _timer;
    private ActionListener _timerActionListener;
    private FocusEvent _lastFocusEvent;

    public CompletionFocusHandler(TextComponentProvider txtComp, JList completionList) {
        this._txtComp = txtComp;
        this._completionList = completionList;
        this._timerActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompletionFocusHandler.this.onTimerAction();
            }
        };
        this._timer = new Timer(200, null);
        this._timer.setRepeats(false);
        this._completionList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CompletionFocusHandler.this.onCompletionListFocusGained(e);
                CompletionFocusHandler.this.onFocusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                CompletionFocusHandler.this.onFocusLost(e);
            }
        });
        if (this._txtComp.editorEqualsFilter()) {
            this._txtComp.getEditor().addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    CompletionFocusHandler.this.onFocusGained(e);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    CompletionFocusHandler.this.onFocusLost(e);
                }
            });
        } else {
            this._txtComp.getFilter().addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    CompletionFocusHandler.this.onFocusGained(e);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    CompletionFocusHandler.this.onFocusLost(e);
                }
            });
        }
    }

    private void onFocusGained(FocusEvent e) {
        this._timer.stop();
        this._lastFocusEvent = e;
    }

    private void onFocusLost(FocusEvent e) {
        this._lastFocusEvent = e;
        this._timer.start();
    }

    private void onTimerAction() {
        this._timer.stop();
        if (null != this._completionFocusListener) {
            this._completionFocusListener.focusLost(this._lastFocusEvent);
        }
    }

    private void onCompletionListFocusGained(FocusEvent e) {
        if (!e.isTemporary() && !this._txtComp.editorEqualsFilter()) {
            this._txtComp.getFilter().requestFocusInWindow();
        }
    }

    public void setFocusListener(FocusListener completionFocusListener) {
        this._completionFocusListener = completionFocusListener;
        this._timer.removeActionListener(this._timerActionListener);
        if (null != this._completionFocusListener) {
            this._timer.addActionListener(this._timerActionListener);
        }
    }
}

