/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.NoParameterWhereClausePart;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.gui.RightLabel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.ThreadSafeDateFormat;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataTypeDate
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeDate.class);
    private static ILogger s_log = LoggerController.createLogger(DataTypeDate.class);
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();
    private static final String thisClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDate";
    private static int DEFAULT_LOCALE_FORMAT = 3;
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean useJavaDefaultFormat = true;
    private static int localeFormat = DEFAULT_LOCALE_FORMAT;
    private static boolean lenient = true;
    private static boolean readDateAsTimestamp = false;
    private static ThreadSafeDateFormat dateFormat = new ThreadSafeDateFormat(localeFormat);
    private boolean _renderExceptionHasBeenLogged;

    public DataTypeDate(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        DataTypeDate.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            propertiesAlreadyLoaded = true;
            useJavaDefaultFormat = true;
            String useJavaDefaultFormatString = DTProperties.get(thisClassName, "useJavaDefaultFormat");
            if (useJavaDefaultFormatString != null && useJavaDefaultFormatString.equals("false")) {
                useJavaDefaultFormat = false;
            }
            localeFormat = 3;
            String localeFormatString = DTProperties.get(thisClassName, "localeFormat");
            if (localeFormatString != null) {
                localeFormat = Integer.parseInt(localeFormatString);
            }
            lenient = true;
            String lenientString = DTProperties.get(thisClassName, "lenient");
            if (lenientString != null && lenientString.equals("false")) {
                lenient = false;
            }
            readDateAsTimestamp = false;
            String readDateAsTimestampString = DTProperties.get(thisClassName, "readDateAsTimestamp");
            if (readDateAsTimestampString != null && readDateAsTimestampString.equals("true")) {
                readDateAsTimestamp = true;
            }
            DataTypeDate.initDateFormat(localeFormat, lenient);
        }
    }

    private static void initDateFormat(int format, boolean lenient) {
        dateFormat = new ThreadSafeDateFormat(format);
        dateFormat.setLenient(lenient);
    }

    public static boolean getReadDateAsTimestamp() {
        propertiesAlreadyLoaded = false;
        DataTypeDate.loadProperties();
        return readDateAsTimestamp;
    }

    @Override
    public String getClassName() {
        return "java.sql.Date";
    }

    @Override
    public String renderObject(Object value) {
        if (useJavaDefaultFormat || value == null) {
            return (String)this._renderer.renderObject(value);
        }
        try {
            return (String)this._renderer.renderObject(dateFormat.format(value));
        }
        catch (Exception e) {
            if (!this._renderExceptionHasBeenLogged) {
                this._renderExceptionHasBeenLogged = true;
                s_log.error("Could not format \"" + value + "\" as date type", e);
            }
            return (String)this._renderer.renderObject(value);
        }
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeDate.this._textComponent, evt, DataTypeDate.this._table);
                    CellDataPopup.showDialog(DataTypeDate.this._table, DataTypeDate.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value.equals("<null>") || value.equals("")) {
            return null;
        }
        try {
            if (useJavaDefaultFormat) {
                Date obj = Date.valueOf(value);
                return obj;
            }
            java.util.Date javaDate = dateFormat.parse(value);
            Date sqlDate = new Date(javaDate.getTime());
            return sqlDate;
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    @Override
    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        return DataTypeDate.staticReadResultSet(rs, index, limitDataRead);
    }

    public static Object staticReadResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        DataTypeDate.loadProperties();
        Date data = null;
        data = rs.getDate(index);
        if (rs.wasNull()) {
            return null;
        }
        return data;
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        boolean hasDateComponent;
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return new IsNullWhereClausePart(this._colDef);
        }
        boolean hasTimeComponent = value.toString().indexOf(":") != -1;
        boolean bl = hasDateComponent = value.toString().indexOf("-") != -1;
        if (hasTimeComponent && hasDateComponent) {
            return new NoParameterWhereClausePart(this._colDef, this._colDef.getColumnName() + "={ts '" + value.toString() + "'}");
        }
        if (hasTimeComponent) {
            return new NoParameterWhereClausePart(this._colDef, this._colDef.getColumnName() + "={t '" + value.toString() + "'}");
        }
        if (DialectFactory.isOracle(md)) {
            return new NoParameterWhereClausePart(this._colDef, "trunc(" + this._colDef.getColumnName() + ")={d '" + value.toString() + "'}");
        }
        return new NoParameterWhereClausePart(this._colDef, this._colDef.getColumnName() + "={d '" + value.toString() + "'}");
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            pstmt.setDate(position, (Date)value);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return new Date(new java.util.Date().getTime());
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    public static OkJPanel getControlPanel() {
        DataTypeDate.loadProperties();
        return new DateOkJPanel();
    }

    private static class DateOkJPanel
    extends OkJPanel {
        private static final long serialVersionUID = 1L;
        private JCheckBox useJavaDefaultFormatChk = new JCheckBox(DataTypeDate.access$400().getString("dataTypeDate.useDefaultFormat", new Date(new java.util.Date().getTime()).toString()));
        private RightLabel dateFormatTypeDropLabel = new RightLabel(DataTypeDate.access$400().getString("dataTypeDate.orlocaleIndependent"));
        private DateFormatTypeCombo dateFormatTypeDrop = new DateFormatTypeCombo();
        private JCheckBox lenientChk = new JCheckBox(DataTypeDate.access$400().getString("dataTypeDate.allowInexact"));
        private JCheckBox readdDateAsTimestampChk = new JCheckBox(DataTypeDate.access$400().getString("dataTypeDate.readDateAsTimestamp"));

        public DateOkJPanel() {
            this.useJavaDefaultFormatChk.setSelected(useJavaDefaultFormat);
            this.useJavaDefaultFormatChk.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DateOkJPanel.this.dateFormatTypeDrop.setEnabled(!DateOkJPanel.this.useJavaDefaultFormatChk.isSelected());
                    DateOkJPanel.this.dateFormatTypeDropLabel.setEnabled(!DateOkJPanel.this.useJavaDefaultFormatChk.isSelected());
                    DateOkJPanel.this.lenientChk.setEnabled(!DateOkJPanel.this.useJavaDefaultFormatChk.isSelected());
                }
            });
            this.dateFormatTypeDrop = new DateFormatTypeCombo();
            this.dateFormatTypeDrop.setSelectedIndex(localeFormat);
            this.lenientChk.setSelected(lenient);
            this.readdDateAsTimestampChk.setSelected(readDateAsTimestamp);
            this.dateFormatTypeDrop.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.dateFormatTypeDropLabel.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.lenientChk.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dataTypeDate.typeDate")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 0;
            this.add((Component)this.useJavaDefaultFormatChk, gbc);
            gbc.gridwidth = 1;
            gbc.gridx = 0;
            ++gbc.gridy;
            this.add((Component)this.dateFormatTypeDropLabel, gbc);
            ++gbc.gridx;
            this.add((Component)this.dateFormatTypeDrop, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            this.add((Component)this.lenientChk, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            this.add((Component)this.readdDateAsTimestampChk, gbc);
        }

        @Override
        public void ok() {
            useJavaDefaultFormat = this.useJavaDefaultFormatChk.isSelected();
            DTProperties.put(DataTypeDate.thisClassName, "useJavaDefaultFormat", Boolean.valueOf(useJavaDefaultFormat).toString());
            localeFormat = this.dateFormatTypeDrop.getValue();
            dateFormat = new ThreadSafeDateFormat(localeFormat);
            DTProperties.put(DataTypeDate.thisClassName, "localeFormat", Integer.toString(localeFormat));
            lenient = this.lenientChk.isSelected();
            dateFormat.setLenient(lenient);
            DTProperties.put(DataTypeDate.thisClassName, "lenient", Boolean.valueOf(lenient).toString());
            readDateAsTimestamp = this.readdDateAsTimestampChk.isSelected();
            DTProperties.put(DataTypeDate.thisClassName, "readDateAsTimestamp", Boolean.valueOf(readDateAsTimestamp).toString());
            DataTypeDate.initDateFormat(localeFormat, lenient);
        }
    }

    public static class DateFormatTypeCombo
    extends JComboBox {
        private static final long serialVersionUID = 1L;

        public DateFormatTypeCombo() {
            this.addItem(s_stringMgr.getString("dataTypeDate.full", DateFormat.getDateInstance(0).format(new java.util.Date())));
            this.addItem(s_stringMgr.getString("dataTypeDate.long", DateFormat.getDateInstance(1).format(new java.util.Date())));
            this.addItem(s_stringMgr.getString("dataTypeDate.medium", DateFormat.getDateInstance(2).format(new java.util.Date())));
            this.addItem(s_stringMgr.getString("dataTypeDate.short", DateFormat.getDateInstance(3).format(new java.util.Date())));
        }

        @Override
        public void setSelectedIndex(int option) {
            if (option == 3) {
                super.setSelectedIndex(3);
            } else if (option == 2) {
                super.setSelectedIndex(2);
            } else if (option == 1) {
                super.setSelectedIndex(1);
            } else {
                super.setSelectedIndex(0);
            }
        }

        public int getValue() {
            if (this.getSelectedIndex() == 3) {
                return 3;
            }
            if (this.getSelectedIndex() == 2) {
                return 2;
            }
            if (this.getSelectedIndex() == 1) {
                return 1;
            }
            return 0;
        }
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeDate.this._textComponent);
            String text = _theComponent.getText();
            if (c == '\t' || c == '\n') {
                int index = text.indexOf(c);
                if (index != -1) {
                    text = index == text.length() - 1 ? text.substring(0, text.length() - 1) : text.substring(0, index) + text.substring(index + 1);
                    ((IRestorableTextComponent)((Object)_theComponent)).updateText(text);
                    DataTypeDate.this._beepHelper.beep(_theComponent);
                }
                e.consume();
            }
            if (DataTypeDate.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeDate.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeDate.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DataTypeDate.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField(text, c, e, DataTypeDate.this._textComponent);
            }
        }
    }
}

