/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import org.apache.zookeeper.graph.FilterException;
import org.apache.zookeeper.graph.FilterOp;
import org.apache.zookeeper.graph.filterops.NumberArg;
import org.apache.zookeeper.graph.filterops.StringArg;
import org.apache.zookeeper.graph.filterops.SymbolArg;

public class FilterParser {
    private PushbackReader reader;

    public FilterParser(String s) {
        this.reader = new PushbackReader(new StringReader(s));
    }

    private String readUntilSpace() throws IOException {
        StringBuffer buffer = new StringBuffer();
        int c = this.reader.read();
        while (!Character.isWhitespace(c) && c != 41 && c != 40) {
            buffer.append((char)c);
            c = this.reader.read();
            if (c != -1) continue;
        }
        this.reader.unread(c);
        return buffer.toString().trim();
    }

    private StringArg readStringArg() throws IOException, FilterException {
        int c = this.reader.read();
        int last = 0;
        if (c != 34) {
            throw new FilterException("Check the parser, trying to read a string that doesn't begin with quotes");
        }
        StringBuffer buffer = new StringBuffer();
        while (this.reader.ready()) {
            last = c;
            c = this.reader.read();
            if (c == -1) break;
            if (c == 34 && last != 92) {
                return new StringArg(buffer.toString());
            }
            buffer.append((char)c);
        }
        throw new FilterException("Unterminated string");
    }

    private NumberArg readNumberArg() throws IOException, FilterException {
        String strval = this.readUntilSpace();
        try {
            if (strval.startsWith("0x")) {
                return new NumberArg(Long.valueOf(strval.substring(2), 16));
            }
            return new NumberArg(Long.valueOf(strval));
        }
        catch (NumberFormatException e) {
            throw new FilterException("Not a number [" + strval + "]\n" + e);
        }
    }

    private SymbolArg readSymbolArg() throws IOException, FilterException {
        return new SymbolArg(this.readUntilSpace());
    }

    public FilterOp parse() throws IOException, FilterException {
        int c = this.reader.read();
        if (c != 40) {
            throw new FilterException("Invalid format");
        }
        String opstr = this.readUntilSpace();
        FilterOp op = FilterOp.newOp(opstr);
        while (this.reader.ready() && (c = this.reader.read()) != -1) {
            if (c == 40) {
                this.reader.unread(c);
                op.addSubOp(this.parse());
                continue;
            }
            if (c == 41) {
                return op;
            }
            if (c == 34) {
                this.reader.unread(c);
                op.addArg(this.readStringArg());
                continue;
            }
            if (Character.isDigit(c) || c == 45 || c == 43) {
                this.reader.unread(c);
                op.addArg(this.readNumberArg());
                continue;
            }
            if (!Character.isJavaIdentifierStart(c)) continue;
            this.reader.unread(c);
            op.addArg(this.readSymbolArg());
        }
        throw new FilterException("Incomplete filter");
    }

    public static void main(String[] args) throws IOException, FilterException {
        if (args.length == 1) {
            System.out.println(new FilterParser(args[0]).parse());
        } else {
            System.out.println(new FilterParser("(or (and (= session foobar) (= session barfoo)) (= session sdfs))").parse());
        }
    }
}

