/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.convert.v20to21;

import gen.core.filters.Files;
import gen.core.filters.Filter;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.omegat.convert.v20to21.data.Filters;
import org.omegat.convert.v20to21.data.Instance;
import org.omegat.convert.v20to21.data.OneFilter;

public final class Convert20to21 {
    private Convert20to21() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertFiltersConfig(File fromFile, File toFile) throws Exception {
        Filters filters;
        if (!fromFile.exists()) {
            return;
        }
        String c = Convert20to21.read(fromFile);
        try (XMLDecoder xmldec = new XMLDecoder(new ByteArrayInputStream(c.getBytes("UTF-8")));){
            filters = (Filters)xmldec.readObject();
        }
        gen.core.filters.Filters res = new gen.core.filters.Filters();
        for (OneFilter f : filters.getFilter()) {
            Filter fo = new Filter();
            res.getFilters().add(fo);
            fo.setClassName(f.getClassName());
            fo.setEnabled(f.isOn());
            for (Instance i : f.getInstance()) {
                Files io = new Files();
                fo.getFiles().add(io);
                io.setSourceFilenameMask(i.getSourceFilenameMask());
                io.setTargetFilenamePattern(i.getTargetFilenamePattern());
                io.setSourceEncoding(i.getSourceEncoding());
                io.setTargetEncoding(i.getTargetEncoding());
            }
            Serializable opts = f.getOptions();
            if (opts == null) continue;
            BeanInfo bi = Introspector.getBeanInfo(opts.getClass());
            for (PropertyDescriptor prop : bi.getPropertyDescriptors()) {
                if ("class".equals(prop.getName())) continue;
                Object value = prop.getReadMethod().invoke((Object)opts, new Object[0]);
                Filter.Option op = new Filter.Option();
                op.setName(prop.getName());
                op.setValue(value.toString());
                fo.getOption().add(op);
            }
        }
        Convert20to21.convertTextFilter(res);
        Convert20to21.convertHTMLFilter2(res);
        JAXBContext ctx = JAXBContext.newInstance(gen.core.filters.Filters.class);
        Marshaller m = ctx.createMarshaller();
        m.setProperty("jaxb.formatted.output", true);
        m.marshal((Object)res, toFile);
    }

    private static String read(File f) throws IOException {
        StringBuilder r = new StringBuilder();
        char[] c = new char[8192];
        try (InputStreamReader rd = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);){
            int len;
            while ((len = rd.read(c)) >= 0) {
                r.append(c, 0, len);
            }
        }
        String res = r.toString();
        res = res.replace("org.omegat.filters2.master.Filters", "org.omegat.convert.v20to21.data.Filters");
        res = res.replace("org.omegat.filters2.master.OneFilter", "org.omegat.convert.v20to21.data.OneFilter");
        res = res.replace("org.omegat.filters2.Instance", "org.omegat.convert.v20to21.data.Instance");
        res = res.replace("org.omegat.filters2.html2.HTMLOptions", "org.omegat.convert.v20to21.data.HTMLOptions");
        res = res.replace("org.omegat.filters2.text.TextOptions", "org.omegat.convert.v20to21.data.TextOptions");
        res = res.replace("org.omegat.filters3.xml.opendoc.OpenDocOptions", "org.omegat.convert.v20to21.data.OpenDocOptions");
        res = res.replace("org.omegat.filters3.xml.openxml.OpenXMLOptions", "org.omegat.convert.v20to21.data.OpenXMLOptions");
        res = res.replace("org.omegat.filters3.xml.xhtml.XHTMLOptions", "org.omegat.convert.v20to21.data.XHTMLOptions");
        return res;
    }

    private static void convertTextFilter(gen.core.filters.Filters res) {
        for (Filter f : res.getFilters()) {
            if (!f.getClassName().equals("org.omegat.filters2.text.TextFilter")) continue;
            for (Filter.Option opt : f.getOption()) {
                if (!opt.getName().equals("segmentOn")) continue;
                try {
                    switch (Integer.parseInt(opt.getValue())) {
                        case 1: {
                            opt.setValue("BREAKS");
                            break;
                        }
                        case 2: {
                            opt.setValue("EMPTYLINES");
                            break;
                        }
                        case 3: {
                            opt.setValue("NEVER");
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void convertHTMLFilter2(gen.core.filters.Filters res) {
        for (Filter f : res.getFilters()) {
            if (!f.getClassName().equals("org.omegat.filters2.html2.HTMLFilter2")) continue;
            for (Filter.Option opt : f.getOption()) {
                if (!opt.getName().equals("rewriteEncoding")) continue;
                try {
                    switch (Integer.parseInt(opt.getValue())) {
                        case 1: {
                            opt.setValue("ALWAYS");
                            break;
                        }
                        case 2: {
                            opt.setValue("IFHEADER");
                            break;
                        }
                        case 3: {
                            opt.setValue("IFMETA");
                            break;
                        }
                        case 4: {
                            opt.setValue("NEVER");
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

