/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gosen;

import java.io.IOException;
import net.java.sen.SenFactory;
import net.java.sen.StringTagger;
import net.java.sen.dictionary.Morpheme;
import net.java.sen.dictionary.Token;
import net.java.sen.filter.StreamFilter;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.gosen.StreamTagger2;
import org.apache.lucene.analysis.gosen.tokenAttributes.BasicFormAttribute;
import org.apache.lucene.analysis.gosen.tokenAttributes.ConjugationAttribute;
import org.apache.lucene.analysis.gosen.tokenAttributes.CostAttribute;
import org.apache.lucene.analysis.gosen.tokenAttributes.PartOfSpeechAttribute;
import org.apache.lucene.analysis.gosen.tokenAttributes.PronunciationsAttribute;
import org.apache.lucene.analysis.gosen.tokenAttributes.ReadingsAttribute;
import org.apache.lucene.analysis.gosen.tokenAttributes.SentenceStartAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.AttributeFactory;

public final class GosenTokenizer
extends Tokenizer {
    private final StreamTagger2 tagger;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final BasicFormAttribute basicFormAtt = (BasicFormAttribute)this.addAttribute(BasicFormAttribute.class);
    private final ConjugationAttribute conjugationAtt = (ConjugationAttribute)this.addAttribute(ConjugationAttribute.class);
    private final PartOfSpeechAttribute partOfSpeechAtt = (PartOfSpeechAttribute)this.addAttribute(PartOfSpeechAttribute.class);
    private final PronunciationsAttribute pronunciationsAtt = (PronunciationsAttribute)this.addAttribute(PronunciationsAttribute.class);
    private final ReadingsAttribute readingsAtt = (ReadingsAttribute)this.addAttribute(ReadingsAttribute.class);
    private final SentenceStartAttribute sentenceAtt = (SentenceStartAttribute)this.addAttribute(SentenceStartAttribute.class);
    private final CostAttribute costAtt = (CostAttribute)this.addAttribute(CostAttribute.class);
    private int accumulatedCost = 0;

    public GosenTokenizer() {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, null, null);
    }

    public GosenTokenizer(StreamFilter filter) {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, filter, null);
    }

    public GosenTokenizer(StreamFilter filter, String dictionaryDir) {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, filter, dictionaryDir);
    }

    public GosenTokenizer(AttributeFactory factory, StreamFilter filter, String dictionaryDir) {
        super(factory);
        StringTagger stringTagger = SenFactory.getStringTagger(dictionaryDir);
        if (filter != null) {
            stringTagger.addFilter(filter);
        }
        this.tagger = new StreamTagger2(stringTagger, this.input);
    }

    public boolean incrementToken() throws IOException {
        Token token = this.tagger.next();
        if (token == null) {
            return false;
        }
        this.clearAttributes();
        Morpheme m = token.getMorpheme();
        this.termAtt.setEmpty().append(token.getSurface());
        int cost = token.getCost();
        if (token.isSentenceStart()) {
            this.accumulatedCost = 0;
            this.sentenceAtt.setSentenceStart(true);
        }
        this.costAtt.setCost(cost - this.accumulatedCost);
        this.accumulatedCost = cost;
        this.basicFormAtt.setMorpheme(m);
        this.conjugationAtt.setMorpheme(m);
        this.partOfSpeechAtt.setMorpheme(m);
        this.pronunciationsAtt.setMorpheme(m);
        this.readingsAtt.setMorpheme(m);
        this.offsetAtt.setOffset(this.correctOffset(token.getStart()), this.correctOffset(token.end()));
        return true;
    }

    public void close() throws IOException {
        super.close();
        this.tagger.reset(this.input);
    }

    public void reset() throws IOException {
        super.reset();
        this.tagger.reset(this.input);
        this.accumulatedCost = 0;
    }

    public void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.tagger.end());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }
}

