/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.stardict;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import org.dict.zip.DictZipInputStream;
import org.dict.zip.RandomAccessInputStream;
import tokyo.northside.stardict.DictionaryData;
import tokyo.northside.stardict.IndexEntry;
import tokyo.northside.stardict.StarDictDictionary;
import tokyo.northside.stardict.StarDictInfo;

public class StarDictZipDict
extends StarDictDictionary {
    private final DictZipInputStream dataFile;

    StarDictZipDict(StarDictInfo info, File dictFile, DictionaryData<IndexEntry> data, int cacheSize) throws Exception {
        super(data, info, 64, cacheSize);
        this.dataFile = new DictZipInputStream(new RandomAccessInputStream(new RandomAccessFile(dictFile, "r")));
    }

    @Override
    protected String readArticle(long start, int len) {
        String result = null;
        try {
            this.dataFile.seek(start);
            byte[] data = new byte[len];
            this.dataFile.readFully(data);
            result = new String(data, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.dataFile.close();
    }
}

