/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake;

import com.github.tjake.CRC32Ex;
import com.github.tjake.ICRC32;
import com.github.tjake.PureJavaCrc32;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.BlockingQueue;

public class CRC32Factory {
    private static final boolean JDK8;
    public static final CRC32Factory defaultFactory;
    private final Class<? extends ICRC32> jdk7class;

    public CRC32Factory(Class<? extends ICRC32> jdk7class) {
        assert (jdk7class != null);
        this.jdk7class = jdk7class;
    }

    public ICRC32 create() {
        if (JDK8) {
            return new CRC32Ex();
        }
        try {
            return this.jdk7class.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        defaultFactory = new CRC32Factory(PureJavaCrc32.class);
        boolean jdk8 = false;
        ClassLoader cl = null;
        try {
            cl = System.getSecurityManager() == null ? BlockingQueue.class.getClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return BlockingQueue.class.getClassLoader();
                }
            });
            Class.forName("java.util.concurrent.CompletableFuture", false, cl);
            jdk8 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        JDK8 = jdk8;
    }
}

