/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.parse.rewriters;

import java.util.List;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.LValue;
import org.benf.cfr.reader.bytecode.analysis.parse.StatementContainer;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ArithOp;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ArithmeticOperation;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ConditionalExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationSimple;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.Literal;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.MemberFunctionInvokation;
import org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.StackSSALabel;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterFlags;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.SSAIdentifiers;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.RawJavaType;
import org.benf.cfr.reader.bytecode.analysis.types.TypeConstants;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.InferredJavaType;
import org.benf.cfr.reader.util.ClassFileVersion;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;

public class StringBuilderRewriter
implements ExpressionRewriter {
    private final boolean stringBuilderEnabled;
    private final boolean stringBufferEnabled;

    public StringBuilderRewriter(Options options, ClassFileVersion classFileVersion) {
        this.stringBufferEnabled = options.getOption(OptionsImpl.SUGAR_STRINGBUFFER, classFileVersion);
        this.stringBuilderEnabled = options.getOption(OptionsImpl.SUGAR_STRINGBUILDER, classFileVersion);
    }

    @Override
    public Expression rewriteExpression(Expression expression, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
        Expression lhs;
        Expression result;
        MemberFunctionInvokation memberFunctionInvokation;
        if (expression instanceof MemberFunctionInvokation && "toString".equals((memberFunctionInvokation = (MemberFunctionInvokation)expression).getName()) && (result = this.testAppendChain(lhs = memberFunctionInvokation.getObject())) != null) {
            return result;
        }
        return expression.applyExpressionRewriter(this, ssaIdentifiers, statementContainer, flags);
    }

    @Override
    public void handleStatement(StatementContainer statementContainer) {
    }

    @Override
    public ConditionalExpression rewriteExpression(ConditionalExpression expression, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
        Expression res = expression.applyExpressionRewriter(this, ssaIdentifiers, statementContainer, flags);
        return (ConditionalExpression)res;
    }

    @Override
    public LValue rewriteExpression(LValue lValue, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
        return lValue;
    }

    @Override
    public StackSSALabel rewriteExpression(StackSSALabel lValue, SSAIdentifiers ssaIdentifiers, StatementContainer statementContainer, ExpressionRewriterFlags flags) {
        return lValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression testAppendChain(Expression lhs) {
        List<Expression> reverseAppendChain = ListFactory.newList();
        do {
            Expression e;
            if (lhs instanceof MemberFunctionInvokation) {
                Expression ce;
                MemberFunctionInvokation memberFunctionInvokation = (MemberFunctionInvokation)lhs;
                if (!memberFunctionInvokation.getName().equals("append") || memberFunctionInvokation.getArgs().size() != 1) return null;
                lhs = memberFunctionInvokation.getObject();
                e = memberFunctionInvokation.getAppropriatelyCastArgument(0);
                if (e instanceof CastExpression && (ce = ((CastExpression)e).getChild()).getInferredJavaType().getJavaTypeInstance().implicitlyCastsTo(e.getInferredJavaType().getJavaTypeInstance(), null)) {
                    e = ce;
                }
            } else {
                if (!(lhs instanceof ConstructorInvokationSimple)) return null;
                ConstructorInvokationSimple newObject = (ConstructorInvokationSimple)lhs;
                String rawName = newObject.getTypeInstance().getRawName();
                if ((!this.stringBuilderEnabled || !rawName.equals("java.lang.StringBuilder")) && (!this.stringBufferEnabled || !rawName.equals("java.lang.StringBuffer"))) return null;
                switch (newObject.getArgs().size()) {
                    default: {
                        return null;
                    }
                    case 1: {
                        Expression ce;
                        Expression e2 = newObject.getArgs().get(0);
                        String typeName = e2.getInferredJavaType().getJavaTypeInstance().getRawName();
                        if (!typeName.equals("java.lang.String")) return null;
                        if (e2 instanceof CastExpression && (ce = ((CastExpression)e2).getChild()).getInferredJavaType().getJavaTypeInstance().implicitlyCastsTo(e2.getInferredJavaType().getJavaTypeInstance(), null)) {
                            e2 = ce;
                        }
                        reverseAppendChain.add(e2);
                        return this.genStringConcat(reverseAppendChain);
                    }
                    case 0: 
                }
                return this.genStringConcat(reverseAppendChain);
            }
            reverseAppendChain.add(e);
        } while (lhs != null);
        return null;
    }

    private Expression genStringConcat(List<Expression> revList) {
        int x;
        JavaTypeInstance lastType = revList.get(revList.size() - 1).getInferredJavaType().getJavaTypeInstance();
        if (lastType instanceof RawJavaType) {
            revList.add(new Literal(TypedLiteral.getString("\"\"")));
        }
        if ((x = revList.size() - 1) < 0) {
            return null;
        }
        Expression head = revList.get(x);
        InferredJavaType inferredJavaType = new InferredJavaType(TypeConstants.STRING, InferredJavaType.Source.STRING_TRANSFORM, true);
        --x;
        while (x >= 0) {
            Expression appendee = revList.get(x);
            head = new ArithmeticOperation(inferredJavaType, head, appendee, ArithOp.PLUS);
            --x;
        }
        return head;
    }
}

