/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.jsp.tags;

import java.io.IOException;
import java.io.Writer;
import java.rmi.Naming;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.jsp.logic.InvoiceManager;
import org.igoweb.igoweb.jsp.logic.PayPalIpnServlet;
import org.igoweb.igoweb.jsp.tags.SessionAttrs;
import org.igoweb.igoweb.shared.IBundle;
import org.igoweb.igoweb.shared.Locales;
import org.igoweb.igoweb.shared.User;
import org.igoweb.igoweb.shared.server.ServerControl;
import org.igoweb.resource.Plural;
import org.igoweb.util.DbConn;
import org.igoweb.util.DbConnFactory;
import org.igoweb.util.ThreadPool;
import org.igoweb.util.jsp.XhtmlToHtmlFilter;

public class BaseTag
extends SimpleTagSupport {
    public static final String DB_REPL_CONN_FACTORY_KEY = "slaveFactory";
    public static final String DB_MASTER_CONN_FACTORY_KEY = "masterFactory";
    public static final String DB_LOG_REPL_CONN_FACTORY_KEY = "logSlaveFactory";
    public static final String DB_LOG_CONN_FACTORY_KEY = "logFactory";
    public static final String BUNDLE_KEY = "bundle";
    public static final String XHTML_KEY = BaseTag.class.getName() + ":xhtml";
    public static final String THREAD_POOL_KEY = BaseTag.class.getName() + ":threadPool";
    public static final String FORM_ID_KEY = BaseTag.class.getName() + ":formId";
    private static final Object[] VERSION_VALUES = new Object[]{Config.get("version.major"), Config.get("version.minor"), Config.get("version.bugfix")};
    private static final String TZ_COOKIE_NAME = "timeZone";
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Random rand = new Random();
    private DbConnFactory masterDbConnFactory;
    private DbConnFactory replicatedDbConnFactory;
    private IBundle bundle;
    private String userName;
    private TimeZone tz;
    private NumberFormat numFormat;
    private boolean changeTimeZone;
    private int month = -1;
    private int year = -1;
    private boolean explicitYear = false;
    private Calendar cal;
    public static final boolean IS_BETA = Config.get("version.beta") != null;
    private String formId;

    public void doTag() throws JspException, IOException {
        PageContext context = (PageContext)this.getJspContext();
        BaseTag.testLogOut(context);
        context.setAttribute("base", (Object)this);
        this.bundle = (IBundle)context.getAttribute(BUNDLE_KEY, 2);
        this.initTag();
        this.doPage();
    }

    protected void initTag() throws JspException, IOException {
        if (this.changeTimeZone) {
            this.doChangeTimeZone();
        }
    }

    protected void doPage() throws JspException, IOException {
        PageContext context = (PageContext)this.getJspContext();
        Object out = context.getOut();
        if (context.getAttribute(XHTML_KEY, 2) != null) {
            ((Writer)out).write("<?xml version=\"1.0\" encoding=\"");
            ((Writer)out).write(context.getResponse().getCharacterEncoding());
            ((Writer)out).write("\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        } else {
            ((Writer)out).write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n<html>");
            out = new XhtmlToHtmlFilter((Writer)out);
        }
        this.getJspBody().invoke((Writer)out);
        ((Writer)out).write("</html>");
    }

    public String getLocaleId() {
        return this.bundle.locale.toString();
    }

    public IBundle getBundle() throws JspException, IOException {
        return this.bundle;
    }

    public static String findLocale(String acceptedLanguages) {
        if (acceptedLanguages == null) {
            return Locales.DEFAULT;
        }
        String[] prefs = acceptedLanguages.trim().split("[,;]");
        for (int i = 0; i < prefs.length; ++i) {
            String localeId;
            String trial = prefs[i].trim().toLowerCase(Locale.US);
            int dashLoc = trial.indexOf(45);
            if (dashLoc >= 0) {
                trial = trial.replace('-', '_');
            }
            if ((localeId = Locales.getCanonLocaleId(trial)) != null) {
                return localeId;
            }
            if (dashLoc < 0 || (localeId = Locales.getCanonLocaleId(trial.substring(0, dashLoc))) == null) continue;
            return localeId;
        }
        return Locales.DEFAULT;
    }

    public DbConnFactory getDbConnFactory() {
        return this.getDbConnFactory(false);
    }

    public DbConnFactory getDbConnFactory(boolean masterRequired) {
        DbConnFactory result;
        DbConnFactory dbConnFactory = result = masterRequired ? this.masterDbConnFactory : this.replicatedDbConnFactory;
        if (result == null) {
            result = BaseTag.getDbConnFactory(this.getJspContext(), masterRequired);
            if (masterRequired) {
                this.masterDbConnFactory = result;
            } else {
                this.replicatedDbConnFactory = result;
            }
        }
        return result;
    }

    public static DbConnFactory getDbConnFactory(JspContext context) {
        return BaseTag.getDbConnFactory(context, false);
    }

    public static DbConnFactory getDbConnFactory(JspContext context, boolean masterRequired) {
        return (DbConnFactory)context.getAttribute(masterRequired ? DB_MASTER_CONN_FACTORY_KEY : DB_REPL_CONN_FACTORY_KEY, 4);
    }

    public DbConnFactory getLogFactory(boolean master) {
        return (DbConnFactory)this.getJspContext().getAttribute(master ? DB_LOG_CONN_FACTORY_KEY : DB_LOG_REPL_CONN_FACTORY_KEY, 4);
    }

    public static Logger getLogger() {
        return Logger.getLogger(BaseTag.class.getName());
    }

    public DbConn getDbConn() {
        return this.getDbConn(false);
    }

    public DbConn getDbConn(boolean masterRequired) {
        return this.getDbConnFactory(masterRequired).getDbConn();
    }

    public String getUserName() {
        if (this.userName == null) {
            this.userName = ((PageContext)this.getJspContext()).getRequest().getParameter("user");
            this.userName = this.userName == null ? "" : this.userName.trim();
        }
        return this.userName;
    }

    public TimeZone getTimeZone() {
        if (this.tz == null) {
            PageContext context = (PageContext)this.getJspContext();
            this.tz = BaseTag.getTimeZone((HttpServletRequest)context.getRequest());
        }
        return this.tz;
    }

    public static TimeZone getTimeZone(HttpServletRequest req) {
        String tzName = req.getParameter("tz");
        if (tzName != null) {
            return TimeZone.getTimeZone(tzName);
        }
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(TZ_COOKIE_NAME)) continue;
                return TimeZone.getTimeZone(cookies[i].getValue());
            }
        }
        return GMT;
    }

    public String getLocalTZ() throws JspException, IOException {
        TimeZone localTz = this.getTimeZone();
        return localTz.getDisplayName(localTz.inDaylightTime(new Date()), 0, this.getBundle().locale);
    }

    public boolean isGmtTz() {
        return this.getTimeZone().equals(GMT);
    }

    public String getLocalTimeZone() throws JspException, IOException {
        TimeZone localTz = this.getTimeZone();
        return localTz.getDisplayName(localTz.inDaylightTime(new Date()), 1, this.getBundle().locale);
    }

    private void doChangeTimeZone() {
        PageContext context = (PageContext)this.getJspContext();
        HttpServletRequest req = (HttpServletRequest)context.getRequest();
        String tzName = req.getParameter("tz");
        if (tzName != null) {
            this.tz = TimeZone.getTimeZone(tzName);
            Cookie cookie = new Cookie(TZ_COOKIE_NAME, this.tz.getID());
            cookie.setPath("/");
            cookie.setMaxAge(63072000);
            ((HttpServletResponse)context.getResponse()).addCookie(cookie);
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals(TZ_COOKIE_NAME)) continue;
                    cookies[i].setMaxAge(0);
                }
            }
        }
    }

    public static BaseTag getBase(SimpleTag innerTag) {
        return (BaseTag)BaseTag.findAncestorWithClass((JspTag)innerTag, BaseTag.class);
    }

    public NumberFormat getNumberFormat() {
        if (this.numFormat == null) {
            this.numFormat = NumberFormat.getInstance(this.bundle.locale);
        }
        return this.numFormat;
    }

    public void setChangeTimeZone(boolean change) {
        this.changeTimeZone = change;
    }

    public ThreadPool getThreadPool() {
        return BaseTag.getThreadPool(this.getJspContext());
    }

    public static ThreadPool getThreadPool(JspContext context) {
        return (ThreadPool)context.getAttribute(THREAD_POOL_KEY, 4);
    }

    public String getLocalVersion() {
        return this.bundle.str(-669080761, VERSION_VALUES);
    }

    public String getLocalFullVersion() {
        return this.bundle.str(310422605, VERSION_VALUES);
    }

    public String getFormId() {
        if (this.formId == null) {
            this.formId = Integer.toString(rand.nextInt());
            this.getJspContext().setAttribute(FORM_ID_KEY, (Object)this.formId, 3);
        }
        return this.formId;
    }

    protected boolean isFormIdMatch() {
        PageContext context = (PageContext)this.getJspContext();
        Object storedId = context.getAttribute(FORM_ID_KEY, 3);
        if (storedId == null) {
            return false;
        }
        context.removeAttribute(FORM_ID_KEY, 3);
        return storedId.equals(context.getRequest().getParameter("formId"));
    }

    public boolean isBeta() {
        return IS_BETA;
    }

    public static String canonName(String name) {
        return name == null ? null : User.canonName(name.trim());
    }

    public static int getPluralCode(int value, BaseTag base) {
        return Plural.getCategory(value, base.bundle.locale);
    }

    public static String refreshBadNamesList() {
        try {
            ((ServerControl)Naming.lookup(ServerControl.RMI_URL)).refreshBadNamesList();
            return null;
        }
        catch (Exception excep) {
            return excep.toString();
        }
    }

    public String getMonthList() throws JspException, IOException {
        return this.getMonthListWithDefault(this.getMonth());
    }

    public final int getMonth() {
        if (this.month == -1) {
            this.month = this.computeMonth();
        }
        return this.month;
    }

    public final int getYear() {
        if (this.year == -1) {
            this.year = this.computeYear();
        }
        return this.year;
    }

    protected int computeMonth() {
        String curMonth = ((PageContext)this.getJspContext()).getRequest().getParameter("month");
        if (curMonth != null) {
            try {
                return Integer.parseInt(curMonth);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getCalendar().get(2) - 0 + 1;
    }

    protected Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = Calendar.getInstance(this.getTimeZone(), this.bundle.locale);
        }
        return this.cal;
    }

    protected int computeYear() {
        String curYear = ((PageContext)this.getJspContext()).getRequest().getParameter("year");
        if (curYear != null) {
            try {
                int result = Integer.parseInt(curYear);
                this.explicitYear = true;
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getCalendar().get(1);
    }

    protected void setYear(int year) {
        this.year = year;
    }

    public boolean isYearExplicit() {
        if (this.year == -1) {
            this.getYear();
        }
        return this.explicitYear;
    }

    public String getMonthListWithDefault(int defaultMonth) throws JspException, IOException {
        String[] strings = new SimpleDateFormat("MMM", this.getBundle().locale).getDateFormatSymbols().getShortMonths();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 12; ++i) {
            result.append("<option value=\"").append(i + 1).append(i + 1 == defaultMonth ? "\" selected=\"selected\">" : "\">").append(strings[i]).append("</option>");
        }
        return result.toString();
    }

    public PageContext getPageContext() {
        return (PageContext)this.getJspContext();
    }

    public static String getNameAndRank(BaseTag base, User user) throws JspException, IOException {
        return user.getNameAndRank(base.getBundle());
    }

    public static void testLogOut(PageContext context) {
        if (context.getRequest().getParameter("logout") != null) {
            context.removeAttribute("authLevel", 3);
            context.removeAttribute(SessionAttrs.LOGIN_NAME, 3);
            context.removeAttribute(SessionAttrs.LOGIN_ID, 3);
            context.removeAttribute("translator", 3);
            context.removeAttribute("advertiser", 3);
        }
    }

    public InvoiceManager getInvoiceManager() {
        return (InvoiceManager)this.getJspContext().getAttribute(PayPalIpnServlet.INVOICE_MANAGER_KEY, 4);
    }
}

