/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.jsp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.igoweb.util.DbConn;
import org.igoweb.util.DbConnFactory;
import org.igoweb.util.jsp.AbstractInvoice;
import org.igoweb.util.jsp.AbstractInvoiceManager;
import org.igoweb.util.jsp.InvoiceState;

public abstract class AbstractPayPalIpnServlet<InvoiceT extends AbstractInvoice, UserT, ProductT, ImT extends AbstractInvoiceManager<ProductT, InvoiceT>>
extends HttpServlet {
    private DbConnFactory factory;
    private ImT invoiceManager;
    private static final String URLENCODER_CHARACTER_ENCODING = "UTF-8";
    private URL confirmUrl;

    public void init() {
        try {
            this.confirmUrl = new URL("https://" + this.getPayPalHost() + "/cgi-bin/webscr");
        }
        catch (MalformedURLException excep) {
            throw new RuntimeException("Bad url?", excep);
        }
    }

    protected void setDbConnFactory(DbConnFactory factory) {
        this.factory = factory;
    }

    protected DbConnFactory getDbConnFactory() {
        return this.factory;
    }

    protected void setInvoiceManager(ImT invoiceManager) {
        this.invoiceManager = invoiceManager;
    }

    protected abstract boolean isDestValid(String var1);

    protected ImT getInvoiceManager() {
        return this.invoiceManager;
    }

    protected abstract String getPayPalHost();

    protected abstract Logger getLogger();

    protected abstract String getCurrencyNeeded();

    protected abstract UserT getUser(String var1, String var2);

    protected abstract boolean isPurchaseValid(UserT var1, ProductT var2, double var3) throws SQLException;

    protected DbConn getDbConn() {
        return this.factory.getDbConn();
    }

    protected abstract InvoiceT createInvoice(UserT var1, ProductT var2, double var3, double var5, String var7);

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ResultSet rs;
        DbConn db;
        block47: {
            block46: {
                block45: {
                    block44: {
                        String verifyCmd = "<unknown>";
                        db = null;
                        rs = null;
                        try {
                            Object invoice;
                            InvoiceState invoiceState;
                            int productId;
                            verifyCmd = this.makeVerifyCmd(request, false);
                            this.getLogger().fine("Verifying paypal transaction: " + verifyCmd);
                            URLConnection conn = this.confirmUrl.openConnection();
                            conn.setDoOutput(true);
                            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                            PrintWriter pw = new PrintWriter(conn.getOutputStream());
                            pw.println(this.makeVerifyCmd(request, true));
                            pw.close();
                            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                            String result = in.readLine();
                            in.close();
                            if (result.equals("INVALID")) {
                                this.bogusReq(verifyCmd, "Paypal says transaction is invalid!");
                                response.setStatus(200);
                                return;
                            }
                            if (!result.equals("VERIFIED")) {
                                this.bogusReq(verifyCmd, "Unknown response " + result + " when verifying command");
                                response.sendError(500);
                                return;
                            }
                            response.setStatus(200);
                            if (!this.isDestValid(request.getParameter("receiver_email"))) {
                                this.bogusReq(verifyCmd, "Receiver email is not mine!");
                                return;
                            }
                            if (!"web_accept".equals(request.getParameter("txn_type"))) {
                                this.bogusReq(verifyCmd, "Is not a payment transaction (txn_type is not set to \"web_accept\")");
                                return;
                            }
                            UserT user = this.getUser(request.getParameter("payer_email"), request.getParameter("custom"));
                            if (user == null) {
                                this.bogusReq(verifyCmd, "Cannot determine user account");
                                return;
                            }
                            String productIdString = request.getParameter("item_number");
                            try {
                                productId = productIdString == null ? -1 : Integer.parseInt(productIdString);
                            }
                            catch (NumberFormatException excep) {
                                productId = -1;
                            }
                            Object product = ((AbstractInvoiceManager)this.invoiceManager).getProduct(productId);
                            if (product == null) {
                                this.bogusReq(verifyCmd, "Unknown product ID " + productId);
                                return;
                            }
                            double paymentAmount = Double.parseDouble(request.getParameter("mc_gross"));
                            String feeStr = request.getParameter("mc_fee");
                            double fee = feeStr == null ? -1.0 : Double.parseDouble(feeStr);
                            String currency = request.getParameter("mc_currency");
                            if (!currency.equals(this.getCurrencyNeeded())) {
                                String settleCur = request.getParameter("settle_currency");
                                if (settleCur == null || !settleCur.equals(this.getCurrencyNeeded())) {
                                    this.bogusReq(verifyCmd, "Wanted currency of " + this.getCurrencyNeeded() + "; got " + currency + "/" + settleCur);
                                    return;
                                }
                                double exchange = Double.parseDouble("exchange_rate");
                                paymentAmount *= exchange;
                                if (fee >= 0.0) {
                                    fee *= exchange;
                                }
                            }
                            if (!this.isPurchaseValid(user, product, paymentAmount)) {
                                this.bogusReq(verifyCmd, "Product " + product + " isn't valid with payment of " + paymentAmount + " and user " + user);
                                return;
                            }
                            String status = request.getParameter("payment_status");
                            if (status.equals("Completed")) {
                                invoiceState = InvoiceState.SUCCESS;
                            } else if (status.equals("Pending")) {
                                invoiceState = InvoiceState.REVIEW;
                            } else {
                                if (!status.equals("Failed") && !status.equals("Denied")) {
                                    this.bogusReq(verifyCmd, "Unexpected payment status: " + request.getParameter("payment_status"));
                                    if (db == null) return;
                                    db.close(rs);
                                    return;
                                }
                                invoiceState = InvoiceState.DENIED;
                            }
                            db = this.getDbConn();
                            PreparedStatement ps = db.get("SELECT invoice_id  FROM invoices_pay_pal_txn_id  WHERE pay_pal_id = ?");
                            ps.setString(1, request.getParameter("txn_id"));
                            rs = ps.executeQuery();
                            int invoiceId = rs.next() ? rs.getInt("invoice_id") : -1;
                            rs.close();
                            rs = null;
                            if (invoiceId == -1) {
                                if (invoiceState == InvoiceState.DENIED) {
                                    this.bogusReq(verifyCmd, "Non-pending transaction was denied; ignoring");
                                    if (db == null) return;
                                    break block44;
                                }
                                invoice = this.createInvoice(user, product, paymentAmount, fee, "Pay pal setup");
                                if (invoice == null) {
                                    this.bogusReq(verifyCmd, "Could not create an invoice");
                                    if (db == null) return;
                                    break block45;
                                }
                                ps = db.get("INSERT INTO invoices_pay_pal_txn_id    (pay_pal_id, invoice_id)  VALUES (?, ?)");
                                ps.setString(1, request.getParameter("txn_id"));
                                ps.setInt(2, ((AbstractInvoice)invoice).id);
                                ps.execute();
                            } else {
                                invoice = ((AbstractInvoiceManager)this.invoiceManager).getInvoice(invoiceId);
                                if (fee >= 0.0 && fee != ((AbstractInvoice)invoice).getFee()) {
                                    ((AbstractInvoice)invoice).setFee(db, fee);
                                }
                                if (invoice == null) {
                                    this.bogusReq(verifyCmd, "Cannot find invoice " + invoiceId);
                                    if (db == null) return;
                                    break block46;
                                }
                            }
                            if (!((AbstractInvoiceManager)this.invoiceManager).setState(invoice, invoiceState, verifyCmd)) {
                                this.bogusReq(verifyCmd, "Failed to set state to " + (Object)((Object)invoiceState));
                            }
                            if (db == null) return;
                            break block47;
                        }
                        catch (SQLException excep) {
                            this.getLogger().log(Level.SEVERE, "SQL error processing transaction", excep);
                            return;
                        }
                        catch (Throwable thrown) {
                            this.getLogger().log(Level.SEVERE, "Exception while processing IPN command; query=" + verifyCmd, thrown);
                            return;
                        }
                    }
                    db.close(rs);
                    return;
                }
                db.close(rs);
                return;
            }
            db.close(rs);
            return;
        }
        db.close(rs);
        return;
        finally {
            if (db != null) {
                db.close(rs);
            }
        }
    }

    private String makeVerifyCmd(HttpServletRequest req, boolean encode) {
        try {
            StringBuilder cmd = new StringBuilder();
            if (encode) {
                cmd.append("cmd=_notify-validate");
            }
            Enumeration en = req.getParameterNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (encode) {
                    cmd.append('&').append(key).append('=').append(URLEncoder.encode(req.getParameter(key), URLENCODER_CHARACTER_ENCODING));
                    continue;
                }
                if (cmd.length() > 0) {
                    cmd.append(", ");
                }
                cmd.append(key).append('=').append(req.getParameter(key));
            }
            return cmd.toString();
        }
        catch (UnsupportedEncodingException excep) {
            throw new RuntimeException("Don't know UTF-8", excep);
        }
    }

    private void bogusReq(String verifyCmd, String reason) {
        this.getLogger().warning("Ignoring IPN request; " + reason + ": " + verifyCmd);
    }
}

