/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.service.impl;

import com.amazon.aes.service.S3Connection;
import com.amazon.aes.service.impl.S3ServiceImpl;
import com.amazon.aes.util.LangUtils;
import com.amazon.aes.util.S3Utils;
import com.amazon.aes.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3ConnectionImpl
implements S3Connection {
    private static final int STREAM_COPY_BUFFER_SIZE = 8192;
    private static final int COPY_RETRIES = 3;
    private final String bucketSignName;
    private final String s3BaseUrl;
    private final String userName;
    private final String password;
    private final String bucketName;

    public S3ConnectionImpl(S3ServiceImpl.S3ConnectionHelper connectionHelper, String bucketName, String userName, String password) {
        this.bucketSignName = connectionHelper.getBucketName(bucketName);
        this.s3BaseUrl = connectionHelper.getBaseUrl(bucketName);
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = password;
    }

    @Override
    public S3Connection.OperationResult copy(String key, String source, Map<String, String> options) {
        int retry = 0;
        int code = 0;
        String errorMessage = null;
        while (retry < 3) {
            try {
                options = new HashMap<String, String>(options);
                options.put("x-amz-copy-source", source);
                PutMethod putMethod = S3Utils.put(this.s3BaseUrl + key, this.bucketSignName, null, "", this.userName, this.password, options);
                code = putMethod.getStatusCode();
                errorMessage = S3ConnectionImpl.getErrorResponse(putMethod.getResponseBodyAsStream());
                if (code != 200 || errorMessage != null) continue;
                return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.OK, (String)null);
            }
            catch (SocketTimeoutException e) {
                return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.TIMEOUT, "Operation timed out.");
            }
            catch (IOException e) {
                throw new RuntimeException("Error putting copy request", e);
            }
        }
        if (code == 200) {
            return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.FAILED, errorMessage);
        }
        return S3ConnectionImpl.createOperationResult(this.translateStatusCode(code), errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S3Connection.OperationResult get(String key, OutputStream outputStream) {
        try {
            GetMethod method = S3Utils.get(this.s3BaseUrl + key, this.bucketSignName, null, this.userName, this.password);
            int code = method.getStatusCode();
            switch (code) {
                case 200: {
                    break;
                }
                case 403: {
                    return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.NOT_AUTHORIZED, method.getResponseBodyAsStream());
                }
                case 404: {
                    return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.NOT_FOUND, method.getResponseBodyAsStream());
                }
                case 500: {
                    return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.SERVER_ERROR, method.getResponseBodyAsStream());
                }
                default: {
                    throw new RuntimeException("Unexpected status code: " + code);
                }
            }
            InputStream inputStream = method.getResponseBodyAsStream();
            try {
                S3ConnectionImpl.copyStream(inputStream, outputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from bucket", e);
        }
        return S3ConnectionImpl.createOperationResult(S3Connection.OperationCode.OK, (String)null);
    }

    @Override
    public S3Connection.OperationValueResult<List<String>> getAcls(String key) {
        try {
            GetMethod method = S3Utils.get(this.s3BaseUrl + key + "?acl", this.bucketSignName, "acl", this.userName, this.password);
            int code = method.getStatusCode();
            switch (code) {
                case 200: {
                    break;
                }
                case 403: {
                    return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.NOT_AUTHORIZED, method.getResponseBodyAsStream());
                }
                case 404: {
                    return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.NOT_FOUND, method.getResponseBodyAsStream());
                }
                case 500: {
                    return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.SERVER_ERROR, method.getResponseBodyAsStream());
                }
                default: {
                    throw new RuntimeException("Unexpected status code: " + code);
                }
            }
            try {
                Document document = XmlUtils.readXml(method.getResponseBody());
                return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.OK, null, Collections.singletonList(XmlUtils.toXmlString(document, true)));
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading ACL response", e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from bucket", e);
        }
    }

    @Override
    public S3Connection.OperationValueResult<List<String>> getContentList() {
        return this.getContentList(null);
    }

    @Override
    public S3Connection.OperationValueResult<List<String>> getContentList(String prefix) {
        try {
            boolean truncated;
            DocumentBuilder documentBuilder;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Unexpected error creating the document builder");
            }
            ArrayList<String> contentList = new ArrayList<String>();
            do {
                ArrayList<String> urlParams = new ArrayList<String>();
                if (!contentList.isEmpty()) {
                    urlParams.add("marker");
                    urlParams.add((String)contentList.get(contentList.size() - 1));
                }
                if (prefix != null && prefix.length() > 0) {
                    urlParams.add("prefix");
                    urlParams.add(prefix);
                }
                String url = S3ConnectionImpl.createUrl(this.s3BaseUrl, urlParams);
                GetMethod method = S3Utils.get(url, this.bucketSignName, null, this.userName, this.password);
                int code = method.getStatusCode();
                switch (code) {
                    case 200: {
                        break;
                    }
                    case 403: {
                        return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.NOT_AUTHORIZED, method.getResponseBodyAsStream());
                    }
                    case 404: {
                        return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.NOT_FOUND, method.getResponseBodyAsStream());
                    }
                    case 500: {
                        return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.SERVER_ERROR, method.getResponseBodyAsStream());
                    }
                    default: {
                        throw new RuntimeException("Unexpected status code: " + code);
                    }
                }
                try {
                    Document document = documentBuilder.parse(method.getResponseBodyAsStream());
                    truncated = this.readContentListFromResponse(document, contentList);
                }
                catch (SAXException e) {
                    throw new RuntimeException("Error reading response", e);
                }
            } while (truncated);
            return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.OK, null, contentList);
        }
        catch (IOException e) {
            throw new RuntimeException("Got unexpected I/O exception while reading S3 response", e);
        }
    }

    @Override
    public S3Connection.OperationResult upload(String key, String mimeType, InputStream inputStream, Map<String, String> options) {
        try {
            PutMethod method = S3Utils.put(this.s3BaseUrl + key, this.bucketSignName, null, inputStream, mimeType, this.userName, this.password, options);
            int code = method.getStatusCode();
            return S3ConnectionImpl.createOperationResult(this.translateStatusCode(code), method.getResponseBodyAsStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Got unexpected I/O exception while doing S3 request", e);
        }
    }

    @Override
    public S3Connection.OperationResult createBucket() {
        return this.createBucket(null);
    }

    @Override
    public S3Connection.OperationResult createBucket(String location) {
        try {
            String body = "US".equals(location) ? null : "<CreateBucketConfiguration><LocationConstraint>" + location + "</LocationConstraint></CreateBucketConfiguration>";
            PutMethod method = S3Utils.put(this.s3BaseUrl, this.bucketSignName, null, body, this.userName, this.password);
            int code = method.getStatusCode();
            return S3ConnectionImpl.createOperationResult(this.translateStatusCode(code), S3ConnectionImpl.getErrorResponse(method.getResponseBodyAsStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Got unexpected I/O exception while doing S3 request", e);
        }
    }

    @Override
    public S3Connection.OperationResult bucketStatus() {
        try {
            HeadMethod method = S3Utils.head(this.s3BaseUrl, this.bucketSignName, null, this.userName, this.password);
            int code = method.getStatusCode();
            return S3ConnectionImpl.createOperationResult(this.translateStatusCode(code), S3ConnectionImpl.getErrorResponse(method.getResponseBodyAsStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Got unexpected I/O exception while doing S3 request", e);
        }
    }

    @Override
    public S3Connection.OperationValueResult<String> bucketLocation() {
        try {
            GetMethod method = S3Utils.get(this.s3BaseUrl + "?location", this.bucketSignName, "location", this.userName, this.password);
            int code = method.getStatusCode();
            if (code == 200) {
                String location = S3ConnectionImpl.extractLocationConstraint(method.getResponseBodyAsStream());
                if (location == null || location.length() == 0) {
                    location = "US";
                }
                return S3ConnectionImpl.createOperationValueResult(S3Connection.OperationCode.OK, null, location);
            }
            return S3ConnectionImpl.createOperationValueResult(this.translateStatusCode(code), S3ConnectionImpl.getErrorResponse(method.getResponseBodyAsStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Got unexpected I/O exception while doing S3 request", e);
        }
    }

    private boolean readContentListFromResponse(Document document, List<String> contentList) {
        NodeList truncatedNodeList = document.getElementsByTagName("IsTruncated");
        int truncatedLen = truncatedNodeList.getLength();
        boolean truncated = truncatedLen == 0 ? false : Boolean.parseBoolean(truncatedNodeList.item(0).getTextContent());
        NodeList contentsNodeList = document.getElementsByTagName("Contents");
        int contentLen = contentsNodeList.getLength();
        for (int i = 0; i < contentLen; ++i) {
            Element content = (Element)contentsNodeList.item(i);
            NodeList keyNodeList = content.getElementsByTagName("Key");
            contentList.add(keyNodeList.item(0).getTextContent());
        }
        return truncated;
    }

    private S3Connection.OperationCode translateStatusCode(int code) {
        switch (code) {
            case 200: {
                return S3Connection.OperationCode.OK;
            }
            case 301: 
            case 307: {
                return S3Connection.OperationCode.RESOURCE_MOVED;
            }
            case 403: {
                return S3Connection.OperationCode.NOT_AUTHORIZED;
            }
            case 404: {
                return S3Connection.OperationCode.NOT_FOUND;
            }
            case 409: {
                return S3Connection.OperationCode.CONFLICT;
            }
            case 500: {
                return S3Connection.OperationCode.SERVER_ERROR;
            }
        }
        throw new RuntimeException("Unexpected status code: " + code);
    }

    protected static String extractLocationConstraint(InputStream inputStream) {
        Document document;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unexpected error creating the document builder");
        }
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse answer", e);
        }
        String tag = document.getDocumentElement().getTagName();
        if (!"LocationConstraint".equals(tag)) {
            throw new RuntimeException("Expected root element LocationConstraint, but got " + tag);
        }
        return document.getDocumentElement().getTextContent();
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = inputStream.read(buf)) != -1) {
            outputStream.write(buf, 0, len);
        }
        outputStream.flush();
    }

    public String toString() {
        return "S3Connection[bucket=" + this.bucketName + "]";
    }

    private static String createUrl(String baseUrl, List<String> params) {
        if (params.size() % 2 != 0) {
            throw new RuntimeException("nr of params must be even");
        }
        StringBuilder stringBuilder = new StringBuilder(baseUrl);
        if (!params.isEmpty()) {
            for (int i = 0; i < params.size(); i += 2) {
                stringBuilder.append(i == 0 ? "?" : "&");
                try {
                    stringBuilder.append(params.get(i)).append("=").append(URLEncoder.encode(params.get(i + 1), "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Could not encode parameter ", e);
                }
            }
        }
        return stringBuilder.toString();
    }

    protected static String getErrorResponse(InputStream inputStream) {
        Document document;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException e) throws SAXException {
                    throw new RuntimeException("Error parsing", e);
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    throw new RuntimeException("Error parsing", e);
                }

                public void warning(SAXParseException exception) throws SAXException {
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unexpected error creating the document builder");
        }
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (Exception e) {
            return null;
        }
        if (!"Error".equals(document.getDocumentElement().getNodeName())) {
            return null;
        }
        String errorMessage = XmlUtils.getTextFromDocument(document, "/Error/Message");
        if (!LangUtils.isEmpty(errorMessage)) {
            return errorMessage;
        }
        return LangUtils.defaultStr(XmlUtils.getTextFromDocument(document, "/Error/Code"), "Error");
    }

    private static S3Connection.OperationResult createOperationResult(S3Connection.OperationCode operationCode, InputStream inputStream) {
        return S3ConnectionImpl.createOperationResult(operationCode, inputStream == null ? null : S3ConnectionImpl.getErrorResponse(inputStream));
    }

    private static S3Connection.OperationResult createOperationResult(final S3Connection.OperationCode operationCode, final String msg) {
        return new S3Connection.OperationResult(){

            public S3Connection.OperationCode getOperationCode() {
                return operationCode;
            }

            public String getMsg() {
                return msg;
            }
        };
    }

    private static <T> S3Connection.OperationValueResult<T> createOperationValueResult(final S3Connection.OperationCode operationCode, final String msg, final T value) {
        return new S3Connection.OperationValueResult<T>(){

            @Override
            public S3Connection.OperationCode getOperationCode() {
                return operationCode;
            }

            @Override
            public String getMsg() {
                return msg;
            }

            @Override
            public T getValue() {
                return value;
            }
        };
    }

    private static <T> S3Connection.OperationValueResult<T> createOperationValueResult(S3Connection.OperationCode operationCode, InputStream inputStream) {
        return S3ConnectionImpl.createOperationValueResult(operationCode, inputStream == null ? null : S3ConnectionImpl.getErrorResponse(inputStream));
    }

    private static <T> S3Connection.OperationValueResult<T> createOperationValueResult(final S3Connection.OperationCode operationCode, final String msg) {
        if (S3Connection.OperationCode.OK == operationCode) {
            throw new RuntimeException("Must not create an OperationValueResult w/o value where result is OK");
        }
        return new S3Connection.OperationValueResult<T>(){

            @Override
            public S3Connection.OperationCode getOperationCode() {
                return operationCode;
            }

            @Override
            public T getValue() {
                throw new RuntimeException("Called getValue() on an operation result that has no value. Operation result: " + (Object)((Object)operationCode));
            }

            @Override
            public String getMsg() {
                return msg;
            }
        };
    }
}

