/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.util.function.Predicate;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.LocalClusterUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterHealthAction
extends TransportMasterNodeReadAction<ClusterHealthRequest, ClusterHealthResponse> {
    private final GatewayAllocator gatewayAllocator;

    @Inject
    public TransportClusterHealthAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, GatewayAllocator gatewayAllocator) {
        super(settings, "cluster:monitor/health", false, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClusterHealthRequest::new);
        this.gatewayAllocator = gatewayAllocator;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterHealthRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected ClusterHealthResponse newResponse() {
        return new ClusterHealthResponse();
    }

    @Override
    protected final void masterOperation(ClusterHealthRequest request, ClusterState state, ActionListener<ClusterHealthResponse> listener) throws Exception {
        this.logger.warn("attempt to execute a cluster health operation without a task");
        throw new UnsupportedOperationException("task parameter is required for this operation");
    }

    @Override
    protected void masterOperation(Task task, final ClusterHealthRequest request, ClusterState unusedState, final ActionListener<ClusterHealthResponse> listener) {
        if (request.waitForEvents() != null) {
            final long endTimeMS = TimeValue.nsecToMSec((long)System.nanoTime()) + request.timeout().millis();
            if (request.local()) {
                this.clusterService.submitStateUpdateTask("cluster_health (wait_for_events [" + (Object)((Object)request.waitForEvents()) + "])", new LocalClusterUpdateTask(request.waitForEvents()){

                    @Override
                    public ClusterStateTaskExecutor.ClusterTasksResult<LocalClusterUpdateTask> execute(ClusterState currentState) {
                        return 1.unchanged();
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        long timeoutInMillis = Math.max(0L, endTimeMS - TimeValue.nsecToMSec((long)System.nanoTime()));
                        TimeValue newTimeout = TimeValue.timeValueMillis((long)timeoutInMillis);
                        request.timeout(newTimeout);
                        TransportClusterHealthAction.this.executeHealth(request, listener);
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        TransportClusterHealthAction.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                        listener.onFailure(e);
                    }
                });
            } else {
                this.clusterService.submitStateUpdateTask("cluster_health (wait_for_events [" + (Object)((Object)request.waitForEvents()) + "])", new ClusterStateUpdateTask(request.waitForEvents()){

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        return currentState;
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        long timeoutInMillis = Math.max(0L, endTimeMS - TimeValue.nsecToMSec((long)System.nanoTime()));
                        TimeValue newTimeout = TimeValue.timeValueMillis((long)timeoutInMillis);
                        request.timeout(newTimeout);
                        TransportClusterHealthAction.this.executeHealth(request, listener);
                    }

                    @Override
                    public void onNoLongerMaster(String source) {
                        TransportClusterHealthAction.this.logger.trace("stopped being master while waiting for events with priority [{}]. retrying.", (Object)request.waitForEvents());
                        listener.onFailure(new NotMasterException("no longer master. source: [" + source + "]"));
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        TransportClusterHealthAction.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                        listener.onFailure(e);
                    }
                });
            }
        } else {
            this.executeHealth(request, listener);
        }
    }

    private void executeHealth(final ClusterHealthRequest request, final ActionListener<ClusterHealthResponse> listener) {
        int waitFor = 0;
        if (request.waitForStatus() != null) {
            ++waitFor;
        }
        if (request.waitForNoRelocatingShards()) {
            ++waitFor;
        }
        if (request.waitForNoInitializingShards()) {
            ++waitFor;
        }
        if (!request.waitForActiveShards().equals(ActiveShardCount.NONE)) {
            ++waitFor;
        }
        if (!request.waitForNodes().isEmpty()) {
            ++waitFor;
        }
        if (request.indices() != null && request.indices().length > 0) {
            ++waitFor;
        }
        ClusterState state = this.clusterService.state();
        final ClusterStateObserver observer = new ClusterStateObserver(state, this.clusterService, null, this.logger, this.threadPool.getThreadContext());
        if (request.timeout().millis() == 0L) {
            listener.onResponse(this.getResponse(request, state, waitFor, request.timeout().millis() == 0L));
            return;
        }
        final int concreteWaitFor = waitFor;
        Predicate<ClusterState> validationPredicate = newState -> this.validateRequest(request, (ClusterState)newState, concreteWaitFor);
        ClusterStateObserver.Listener stateListener = new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState clusterState) {
                listener.onResponse(TransportClusterHealthAction.this.getResponse(request, clusterState, concreteWaitFor, false));
            }

            @Override
            public void onClusterServiceClose() {
                listener.onFailure(new IllegalStateException("ClusterService was close during health call"));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                ClusterHealthResponse response = TransportClusterHealthAction.this.getResponse(request, observer.setAndGetObservedState(), concreteWaitFor, true);
                listener.onResponse(response);
            }
        };
        if (validationPredicate.test(state)) {
            stateListener.onNewClusterState(state);
        } else {
            observer.waitForNextChange(stateListener, validationPredicate, request.timeout());
        }
    }

    private boolean validateRequest(ClusterHealthRequest request, ClusterState clusterState, int waitFor) {
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.getMasterService().numberOfPendingTasks(), this.gatewayAllocator.getNumberOfInFlightFetch(), this.clusterService.getMasterService().getMaxTaskWaitTime());
        int readyCounter = TransportClusterHealthAction.prepareResponse(request, response, clusterState, this.indexNameExpressionResolver);
        return readyCounter == waitFor;
    }

    private ClusterHealthResponse getResponse(ClusterHealthRequest request, ClusterState clusterState, int waitFor, boolean timedOut) {
        boolean valid;
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.getMasterService().numberOfPendingTasks(), this.gatewayAllocator.getNumberOfInFlightFetch(), this.clusterService.getMasterService().getMaxTaskWaitTime());
        int readyCounter = TransportClusterHealthAction.prepareResponse(request, response, clusterState, this.indexNameExpressionResolver);
        boolean bl = valid = readyCounter == waitFor;
        assert (valid || timedOut);
        response.setTimedOut(timedOut && !valid);
        return response;
    }

    static int prepareResponse(ClusterHealthRequest request, ClusterHealthResponse response, ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver) {
        int waitForCounter = 0;
        if (request.waitForStatus() != null && response.getStatus().value() <= request.waitForStatus().value()) {
            ++waitForCounter;
        }
        if (request.waitForNoRelocatingShards() && response.getRelocatingShards() == 0) {
            ++waitForCounter;
        }
        if (request.waitForNoInitializingShards() && response.getInitializingShards() == 0) {
            ++waitForCounter;
        }
        if (!request.waitForActiveShards().equals(ActiveShardCount.NONE)) {
            ActiveShardCount waitForActiveShards = request.waitForActiveShards();
            assert (!waitForActiveShards.equals(ActiveShardCount.DEFAULT)) : "waitForActiveShards must not be DEFAULT on the request object, instead it should be NONE";
            if (waitForActiveShards.equals(ActiveShardCount.ALL)) {
                if (response.getUnassignedShards() == 0 && response.getInitializingShards() == 0) {
                    ++waitForCounter;
                }
            } else if (waitForActiveShards.enoughShardsActive(response.getActiveShards())) {
                ++waitForCounter;
            }
        }
        if (request.indices() != null && request.indices().length > 0) {
            try {
                indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.strictExpand(), request.indices());
                ++waitForCounter;
            }
            catch (IndexNotFoundException e) {
                response.setStatus(ClusterHealthStatus.RED);
            }
        }
        if (!request.waitForNodes().isEmpty()) {
            if (request.waitForNodes().startsWith(">=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("ge(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("le(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith(">")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("gt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("lt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else {
                int expected = Integer.parseInt(request.waitForNodes());
                if (response.getNumberOfNodes() == expected) {
                    ++waitForCounter;
                }
            }
        }
        return waitForCounter;
    }

    private ClusterHealthResponse clusterHealth(ClusterHealthRequest request, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, TimeValue pendingTaskTimeInQueue) {
        String[] concreteIndices;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Calculating health based on state version [{}]", (Object)clusterState.version());
        }
        try {
            concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, request);
        }
        catch (IndexNotFoundException e) {
            ClusterHealthResponse response = new ClusterHealthResponse(clusterState.getClusterName().value(), Strings.EMPTY_ARRAY, clusterState, numberOfPendingTasks, numberOfInFlightFetch, UnassignedInfo.getNumberOfDelayedUnassigned(clusterState), pendingTaskTimeInQueue);
            response.setStatus(ClusterHealthStatus.RED);
            return response;
        }
        return new ClusterHealthResponse(clusterState.getClusterName().value(), concreteIndices, clusterState, numberOfPendingTasks, numberOfInFlightFetch, UnassignedInfo.getNumberOfDelayedUnassigned(clusterState), pendingTaskTimeInQueue);
    }
}

