/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggregationCursor;
import org.elasticsearch.xpack.sql.execution.search.ResultRowSet;
import org.elasticsearch.xpack.sql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.sql.session.Cursor;

class CompositeAggsRowSet
extends ResultRowSet<BucketExtractor> {
    private final List<? extends CompositeAggregation.Bucket> buckets;
    private final Cursor cursor;
    private final int size;
    private int row = 0;

    CompositeAggsRowSet(List<BucketExtractor> exts, BitSet mask, SearchResponse response, int limit, byte[] next, String ... indices) {
        super(exts, mask);
        CompositeAggregation composite = CompositeAggregationCursor.getComposite(response);
        this.buckets = composite != null ? composite.getBuckets() : Collections.emptyList();
        int n = this.size = limit == -1 ? this.buckets.size() : Math.min(this.buckets.size(), limit);
        if (next == null) {
            this.cursor = Cursor.EMPTY;
        } else {
            int remainingLimit = limit == -1 ? limit : (limit - this.size >= 0 ? limit - this.size : 0);
            this.cursor = this.size == 0 || remainingLimit == 0 ? Cursor.EMPTY : new CompositeAggregationCursor(next, exts, mask, remainingLimit, indices);
        }
    }

    @Override
    protected Object extractValue(BucketExtractor e) {
        return e.extract((MultiBucketsAggregation.Bucket)this.buckets.get(this.row));
    }

    @Override
    protected boolean doHasCurrent() {
        return this.row < this.size;
    }

    @Override
    protected boolean doNext() {
        if (this.row < this.size - 1) {
            ++this.row;
            return true;
        }
        return false;
    }

    @Override
    protected void doReset() {
        this.row = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Cursor nextPageCursor() {
        return this.cursor;
    }
}

