/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.gen.script;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.xpack.sql.expression.function.scalar.whitelist.InternalSqlScriptUtils;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.type.DataType;

public final class Scripts {
    public static final String DOC_VALUE = "doc[{}].value";
    public static final String SQL_SCRIPTS = "{sql}";
    public static final String PARAM = "{}";
    private static final Map<Pattern, String> FORMATTING_PATTERNS = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("doc[{}].value", "{sql}.docValue(doc,{})"), new AbstractMap.SimpleEntry<String, String>("{sql}", InternalSqlScriptUtils.class.getSimpleName()), new AbstractMap.SimpleEntry<String, String>("{}", "params.%s")).collect(Collectors.toMap(e -> Pattern.compile((String)e.getKey(), 16), Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new)));

    private Scripts() {
    }

    public static String formatTemplate(String template) {
        for (Map.Entry<Pattern, String> entry : FORMATTING_PATTERNS.entrySet()) {
            template = entry.getKey().matcher(template).replaceAll(entry.getValue());
        }
        return template;
    }

    public static ScriptTemplate nullSafeFilter(ScriptTemplate script) {
        return new ScriptTemplate(Scripts.formatTemplate(String.format(Locale.ROOT, "{sql}.nullSafeFilter(%s)", script.template())), script.params(), DataType.BOOLEAN);
    }

    public static ScriptTemplate nullSafeSort(ScriptTemplate script) {
        String methodName = script.outputType().isNumeric() ? "nullSafeSortNumeric" : "nullSafeSortString";
        return new ScriptTemplate(Scripts.formatTemplate(String.format(Locale.ROOT, "{sql}.%s(%s)", methodName, script.template())), script.params(), script.outputType());
    }

    public static ScriptTemplate and(ScriptTemplate left, ScriptTemplate right) {
        return Scripts.binaryMethod("and", left, right, DataType.BOOLEAN);
    }

    public static ScriptTemplate or(ScriptTemplate left, ScriptTemplate right) {
        return Scripts.binaryMethod("or", left, right, DataType.BOOLEAN);
    }

    public static ScriptTemplate binaryMethod(String methodName, ScriptTemplate leftScript, ScriptTemplate rightScript, DataType dataType) {
        return new ScriptTemplate(String.format(Locale.ROOT, Scripts.formatTemplate("{sql}.%s(%s,%s)"), methodName, leftScript.template(), rightScript.template()), ParamsBuilder.paramsBuilder().script(leftScript.params()).script(rightScript.params()).build(), dataType);
    }
}

