/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.persistence.BatchedResultsIterator;

class BatchedBucketsIterator
extends BatchedResultsIterator<Bucket> {
    BatchedBucketsIterator(Client client, String jobId) {
        super(client, jobId, "bucket");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Result<Bucket> map(SearchHit hit) {
        BytesReference source = hit.getSourceRef();
        try (StreamInput stream = source.streamInput();){
            Result result;
            block14: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    Bucket bucket = (Bucket)Bucket.LENIENT_PARSER.apply(parser, null);
                    result = new Result(hit.getIndex(), (Object)bucket);
                    if (parser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return result;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to parse bucket", (Throwable)e, new Object[0]);
        }
    }
}

