/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\t\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u0006\u0010\u0017\u001a\u00020\u0018J\u001f\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\b\u0010!\u001a\u00020\u0005H\u0002R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LinkCapacityEstimator;", "", "<init>", "()V", "estimateKbps", "", "Ljava/lang/Double;", "deviationKbps", "upperBound", "Lorg/jitsi/nlj/util/Bandwidth;", "upperBound-rlWvAKk", "()J", "lowerBound", "lowerBound-rlWvAKk", "reset", "", "onOveruseDetected", "acknowledgedRate", "onOveruseDetected-_2icLw0", "(J)V", "onProbeRate", "probeRate", "onProbeRate-_2icLw0", "hasEstimate", "", "estimate", "getEstimate-4yB3KFE", "()Lorg/jitsi/nlj/util/Bandwidth;", "update", "capacitySample", "alpha", "update-SimD6oM", "(JD)V", "deviationEstimateKbps", "jitsi-media-transform"})
public final class LinkCapacityEstimator {
    @Nullable
    private Double estimateKbps;
    private double deviationKbps = 0.4;

    public final long upperBound-rlWvAKk() {
        long l;
        Double d = this.estimateKbps;
        if (d != null) {
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            l = BandwidthKt.getKbps(it + (double)3 * this.deviationEstimateKbps());
        } else {
            l = Bandwidth.Companion.getINFINITY-rlWvAKk();
        }
        return l;
    }

    public final long lowerBound-rlWvAKk() {
        long l;
        Double d = this.estimateKbps;
        if (d != null) {
            double it = ((Number)d).doubleValue();
            boolean bl = false;
            l = BandwidthKt.getKbps(Math.max(0.0, it - (double)3 * this.deviationEstimateKbps()));
        } else {
            l = Bandwidth.Companion.getZERO-rlWvAKk();
        }
        return l;
    }

    public final void reset() {
        this.estimateKbps = null;
    }

    public final void onOveruseDetected-_2icLw0(long acknowledgedRate) {
        this.update-SimD6oM(acknowledgedRate, 0.05);
    }

    public final void onProbeRate-_2icLw0(long probeRate) {
        this.update-SimD6oM(probeRate, 0.5);
    }

    public final boolean hasEstimate() {
        return this.estimateKbps != null;
    }

    @Nullable
    public final Bandwidth getEstimate-4yB3KFE() {
        Double d = this.estimateKbps;
        return d != null ? Bandwidth.box-impl(BandwidthKt.getKbps(d)) : null;
    }

    private final void update-SimD6oM(long capacitySample, double alpha) {
        double d;
        double sampleKbps = (long)Bandwidth.getKbps-impl(capacitySample);
        if (this.estimateKbps == null) {
            d = sampleKbps;
        } else {
            double d2 = 1.0 - alpha;
            Double d3 = this.estimateKbps;
            Intrinsics.checkNotNull(d3);
            d = d2 * d3 + alpha * sampleKbps;
        }
        Double d4 = this.estimateKbps = Double.valueOf(d);
        Intrinsics.checkNotNull(d4);
        double norm = Math.max(d4, 1.0);
        Double d5 = this.estimateKbps;
        Intrinsics.checkNotNull(d5);
        double errorKbps = d5 - sampleKbps;
        this.deviationKbps = (1.0 - alpha) * this.deviationKbps + alpha * errorKbps * errorKbps / norm;
        this.deviationKbps = RangesKt.coerceIn(this.deviationKbps, 0.4, 2.5);
    }

    private final double deviationEstimateKbps() {
        Double d = this.estimateKbps;
        Intrinsics.checkNotNull(d);
        return Math.sqrt(this.deviationKbps * d);
    }
}

