/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.av1;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacketKt;
import org.jitsi.nlj.rtp.codec.av1.Av1DDRtpLayerDesc;
import org.jitsi.rtp.rtp.header_extensions.DTI;
import org.jitsi.rtp.rtp.header_extensions.DecodeTargetLayer;
import org.jitsi.rtp.rtp.header_extensions.FrameInfo;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.av1.Av1DDFrame;
import org.jitsi.videobridge.cc.av1.Av1DDFrameMap;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 -2\u00020\u0001:\u0002,-B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eJ*\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010 \u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J*\u0010\"\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0002J\u0015\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0001\u00a2\u0006\u0002\b'R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)8G\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDQualityFilter;", "", "av1FrameMap", "", "", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrameMap;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Ljava/util/Map;Lorg/jitsi/utils/logging2/Logger;)V", "getAv1FrameMap", "()Ljava/util/Map;", "logger", "mostRecentKeyframeGroupArrivalTime", "Ljava/time/Instant;", "value", "", "needsKeyframe", "getNeedsKeyframe", "()Z", "internalTargetEncoding", "", "internalTargetDt", "currentIndex", "acceptFrame", "Lorg/jitsi/videobridge/cc/av1/Av1DDQualityFilter$AcceptResult;", "frame", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;", "incomingEncoding", "externalTargetIndex", "receivedTime", "doAcceptFrame", "isOutOfSwitchingPhase", "isPossibleToSwitch", "acceptKeyframe", "addDiagnosticContext", "", "pt", "Lorg/jitsi/utils/logging/DiagnosticContext$TimeSeriesPoint;", "addDiagnosticContext$jitsi_videobridge", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "AcceptResult", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nAv1DDQualityFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1DDQualityFilter.kt\norg/jitsi/videobridge/cc/av1/Av1DDQualityFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,462:1\n1726#2,3:463\n*S KotlinDebug\n*F\n+ 1 Av1DDQualityFilter.kt\norg/jitsi/videobridge/cc/av1/Av1DDQualityFilter\n*L\n219#1:463,3\n*E\n"})
public final class Av1DDQualityFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Long, Av1DDFrameMap> av1FrameMap;
    @NotNull
    private final Logger logger;
    @Nullable
    private Instant mostRecentKeyframeGroupArrivalTime;
    private boolean needsKeyframe;
    private int internalTargetEncoding;
    private int internalTargetDt;
    private int currentIndex;
    private static final Duration MIN_KEY_FRAME_WAIT = Duration.ofMillis(300L);

    public Av1DDQualityFilter(@NotNull Map<Long, Av1DDFrameMap> av1FrameMap, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(av1FrameMap, "av1FrameMap");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.av1FrameMap = av1FrameMap;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.internalTargetEncoding = -1;
        this.internalTargetDt = -1;
        this.currentIndex = -1;
    }

    @NotNull
    public final Map<Long, Av1DDFrameMap> getAv1FrameMap() {
        return this.av1FrameMap;
    }

    public final boolean getNeedsKeyframe() {
        return this.needsKeyframe;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final synchronized AcceptResult acceptFrame(@NotNull Av1DDFrame frame, int incomingEncoding, int externalTargetIndex, @Nullable Instant receivedTime) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        prevIndex = this.currentIndex;
        accept = this.doAcceptFrame(frame, incomingEncoding, externalTargetIndex, receivedTime);
        currentDt = Av1DDRtpLayerDesc.Companion.getDtFromIndex(this.currentIndex);
        if (currentDt == -1) ** GOTO lbl-1000
        v0 = frame.getFrameInfo();
        if (Intrinsics.areEqual(v0 != null ? Integer.valueOf(v0.getSpatialId()) : null, (v1 = frame.getStructure()) != null && (v1 = v1.getDecodeTargetLayers()) != null && (v1 = (DecodeTargetLayer)CollectionsKt.getOrNull(v1, currentDt)) != null ? Integer.valueOf(v1.getSpatialId()) : null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        mark = v2;
        v3 = isResumption = prevIndex == -1 && this.currentIndex != -1;
        if (isResumption && !accept) {
            $i$a$-check-Av1DDQualityFilter$acceptFrame$1 = false;
            $i$a$-check-Av1DDQualityFilter$acceptFrame$1 = "isResumption=" + isResumption + " but accept=" + accept + " for frame " + frame.getFrameNumber() + ", frameInfo=" + frame.getFrameInfo();
            throw new IllegalStateException($i$a$-check-Av1DDQualityFilter$acceptFrame$1.toString());
        }
        v4 = dtChanged = prevIndex != this.currentIndex;
        if (dtChanged && currentDt != -1 && !accept) {
            $i$a$-check-Av1DDQualityFilter$acceptFrame$2 = false;
            $i$a$-check-Av1DDQualityFilter$acceptFrame$2 = "dtChanged=" + dtChanged + " but accept=" + accept + " for frame " + frame.getFrameNumber() + ", frameInfo=" + frame.getFrameInfo();
            throw new IllegalStateException($i$a$-check-Av1DDQualityFilter$acceptFrame$2.toString());
        }
        newDt = dtChanged != false || frame.getActiveDecodeTargets() != null ? Integer.valueOf(currentDt) : null;
        return new AcceptResult(accept, isResumption, mark, newDt);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean doAcceptFrame(Av1DDFrame frame, int incomingEncoding, int externalTargetIndex, Instant receivedTime) {
        block16: {
            block17: {
                block18: {
                    block14: {
                        block15: {
                            externalTargetEncoding = RtpLayerDesc.Companion.getEidFromIndex(externalTargetIndex);
                            currentEncoding = RtpLayerDesc.Companion.getEidFromIndex(this.currentIndex);
                            if (externalTargetEncoding != this.internalTargetEncoding) {
                                this.internalTargetEncoding = externalTargetEncoding;
                                if (externalTargetEncoding != -1 && externalTargetEncoding != currentEncoding) {
                                    this.needsKeyframe = true;
                                }
                            }
                            if (externalTargetEncoding == -1) {
                                this.currentIndex = -1;
                                return false;
                            }
                            if (!frame.isKeyframe()) break block15;
                            this.logger.debug((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doAcceptFrame$lambda$2(org.jitsi.videobridge.cc.av1.Av1DDFrame ), ()Ljava/lang/String;)((Av1DDFrame)frame));
                            v0 = this.acceptKeyframe(frame, incomingEncoding, externalTargetIndex, receivedTime);
                            break block16;
                        }
                        if (currentEncoding == -1) break block17;
                        if (this.isOutOfSwitchingPhase(receivedTime) && this.isPossibleToSwitch(incomingEncoding)) {
                            this.needsKeyframe = true;
                        }
                        if (incomingEncoding != currentEncoding) {
                            return false;
                        }
                        v1 = frame.getFrameInfo();
                        if (v1 == null) {
                            $this$doAcceptFrame_u24lambda_u243 = this;
                            $i$a$-run-Av1DDQualityFilter$doAcceptFrame$frameInfo$1 = false;
                            $this$doAcceptFrame_u24lambda_u243.needsKeyframe = true;
                            return false;
                        }
                        frameInfo = v1;
                        currentDt = new Ref.IntRef();
                        currentDt.element = Av1DDRtpLayerDesc.Companion.getDtFromIndex(this.currentIndex);
                        v2 = externalTargetDt = currentEncoding == externalTargetEncoding ? Av1DDRtpLayerDesc.Companion.getDtFromIndex(externalTargetIndex) : currentDt.element;
                        if (frame.getActiveDecodeTargets() != null && !Av1DDPacketKt.containsDecodeTarget(frame.getActiveDecodeTargets(), externalTargetDt)) {
                            this.logger.warn((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doAcceptFrame$lambda$4(int org.jitsi.videobridge.cc.av1.Av1DDFrame ), ()Ljava/lang/String;)((int)externalTargetDt, (Av1DDFrame)frame));
                            return false;
                        }
                        if (currentDt.element == externalTargetDt) break block18;
                        frameMap = this.av1FrameMap.get(frame.getSsrc());
                        if (CollectionsKt.getOrNull(frameInfo.getDti(), externalTargetDt) == null) {
                            this.logger.warn((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doAcceptFrame$lambda$5(int org.jitsi.videobridge.cc.av1.Av1DDFrame org.jitsi.rtp.rtp.header_extensions.FrameInfo ), ()Ljava/lang/String;)((int)externalTargetDt, (Av1DDFrame)frame, (FrameInfo)frameInfo));
                        }
                        if (frameInfo.getDti().get(externalTargetDt) != DTI.SWITCH || frameMap == null) ** GOTO lbl-1000
                        $this$all$iv = frameInfo.getFdiff();
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v3 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                it = ((Number)element$iv).intValue();
                                $i$a$-all-Av1DDQualityFilter$doAcceptFrame$4 = false;
                                v4 = frameMap.getIndex(frame.getIndex() - (long)it);
                                if (v4 != null ? v4.isAccepted() : false) continue;
                                v3 = false;
                                break block14;
                            }
                            v3 = true;
                        }
                    }
                    if (v3) {
                        this.logger.debug((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doAcceptFrame$lambda$7(int kotlin.jvm.internal.Ref$IntRef ), ()Ljava/lang/String;)((int)externalTargetDt, (Ref.IntRef)currentDt));
                        currentDt.element = externalTargetDt;
                        this.currentIndex = externalTargetIndex;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = frame.getStructure();
                        if (!(v5 != null ? v5.canSwitchWithoutKeyframe(currentDt.element, externalTargetDt) : false)) {
                            this.logger.debug((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, doAcceptFrame$lambda$8(int kotlin.jvm.internal.Ref$IntRef ), ()Ljava/lang/String;)((int)externalTargetDt, (Ref.IntRef)currentDt));
                            this.needsKeyframe = true;
                        }
                    }
                }
                currentFrameDti = frameInfo.getDti().get(currentDt.element);
                v0 = currentEncoding > externalTargetEncoding ? currentFrameDti == DTI.SWITCH || currentFrameDti == DTI.REQUIRED : currentFrameDti != DTI.NOT_PRESENT;
                break block16;
            }
            v0 = false;
        }
        return v0;
    }

    private final synchronized boolean isOutOfSwitchingPhase(Instant receivedTime) {
        if (receivedTime == null) {
            return false;
        }
        if (this.mostRecentKeyframeGroupArrivalTime == null) {
            return true;
        }
        Duration delta = Duration.between(this.mostRecentKeyframeGroupArrivalTime, receivedTime);
        return delta.compareTo(MIN_KEY_FRAME_WAIT) > 0;
    }

    private final synchronized boolean isPossibleToSwitch(int incomingEncoding) {
        int currentEncoding = RtpLayerDesc.Companion.getEidFromIndex(this.currentIndex);
        if (incomingEncoding == -1) {
            return false;
        }
        return incomingEncoding > currentEncoding && currentEncoding < this.internalTargetEncoding ? true : incomingEncoding < currentEncoding && currentEncoding > this.internalTargetEncoding;
    }

    private final synchronized boolean acceptKeyframe(Av1DDFrame frame, int incomingEncoding, int externalTargetIndex, Instant receivedTime) {
        boolean bl;
        int n;
        if (incomingEncoding < 0) {
            this.logger.error("unable to get layer id from keyframe");
            return false;
        }
        FrameInfo frameInfo = frame.getFrameInfo();
        if (frameInfo == null) {
            Av1DDQualityFilter $this$acceptKeyframe_u24lambda_u249 = this;
            boolean bl2 = false;
            $this$acceptKeyframe_u24lambda_u249.logger.error("unable to get frame info from keyframe");
            return false;
        }
        FrameInfo frameInfo2 = frameInfo;
        this.logger.debug(() -> Av1DDQualityFilter.acceptKeyframe$lambda$10(incomingEncoding));
        int currentEncoding = RtpLayerDesc.Companion.getEidFromIndex(this.currentIndex);
        int externalTargetEncoding = RtpLayerDesc.Companion.getEidFromIndex(externalTargetIndex);
        if (incomingEncoding == externalTargetEncoding) {
            n = externalTargetIndex;
        } else if (incomingEncoding == this.internalTargetEncoding && this.internalTargetDt != -1) {
            n = Av1DDRtpLayerDesc.Companion.getIndex(currentEncoding, this.internalTargetDt);
        } else {
            Object t2 = CollectionsKt.maxOrNull((Iterable)frameInfo2.getDtisPresent());
            Intrinsics.checkNotNull(t2);
            n = ((Number)t2).intValue();
        }
        int indexIfSwitched = n;
        int dtIfSwitched = Av1DDRtpLayerDesc.Companion.getDtFromIndex(indexIfSwitched);
        DTI dtiIfSwitched = frameInfo2.getDti().get(dtIfSwitched);
        boolean acceptIfSwitched = dtiIfSwitched != DTI.NOT_PRESENT;
        this.needsKeyframe = false;
        if (this.isOutOfSwitchingPhase(receivedTime)) {
            this.mostRecentKeyframeGroupArrivalTime = receivedTime;
            this.logger.debug(() -> Av1DDQualityFilter.acceptKeyframe$lambda$11(incomingEncoding, this));
            if (incomingEncoding <= this.internalTargetEncoding) {
                if (acceptIfSwitched) {
                    this.currentIndex = indexIfSwitched;
                }
                bl = acceptIfSwitched;
            } else {
                bl = false;
            }
        } else if (currentEncoding <= incomingEncoding && incomingEncoding <= this.internalTargetEncoding) {
            if (acceptIfSwitched) {
                this.currentIndex = indexIfSwitched;
                this.logger.debug(() -> Av1DDQualityFilter.acceptKeyframe$lambda$12(incomingEncoding, this));
            }
            bl = acceptIfSwitched;
        } else if (incomingEncoding <= this.internalTargetEncoding && this.internalTargetEncoding < currentEncoding) {
            if (acceptIfSwitched) {
                this.currentIndex = indexIfSwitched;
                this.logger.debug(() -> Av1DDQualityFilter.acceptKeyframe$lambda$13(incomingEncoding, this));
            }
            bl = acceptIfSwitched;
        } else {
            bl = false;
        }
        return bl;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="We intentionally avoid synchronizing while reading fields only used in debug output.")
    public final void addDiagnosticContext$jitsi_videobridge(@NotNull DiagnosticContext.TimeSeriesPoint pt) {
        Intrinsics.checkNotNullParameter(pt, "pt");
        Instant instant = this.mostRecentKeyframeGroupArrivalTime;
        pt.addField("qf.currentIndex", Av1DDRtpLayerDesc.Companion.indexString(this.currentIndex)).addField("qf.internalTargetEncoding", this.internalTargetEncoding).addField("qf.internalTargetDt", this.internalTargetDt).addField("qf.needsKeyframe", this.needsKeyframe).addField("qf.mostRecentKeyframeGroupArrivalTimeMs", instant != null ? instant.toEpochMilli() : -1L);
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="We intentionally avoid synchronizing while reading fields only used in debug output.")
    @NotNull
    public final JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        Map map = debugState;
        String string = "mostRecentKeyframeGroupArrivalTimeMs";
        Instant instant = this.mostRecentKeyframeGroupArrivalTime;
        Long l = instant != null ? instant.toEpochMilli() : -1L;
        map.put(string, l);
        ((Map)debugState).put("needsKeyframe", this.needsKeyframe);
        ((Map)debugState).put("internalTargetEncoding", this.internalTargetEncoding);
        ((Map)debugState).put("internalTargetDt", this.internalTargetDt);
        ((Map)debugState).put("currentIndex", Av1DDRtpLayerDesc.Companion.indexString(this.currentIndex));
        return debugState;
    }

    private static final String doAcceptFrame$lambda$2(Av1DDFrame $frame) {
        Intrinsics.checkNotNullParameter($frame, "$frame");
        return "Quality filter got keyframe for stream " + $frame.getSsrc();
    }

    private static final String doAcceptFrame$lambda$4(int $externalTargetDt, Av1DDFrame $frame) {
        Intrinsics.checkNotNullParameter($frame, "$frame");
        return "External target DT " + $externalTargetDt + " not present in current decode targets 0x" + Integer.toHexString($frame.getActiveDecodeTargets()) + " for frame " + $frame + ".";
    }

    private static final String doAcceptFrame$lambda$5(int $externalTargetDt, Av1DDFrame $frame, FrameInfo $frameInfo) {
        Intrinsics.checkNotNullParameter($frame, "$frame");
        Intrinsics.checkNotNullParameter($frameInfo, "$frameInfo");
        return "Target DT " + $externalTargetDt + " not present for frame " + $frame + " [frameInfo " + $frameInfo + "]";
    }

    private static final String doAcceptFrame$lambda$7(int $externalTargetDt, Ref.IntRef $currentDt) {
        Intrinsics.checkNotNullParameter($currentDt, "$currentDt");
        return "Switching to DT " + $externalTargetDt + " from " + $currentDt.element;
    }

    private static final String doAcceptFrame$lambda$8(int $externalTargetDt, Ref.IntRef $currentDt) {
        Intrinsics.checkNotNullParameter($currentDt, "$currentDt");
        return "Want to switch to DT " + $externalTargetDt + " from " + $currentDt.element + ", requesting keyframe";
    }

    private static final String acceptKeyframe$lambda$10(int $incomingEncoding) {
        return "Received a keyframe of encoding: " + $incomingEncoding;
    }

    private static final String acceptKeyframe$lambda$11(int $incomingEncoding, Av1DDQualityFilter this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "First keyframe in this kf group currentEncodingId: " + $incomingEncoding + ". Target is " + this$0.internalTargetEncoding;
    }

    private static final String acceptKeyframe$lambda$12(int $incomingEncoding, Av1DDQualityFilter this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "Upscaling to encoding " + $incomingEncoding + ". The target is " + this$0.internalTargetEncoding;
    }

    private static final String acceptKeyframe$lambda$13(int $incomingEncoding, Av1DDQualityFilter this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "Downscaling to encoding " + $incomingEncoding + ". The target is " + this$0.internalTargetEncoding;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ8\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDQualityFilter$AcceptResult;", "", "accept", "", "isResumption", "mark", "newDt", "", "<init>", "(ZZZLjava/lang/Integer;)V", "getAccept", "()Z", "getMark", "getNewDt", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "component3", "component4", "copy", "(ZZZLjava/lang/Integer;)Lorg/jitsi/videobridge/cc/av1/Av1DDQualityFilter$AcceptResult;", "equals", "other", "hashCode", "toString", "", "jitsi-videobridge"})
    public static final class AcceptResult {
        private final boolean accept;
        private final boolean isResumption;
        private final boolean mark;
        @Nullable
        private final Integer newDt;

        public AcceptResult(boolean accept2, boolean isResumption, boolean mark, @Nullable Integer newDt) {
            this.accept = accept2;
            this.isResumption = isResumption;
            this.mark = mark;
            this.newDt = newDt;
        }

        public final boolean getAccept() {
            return this.accept;
        }

        public final boolean isResumption() {
            return this.isResumption;
        }

        public final boolean getMark() {
            return this.mark;
        }

        @Nullable
        public final Integer getNewDt() {
            return this.newDt;
        }

        public final boolean component1() {
            return this.accept;
        }

        public final boolean component2() {
            return this.isResumption;
        }

        public final boolean component3() {
            return this.mark;
        }

        @Nullable
        public final Integer component4() {
            return this.newDt;
        }

        @NotNull
        public final AcceptResult copy(boolean accept2, boolean isResumption, boolean mark, @Nullable Integer newDt) {
            return new AcceptResult(accept2, isResumption, mark, newDt);
        }

        public static /* synthetic */ AcceptResult copy$default(AcceptResult acceptResult, boolean bl, boolean bl2, boolean bl3, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = acceptResult.accept;
            }
            if ((n2 & 2) != 0) {
                bl2 = acceptResult.isResumption;
            }
            if ((n2 & 4) != 0) {
                bl3 = acceptResult.mark;
            }
            if ((n2 & 8) != 0) {
                n = acceptResult.newDt;
            }
            return acceptResult.copy(bl, bl2, bl3, n);
        }

        @NotNull
        public String toString() {
            return "AcceptResult(accept=" + this.accept + ", isResumption=" + this.isResumption + ", mark=" + this.mark + ", newDt=" + this.newDt + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.accept);
            result = result * 31 + Boolean.hashCode(this.isResumption);
            result = result * 31 + Boolean.hashCode(this.mark);
            result = result * 31 + (this.newDt == null ? 0 : ((Object)this.newDt).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AcceptResult)) {
                return false;
            }
            AcceptResult acceptResult = (AcceptResult)other;
            if (this.accept != acceptResult.accept) {
                return false;
            }
            if (this.isResumption != acceptResult.isResumption) {
                return false;
            }
            if (this.mark != acceptResult.mark) {
                return false;
            }
            return Intrinsics.areEqual(this.newDt, acceptResult.newDt);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDQualityFilter$Companion;", "", "<init>", "()V", "MIN_KEY_FRAME_WAIT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "Ljava/time/Duration;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

