/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp9;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.PictureIdIndexTracker;
import org.jitsi.videobridge.cc.vp9.Vp9Frame;
import org.jitsi.videobridge.cc.vp9.Vp9Picture;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0004H\u0086\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0002H\u0014J$\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020'0&J$\u0010(\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020'0&J>\u0010)\u001a\u0004\u0018\u00010#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020'0&2\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004H\u0002R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0006R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lorg/jitsi/videobridge/cc/vp9/PictureHistory;", "Lorg/jitsi/nlj/util/ArrayCache;", "Lorg/jitsi/videobridge/cc/vp9/Vp9Picture;", "size", "", "<init>", "(I)V", "numCached", "getNumCached", "()I", "setNumCached", "firstIndex", "", "getFirstIndex", "()J", "setFirstIndex", "(J)V", "indexTracker", "Lorg/jitsi/nlj/util/PictureIdIndexTracker;", "getIndexTracker", "()Lorg/jitsi/nlj/util/PictureIdIndexTracker;", "get", "pictureId", "getIndex", "index", "latestPicture", "getLatestPicture", "()Lorg/jitsi/videobridge/cc/vp9/Vp9Picture;", "insert", "packet", "Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;", "discardItem", "", "item", "findBefore", "Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "frame", "pred", "Lkotlin/Function1;", "", "findAfter", "doFind", "startIndex", "endIndex", "startLayer", "increment", "jitsi-videobridge"})
public final class PictureHistory
extends ArrayCache<Vp9Picture> {
    private int numCached;
    private long firstIndex = -1L;
    @NotNull
    private final PictureIdIndexTracker indexTracker = new PictureIdIndexTracker();

    public PictureHistory(int size) {
        super(size, PictureHistory::_init_$lambda$0, false, null, 8, null);
    }

    public final int getNumCached() {
        return this.numCached;
    }

    public final void setNumCached(int n) {
        this.numCached = n;
    }

    public final long getFirstIndex() {
        return this.firstIndex;
    }

    public final void setFirstIndex(long l) {
        this.firstIndex = l;
    }

    @NotNull
    public final PictureIdIndexTracker getIndexTracker() {
        return this.indexTracker;
    }

    @Nullable
    public final Vp9Picture get(int pictureId) {
        long index = this.indexTracker.interpret(pictureId);
        return this.getIndex(index);
    }

    private final Vp9Picture getIndex(long index) {
        if (index <= this.getLastIndex() - (long)this.getSize()) {
            return null;
        }
        ArrayCache.Container container = ArrayCache.getContainer$default(this, index, false, 2, null);
        if (container == null) {
            return null;
        }
        ArrayCache.Container c = container;
        return (Vp9Picture)c.getItem();
    }

    @Nullable
    public final Vp9Picture getLatestPicture() {
        return this.getIndex(this.getLastIndex());
    }

    @Nullable
    public final Vp9Picture insert(@NotNull Vp9Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        int pictureId = packet.getPictureId();
        long index = this.indexTracker.update(pictureId);
        Vp9Picture picture = new Vp9Picture(packet, index);
        boolean inserted = super.insertItem(picture, index);
        if (inserted) {
            int n = this.numCached;
            this.numCached = n + 1;
            if (this.firstIndex == -1L || index < this.firstIndex) {
                this.firstIndex = index;
            }
            return picture;
        }
        return null;
    }

    @Override
    protected void discardItem(@NotNull Vp9Picture item) {
        Intrinsics.checkNotNullParameter(item, "item");
        int n = this.numCached;
        this.numCached = n + -1;
    }

    @Nullable
    public final Vp9Frame findBefore(@NotNull Vp9Frame frame, @NotNull Function1<? super Vp9Frame, Boolean> pred) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(pred, "pred");
        long lastIndex = this.getLastIndex();
        if (lastIndex == -1L) {
            return null;
        }
        long index = this.indexTracker.interpret(frame.getPictureId());
        long searchStartIndex = Math.min(index, lastIndex);
        long searchEndIndex = Math.max(lastIndex - (long)this.getSize(), this.firstIndex - 1L);
        return this.doFind(pred, searchStartIndex, searchEndIndex, frame.getEffectiveSpatialLayer() - 1, -1);
    }

    @Nullable
    public final Vp9Frame findAfter(@NotNull Vp9Frame frame, @NotNull Function1<? super Vp9Frame, Boolean> pred) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(pred, "pred");
        long lastIndex = this.getLastIndex();
        if (lastIndex == -1L) {
            return null;
        }
        long index = this.indexTracker.interpret(frame.getPictureId());
        if (index > lastIndex) {
            return null;
        }
        long searchStartIndex = Math.max(index, Math.max(lastIndex - (long)this.getSize() + 1L, this.firstIndex));
        return this.doFind(pred, searchStartIndex, lastIndex + 1L, frame.getEffectiveSpatialLayer() + 1, 1);
    }

    private final Vp9Frame doFind(Function1<? super Vp9Frame, Boolean> pred, long startIndex, long endIndex, int startLayer, int increment) {
        if (!(increment > 0 && startIndex <= endIndex || increment < 0 && startIndex >= endIndex)) {
            boolean bl = false;
            String string = "Values of startIndex=" + startIndex + ", endIndex=" + endIndex + ", and increment=" + increment + " could lead to infinite loop";
            throw new IllegalArgumentException(string.toString());
        }
        int layer = startLayer;
        boolean firstPicture = true;
        for (long index = startIndex; index != endIndex; index += (long)increment) {
            Vp9Picture picture = this.getIndex(index);
            if (picture != null) {
                if (!firstPicture) {
                    int n = layer = increment < 0 ? picture.getFrames().size() - 1 : 0;
                }
                while (true) {
                    boolean bl = 0 <= layer ? layer < ((Collection)picture.getFrames()).size() : false;
                    if (!bl) break;
                    Vp9Frame frame = picture.getFrames().get(layer);
                    if (frame != null && pred.invoke(frame).booleanValue()) {
                        return frame;
                    }
                    layer += increment;
                }
            }
            firstPicture = false;
        }
        return null;
    }

    private static final Vp9Picture _init_$lambda$0(Vp9Picture k) {
        Intrinsics.checkNotNullParameter(k, "k");
        return k;
    }
}

