/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.DiffException;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.rcs.ArchiveParser;
import org.apache.commons.jrcs.rcs.BranchNode;
import org.apache.commons.jrcs.rcs.HeadAlreadySetException;
import org.apache.commons.jrcs.rcs.InvalidBranchVersionNumberException;
import org.apache.commons.jrcs.rcs.InvalidFileFormatException;
import org.apache.commons.jrcs.rcs.InvalidTrunkVersionNumberException;
import org.apache.commons.jrcs.rcs.InvalidVersionNumberException;
import org.apache.commons.jrcs.rcs.KeywordsFormat;
import org.apache.commons.jrcs.rcs.Lines;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.NodeNotFoundException;
import org.apache.commons.jrcs.rcs.ParseException;
import org.apache.commons.jrcs.rcs.Path;
import org.apache.commons.jrcs.rcs.Phrases;
import org.apache.commons.jrcs.rcs.TrunkNode;
import org.apache.commons.jrcs.rcs.Version;
import org.apache.commons.jrcs.util.ToString;

public class Archive
extends ToString {
    public static final String RCS_NEWLINE = "\n";
    protected TrunkNode head;
    protected Version branch;
    protected Map nodes = new TreeMap();
    protected Set users = new TreeSet();
    protected Set locked = new TreeSet();
    protected Map symbols = new TreeMap();
    protected Phrases phrases = new Phrases();
    protected String desc = new String();
    protected boolean strictLocking = true;
    protected String expand;
    protected String comment = "# ";
    protected String filename = "__unknown__,v";
    Lines revLines = null;
    private static final KeywordsFormat FORMATTER = new KeywordsFormat();

    public Archive(String string, String string2) {
        this(string, string2, new Version(1, 1));
    }

    public Archive(String string, String string2, String string3) {
        this(string, string2, new Version(string3));
    }

    public Archive(String string, String string2, Version version) {
        if (version.size() > 2) {
            throw new InvalidVersionNumberException(version + " must be a trunk version");
        }
        while (version.size() < 2) {
            version = version.newBranch(1);
        }
        this.head = (TrunkNode)this.newNode(version, null);
        this.head.setText(string);
        this.head.setLog(string2);
    }

    public Archive(String string, InputStream inputStream) throws ParseException {
        this.filename = string;
        ArchiveParser.load(this, inputStream);
    }

    public Archive(String string) throws ParseException, FileNotFoundException {
        this.filename = new File(string).getPath();
        ArchiveParser.load(this, this.filename);
    }

    Archive() {
    }

    public void setFileName(String string) {
        this.filename = string;
    }

    public void save(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    public void save(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            this.save(fileOutputStream);
            this.filename = new File(string).getPath();
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    protected void setHead(Version version) throws InvalidVersionNumberException {
        if (this.head != null) {
            throw new HeadAlreadySetException(this.head.getVersion());
        }
        this.head = new TrunkNode(version, null);
        this.nodes.put(version, this.head);
    }

    public void setBranch(String string) throws InvalidBranchVersionNumberException {
        this.setBranch(new Version(string));
    }

    public void setBranch(Version version) throws InvalidBranchVersionNumberException {
        if (!version.isBranch()) {
            throw new InvalidBranchVersionNumberException(version);
        }
        if (this.head == null || version.getBase(2).isGreaterThan(this.head.getVersion())) {
            throw new InvalidBranchVersionNumberException(version + "is greater than _head version " + this.head.getVersion());
        }
        this.branch = version;
    }

    public void addUser(String string) {
        this.users.add(string);
    }

    public void addSymbol(String string, Version version) throws InvalidVersionNumberException {
        this.symbols.put(string, version);
    }

    public Map getSymbols() {
        return this.symbols;
    }

    public void addLock(String string, Version version) throws InvalidVersionNumberException, NodeNotFoundException {
        this.addUser(string);
        Node node = this.newNode(version);
        node.setLocker(string);
        if (string == null) {
            this.locked.remove(node);
        } else {
            this.locked.add(node);
        }
    }

    public void setStrictLocking(boolean bl) {
        this.strictLocking = bl;
    }

    public void setExpand(String string) {
        this.expand = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setDesc(String string) {
        this.desc = string;
    }

    public void addPhrase(String string, Collection collection) {
        this.phrases.put(string, collection);
    }

    protected Node newNode(Version version) {
        return this.newNode(version, null);
    }

    protected Node newNode(Version version, Node node) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!version.isRevision()) {
            throw new InvalidVersionNumberException(version);
        }
        Node node2 = (Node)this.nodes.get(version);
        if (node2 == null) {
            node2 = Node.newNode(version, node);
            this.nodes.put(version, node2);
        }
        return node2;
    }

    protected TrunkNode newTrunkNode(Version version) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!version.isTrunk()) {
            throw new InvalidTrunkVersionNumberException(version);
        }
        return (TrunkNode)this.newNode(version);
    }

    protected BranchNode newBranchNode(Version version) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!version.isBranch()) {
            throw new InvalidBranchVersionNumberException(version);
        }
        return (BranchNode)this.newNode(version);
    }

    protected Node getNode(Version version) throws InvalidVersionNumberException, NodeNotFoundException {
        if (!version.isRevision()) {
            throw new InvalidVersionNumberException(version);
        }
        Node node = (Node)this.nodes.get(version);
        if (node == null) {
            throw new NodeNotFoundException(version);
        }
        return node;
    }

    public Node findNode(Version version) {
        Path path = this.getRevisionPath(version);
        return path == null ? null : path.last();
    }

    public void toString(StringBuffer stringBuffer) {
        this.toString(stringBuffer, RCS_NEWLINE);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, string);
        return stringBuffer.toString();
    }

    public char[] toCharArray() {
        return this.toString(RCS_NEWLINE).toCharArray();
    }

    public byte[] toByteArray() {
        return this.toString(RCS_NEWLINE).getBytes();
    }

    protected Path getRevisionPath(Version version) {
        if (this.head == null) {
            return null;
        }
        try {
            Path path = this.head.pathTo(version, true);
            Node node = path.last();
            if (node == null) {
                return null;
            }
            if (node.getVersion().isLessThan(version)) {
                return null;
            }
            return path;
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            return null;
        }
    }

    public Version getRevisionVersion(Version version) {
        Path path = this.getRevisionPath(version);
        return path == null ? null : path.last().getVersion();
    }

    public Version getRevisionVersion(String string) {
        return this.getRevisionVersion(new Version(string));
    }

    public Version getRevisionVersion() {
        if (this.branch != null) {
            return this.getRevisionVersion(this.branch);
        }
        if (this.head != null) {
            return this.head.getVersion();
        }
        return null;
    }

    public void toString(StringBuffer stringBuffer, String string) {
        Object object;
        String string2 = ";" + string;
        String string3 = string + "\t";
        stringBuffer.append("head");
        if (this.head != null) {
            stringBuffer.append("\t");
            this.head.getVersion().toString(stringBuffer);
        }
        stringBuffer.append(string2);
        if (this.branch != null) {
            stringBuffer.append("branch\t");
            stringBuffer.append(this.branch.toString());
            stringBuffer.append(string2);
        }
        stringBuffer.append("access");
        Object object2 = this.users.iterator();
        while (object2.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("\t");
            stringBuffer.append(object2.next());
        }
        stringBuffer.append(string2);
        stringBuffer.append("symbols");
        object2 = this.symbols.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            stringBuffer.append(string3);
            stringBuffer.append(object.getKey().toString());
            stringBuffer.append(":");
            stringBuffer.append(object.getValue().toString());
        }
        stringBuffer.append(string2);
        stringBuffer.append("locks");
        object2 = this.locked.iterator();
        while (object2.hasNext()) {
            object = ((Node)object2.next()).getLocker();
            stringBuffer.append(string3);
            stringBuffer.append((String)object);
        }
        if (this.strictLocking) {
            stringBuffer.append("; strict");
        }
        stringBuffer.append(string2);
        if (this.comment != null) {
            stringBuffer.append("comment\t");
            stringBuffer.append(Archive.quoteString(this.comment));
            stringBuffer.append(string2);
        }
        if (this.expand != null) {
            stringBuffer.append("expand\t");
            stringBuffer.append(Archive.quoteString(this.expand));
            stringBuffer.append(string2);
        }
        if (this.phrases != null) {
            this.phrases.toString(stringBuffer, string);
        }
        stringBuffer.append(string);
        object2 = this.nodes.values().iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            if (((Node)object).getVersion().isGhost() || ((Node)object).getText() == null) continue;
            ((Node)object).toString(stringBuffer, string);
        }
        stringBuffer.append(string + string);
        stringBuffer.append("desc");
        stringBuffer.append(string);
        stringBuffer.append(Archive.quoteString(this.desc));
        stringBuffer.append(string);
        for (object2 = this.head; object2 != null; object2 = ((Node)object2).getRCSNext()) {
            ((Node)object2).toText(stringBuffer, string);
        }
    }

    public static String quoteString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < string.length(); ++i) {
            if (stringBuffer.charAt(i) != '@') continue;
            stringBuffer.insert(i++, '@');
        }
        stringBuffer.insert(0, '@');
        stringBuffer.append('@');
        return new String(stringBuffer);
    }

    public static String unquoteString(String string) {
        return Archive.unquoteString(string, true);
    }

    public static String unquoteString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        int n2 = string.length();
        if (bl) {
            ++n;
            --n2;
        }
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c != '@') continue;
            ++i;
        }
        return new String(stringBuffer);
    }

    public Object[] getRevision() throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.getRevision(false);
    }

    public Object[] getRevision(boolean bl) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        if (this.branch != null) {
            return this.getRevision(this.branch);
        }
        if (this.head != null) {
            return this.getRevision(this.head.getVersion());
        }
        throw new IllegalStateException("no head node");
    }

    public Object[] getRevision(String string) throws InvalidFileFormatException, PatchFailedException, InvalidVersionNumberException, NodeNotFoundException {
        return this.getRevision(string, false);
    }

    public Object[] getRevision(String string, boolean bl) throws InvalidVersionNumberException, NodeNotFoundException, InvalidFileFormatException, PatchFailedException {
        return this.getRevision(new Version(string), bl);
    }

    public Object[] getRevision(Version version) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.getRevision(version, false);
    }

    public Object[] getRevision(Version version, boolean bl) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        Path path = this.getRevisionPath(version);
        if (path == null) {
            throw new NodeNotFoundException(version);
        }
        Lines lines = new Lines();
        Node node = path.last();
        path.newpatch(lines, bl);
        this.revLines = bl ? lines : null;
        return this.doKeywords(lines.textToArray(false), node);
    }

    public Node[] getRevisionNodes() {
        return this.revLines.nodesToArray();
    }

    public Version addRevision(Object[] objectArray, String string) throws InvalidFileFormatException, DiffException, InvalidVersionNumberException, NodeNotFoundException {
        if (this.branch != null) {
            return this.addRevision(objectArray, this.branch, string);
        }
        return this.addRevision(objectArray, this.head.getVersion().next(), string);
    }

    public Version addRevision(Object[] objectArray, String string, String string2) throws InvalidFileFormatException, DiffException, InvalidVersionNumberException, NodeNotFoundException {
        return this.addRevision(objectArray, new Version(string), string2);
    }

    public Version addRevision(Object[] objectArray, Version version, String string) throws InvalidFileFormatException, DiffException, NodeNotFoundException, InvalidVersionNumberException {
        Object object;
        String string2;
        if (this.head == null) {
            throw new IllegalStateException("no head node");
        }
        Path path = this.head.pathTo(version, true);
        Node node = path.last();
        if (version.size() < node.getVersion().size()) {
            version = node.nextVersion();
        } else {
            if (!version.isGreaterThan(node.getVersion())) {
                throw new InvalidVersionNumberException(version + " revision must be higher than " + node.getVersion());
            }
            if (version.odd()) {
                version = version.last() == 0 ? node.newBranchVersion() : version.newBranch(1);
            } else if (version.last() == 0) {
                version = version.next();
            }
        }
        boolean bl = node == this.head && !version.isBranch();
        objectArray = Archive.removeKeywords(objectArray);
        if (bl) {
            string2 = Diff.diff(objectArray, this.head.getText()).toRCSString(RCS_NEWLINE);
        } else {
            object = (Lines)path.patch();
            string2 = Diff.diff(((Lines)object).textToArray(), objectArray).toRCSString(RCS_NEWLINE);
        }
        if (string2.length() == 0) {
            return null;
        }
        object = null;
        if (bl) {
            object = this.newNode(version, this.head);
            ((Node)object).setText(objectArray);
            this.head.setText(string2);
            this.head = (TrunkNode)object;
        } else {
            object = this.newNode(version);
            ((Node)object).setText(string2);
            if (version.size() > node.getVersion().size()) {
                node.addBranch((BranchNode)object);
            } else {
                node.setRCSNext((Node)object);
            }
        }
        ((Node)object).setLog(string);
        return ((Node)object).getVersion();
    }

    public Object[] doKeywords(Object[] objectArray, Node node) throws PatchFailedException {
        Object[] objectArray2 = new Object[]{this.filename, new File(this.filename).getName(), node.getVersion().toString(), node.getDate(), node.getAuthor(), node.getState(), node.getLocker()};
        Object[] objectArray3 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray3[i] = FORMATTER.update(objectArray[i].toString(), objectArray2);
        }
        return objectArray3;
    }

    protected static Object[] removeKeywords(Object[] objectArray) throws PatchFailedException {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = FORMATTER.reset(objectArray[i].toString());
        }
        return objectArray2;
    }

    public Node[] changeLog() {
        return this.changeLog(this.head.version);
    }

    public Node[] changeLog(Version version) {
        return this.changeLog(version, this.head.root().version);
    }

    public Node[] changeLog(Version version, Version version2) {
        Node node = this.findNode(version);
        if (node == null) {
            throw new NodeNotFoundException(version.toString());
        }
        Node node2 = this.findNode(version2);
        if (node2 == null) {
            throw new NodeNotFoundException(version2.toString());
        }
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Node node3 = node;
        while (node3 != null) {
            linkedList.add(0, node3);
            if (node3 == node2) break;
            node3 = node3.parent;
        }
        if (node3 == null) {
            throw new NodeNotFoundException(version2.toString());
        }
        return linkedList.toArray(new Node[linkedList.size()]);
    }

    public String getDesc() {
        return this.desc;
    }

    public String getLog(Version version) throws NodeNotFoundException {
        Node node = this.findNode(version);
        if (node == null) {
            throw new NodeNotFoundException("There's no version " + version);
        }
        return node.getLog();
    }

    public String getLog(String string) throws InvalidVersionNumberException, NodeNotFoundException {
        return this.getLog(new Version(string));
    }
}

