require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_CPU_H_)) {
    eval 'sub _ARM_CPU_H_ () {1;}' unless defined(&_ARM_CPU_H_);
    if(defined(&__arm__)) {
	eval 'sub CPU_DEBUG () {1;}' unless defined(&CPU_DEBUG);
	eval 'sub CPU_BOOTED_DEVICE () {2;}' unless defined(&CPU_BOOTED_DEVICE);
	eval 'sub CPU_BOOTED_KERNEL () {3;}' unless defined(&CPU_BOOTED_KERNEL);
	eval 'sub CPU_CONSDEV () {4;}' unless defined(&CPU_CONSDEV);
	eval 'sub CPU_POWERSAVE () {5;}' unless defined(&CPU_POWERSAVE);
	if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	    if(!defined(&_MODULE)  && defined(&_KERNEL_OPT)) {
		require './arm/opt_multiprocessor.ph';
		require './arm/opt_cpuoptions.ph';
		require './arm/opt_lockdebug.ph';
		require './arm/opt_cputypes.ph';
	    }
	    unless(defined(&_LOCORE)) {
		if(defined(&TPIDRPRW_IS_CURLWP) || defined(&TPIDRPRW_IS_CURCPU)) {
		    require 'arm/armreg.ph';
		}
		eval 'sub CLKF_USERMODE {
		    my($cf) = @_;
    		    eval q(((($cf)-> ($cf_tf->{tf_spsr}) &  &PSR_MODE) ==  &PSR_USR32_MODE));
		}' unless defined(&CLKF_USERMODE);
		if(!defined(&__ARM_EABI__)) {
		    eval 'sub CLKF_INTR {
		        my($cf) = @_;
    			eval q((( &curcpu()-> &ci_intr_depth > 1) || (($cf)-> ($cf_tf->{tf_spsr}) &  &PSR_MODE) ==  &PSR_UND32_MODE));
		    }' unless defined(&CLKF_INTR);
		} else {
		    eval 'sub CLKF_INTR {
		        my($cf) = @_;
    			eval q((( &void)($cf),  &curcpu()-> &ci_intr_depth > 1));
		    }' unless defined(&CLKF_INTR);
		}
		eval 'sub CLKF_PC {
		    my($frame) = @_;
    		    eval q(( ($frame->{cf_tf}->{tf_pc})));
		}' unless defined(&CLKF_PC);
		eval 'sub LWP_PC {
		    my($l) = @_;
    		    eval q(( &lwp_trapframe($l)-> &tf_pc));
		}' unless defined(&LWP_PC);
		if(defined(&_KERNEL)) {
		}
		if(defined(&_KMEMUSER)) {
		    require 'sys/intr.ph';
		}
		require 'sys/atomic.ph';
		require 'sys/cpu_data.ph';
		require 'sys/device_if.ph';
		require 'sys/evcnt.ph';
		if(defined(&MP_CPU_INFO_MEMBERS)) {
		}
		if(defined(&_MODULE)) {
		    eval 'sub curlwp () { &arm_curlwp();}' unless defined(&curlwp);
		    eval 'sub curcpu () {
		        eval q( &arm_curcpu());
		    }' unless defined(&curcpu);
		}
 elsif(defined(&TPIDRPRW_IS_CURLWP)) {
		    eval 'sub _curlwp {
		        my($void) = @_;
    			eval q({   &armreg_tpidrprw_read(); });
		    }' unless defined(&_curlwp);
		    eval 'sub _curlwp_set {
		        my($l) = @_;
    			eval q({  &armreg_tpidrprw_write(( &uintptr_t)$l); });
		    }' unless defined(&_curlwp_set);
		    eval 'sub curlwp () { &_curlwp();}' unless defined(&curlwp);
		    eval 'sub curcpu () {
		        eval q( &lwp_getcpu( &_curlwp()));
		    }' unless defined(&curcpu);
		}
 elsif(defined(&TPIDRPRW_IS_CURCPU)) {
		    if(defined(&__HAVE_PREEMPTION)) {
			die("__HAVE_PREEMPTION\ requires\ TPIDRPRW_IS_CURLWP");
		    }
		    eval 'sub curcpu {
		        my($void) = @_;
    			eval q({   &armreg_tpidrprw_read(); });
		    }' unless defined(&curcpu);
		}
 elsif(!defined(&MULTIPROCESSOR)) {
		    eval 'sub curcpu () {
		        eval q(( &cpu_info_store));
		    }' unless defined(&curcpu);
		}
 elsif(!defined(&__HAVE_PREEMPTION)) {
		    die("MULTIPROCESSOR\ \&\&\ \!__HAVE_PREEMPTION\ requires\ TPIDRPRW_IS_CURCPU\ or\ TPIDRPRW_IS_CURLWP");
		} else {
		    die("MULTIPROCESSOR\ \&\&\ __HAVE_PREEMPTION\ requires\ TPIDRPRW_IS_CURLWP");
		}
		unless(defined(&curlwp)) {
		    eval 'sub curlwp () {( &curcpu()-> &ci_curlwp);}' unless defined(&curlwp);
		}
		eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
		if(defined(&_MODULE) || defined(&MULTIPROCESSOR)) {
		    eval 'sub cpu_number () {
		        eval q(( &curcpu()-> &ci_index));
		    }' unless defined(&cpu_number);
		    eval 'sub CPU_IS_PRIMARY {
		        my($ci) = @_;
    			eval q((($ci)-> &ci_index == 0));
		    }' unless defined(&CPU_IS_PRIMARY);
		    eval 'sub CPU_INFO_FOREACH {
		        my($cii, $ci) = @_;
    			eval q($cii = 0, $ci =  $cpu_info[0]; $cii < ( &ncpu ?  &ncpu : 1)  && ($ci =  $cpu_info[$cii]) !=  &NULL; $cii++);
		    }' unless defined(&CPU_INFO_FOREACH);
		} else {
		    eval 'sub cpu_number () {
		        eval q(0);
		    }' unless defined(&cpu_number);
		    eval 'sub CPU_IS_PRIMARY {
		        my($ci) = @_;
    			eval q( &true);
		    }' unless defined(&CPU_IS_PRIMARY);
		    eval 'sub CPU_INFO_FOREACH {
		        my($cii, $ci) = @_;
    			eval q($cii = 0,  &__USE($cii), $ci =  &curcpu(); $ci !=  &NULL; $ci =  &NULL);
		    }' unless defined(&CPU_INFO_FOREACH);
		}
		if(defined(&MULTIPROCESSOR)) {
		}
		eval 'sub LWP0_CPU_INFO () {( &cpu_info_store);}' unless defined(&LWP0_CPU_INFO);
		eval 'sub curcpl {
		    my($void) = @_;
    		    eval q({  &curcpu()-> &ci_cpl; });
		}' unless defined(&curcpl);
		eval 'sub set_curcpl {
		    my($pri) = @_;
    		    eval q({  &curcpu()-> &ci_cpl = $pri; });
		}' unless defined(&set_curcpl);
# some #ifdef were dropped here -- fill in the blanks
		eval 'sub cpu_dosoftints {
		    my($void) = @_;
    		    eval q({  &endif });
		}' unless defined(&cpu_dosoftints);
		if(defined(&__HAVE_PREEMPTION)) {
		    eval 'sub setsoftast {
		        my($ci) = @_;
    			eval q( &atomic_or_uint(($ci)-> &ci_astpending,  &__BIT(0)));
		    }' unless defined(&setsoftast);
		} else {
		    eval 'sub setsoftast {
		        my($ci) = @_;
    			eval q((($ci)-> &ci_astpending =  &__BIT(0)));
		    }' unless defined(&setsoftast);
		}
		eval 'sub cpu_signotify {
		    my($l) = @_;
    		    eval q( &setsoftast(($l)-> &l_cpu));
		}' unless defined(&cpu_signotify);
		eval 'sub cpu_need_proftick {
		    my($l) = @_;
    		    eval q((($l)-> &l_pflag |=  &LP_OWEUPC,  &setsoftast(($l)-> &l_cpu)));
		}' unless defined(&cpu_need_proftick);
	    }
	}
    }
 elsif(defined(&__aarch64__)) {
	require 'aarch64/cpu.ph';
    }
}
1;
