/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.table_script;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.plugins.sqlscript.SQLScriptPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlscript.prefs.SQLScriptPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.sqlscript.prefs.SQLScriptPreferencesManager;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.TableScriptConfigCtrl;

public class CreateTableScriptCommand
implements ICommand {
    private ISession _session;
    private final SQLScriptPlugin _plugin;
    private static ILogger s_log = LoggerController.createLogger(CreateTableScriptCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateTableScriptCommand.class);
    private static SQLScriptPreferenceBean prefs = SQLScriptPreferencesManager.getPreferences();

    public CreateTableScriptCommand(ISession session, SQLScriptPlugin plugin) {
        this._session = session;
        this._plugin = plugin;
    }

    public void execute() {
        IObjectTreeAPI api = FrameWorkAcessor.getObjectTreeAPI(this._session, this._plugin);
        IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
        this.scriptTablesToSQLEntryArea(dbObjs);
    }

    public void scriptTablesToSQLEntryArea(final IDatabaseObjectInfo[] dbObjs) {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                final String script = CreateTableScriptCommand.this.createTableScriptString(dbObjs);
                if (null != script) {
                    GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ISQLPanelAPI api = FrameWorkAcessor.getSQLPanelAPI(CreateTableScriptCommand.this._session, CreateTableScriptCommand.this._plugin);
                            api.appendSQLScript(script, true);
                            CreateTableScriptCommand.this._session.selectMainTab(1);
                        }
                    });
                }
            }
        });
    }

    public String createTableScriptString(IDatabaseObjectInfo dbObj) {
        return this.createTableScriptString(new IDatabaseObjectInfo[]{dbObj});
    }

    public String createTableScriptString(IDatabaseObjectInfo[] dbObjs) {
        StringBuilder result = new StringBuilder(1000);
        ISQLDatabaseMetaData md = this._session.getMetaData();
        try {
            boolean isJdbcOdbc = md.getURL().startsWith("jdbc:odbc:");
            if (isJdbcOdbc) {
                this._session.showErrorMessage(i18n.JDBCODBC_MESSAGE);
                s_log.error((Object)i18n.JDBCODBC_MESSAGE);
            }
            final TableScriptConfigCtrl tscc = new TableScriptConfigCtrl((JFrame)this._session.getApplication().getMainFrame());
            if (1 < dbObjs.length) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        tscc.doModal();
                    }
                };
                GUIUtils.processOnSwingEventThread((Runnable)task, (boolean)true);
                if (!tscc.isOk()) {
                    return null;
                }
            }
            CreateScriptPreferences csprefs = new CreateScriptPreferences();
            csprefs.setConstraintsAtEnd(tscc.isConstAndIndAtEnd());
            csprefs.setIncludeExternalReferences(tscc.includeConstToTablesNotInScript());
            csprefs.setDeleteAction(prefs.getDeleteAction());
            csprefs.setDeleteRefAction(prefs.isDeleteRefAction());
            csprefs.setUpdateAction(prefs.getUpdateAction());
            csprefs.setUpdateRefAction(prefs.isUpdateRefAction());
            csprefs.setQualifyTableNames(prefs.isQualifyTableNames());
            csprefs.setUseDoubleQuotes(prefs.isUseDoubleQuotes());
            List<ITableInfo> tables = this.convertArrayToList(dbObjs);
            HibernateDialect dialect = DialectFactory.getDialect((int)0, (JFrame)this._session.getApplication().getMainFrame(), (ISQLDatabaseMetaData)md);
            List sqls = dialect.getCreateTableSQL(tables, md, csprefs, isJdbcOdbc);
            String sep = this._session.getQueryTokenizer().getSQLStatementSeparator();
            for (String sql : sqls) {
                result.append(sql);
                result.append("\n");
                result.append(sep);
                result.append("\n");
            }
        }
        catch (Exception e) {
            this._session.showErrorMessage((Throwable)e);
        }
        return result.toString();
    }

    private List<ITableInfo> convertArrayToList(IDatabaseObjectInfo[] dbObjs) {
        ArrayList<ITableInfo> result = new ArrayList<ITableInfo>();
        for (IDatabaseObjectInfo dbObj : dbObjs) {
            if (!(dbObj instanceof ITableInfo)) continue;
            ITableInfo ti = (ITableInfo)dbObj;
            result.add(ti);
        }
        return result;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String JDBCODBC_MESSAGE = CreateTableScriptCommand.access$000().getString("CreateTableScriptCommand.jdbcOdbcMessage");
    }
}

