/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.DnDTabbedPaneData;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.DndTabUtils;

public class GhostGlassPane
extends JPanel {
    private final AlphaComposite composite;
    private Point location = new Point(0, 0);
    private BufferedImage draggingGhost = null;
    private DnDTabbedPaneData _dnDTabbedPaneData;

    public GhostGlassPane(DnDTabbedPaneData dnDTabbedPaneData) {
        this._dnDTabbedPaneData = dnDTabbedPaneData;
        this.setOpaque(false);
        this.composite = AlphaComposite.getInstance(3, 0.5f);
    }

    public void setImage(BufferedImage draggingGhost) {
        this.draggingGhost = draggingGhost;
    }

    public void setPoint(Point location) {
        this.location = location;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(this.composite);
        if (this._dnDTabbedPaneData.isPaintScrollArea() && this._dnDTabbedPaneData.getTabbedPane().getTabLayoutPolicy() == 1) {
            g2.setPaint(Color.RED);
            g2.fill(this._dnDTabbedPaneData.getrBackward());
            g2.fill(this._dnDTabbedPaneData.getrForward());
        }
        if (this.draggingGhost != null) {
            double xx = this.location.getX() - (double)this.draggingGhost.getWidth(this) / 2.0;
            double yy = this.location.getY() - (double)this.draggingGhost.getHeight(this) / 2.0;
            g2.drawImage((Image)this.draggingGhost, (int)xx, (int)yy, null);
        }
        g2.setPaint(DndTabUtils.TARGET_LINE_COLOR);
        g2.fill(this._dnDTabbedPaneData.getTargetLineRectBuffer());
    }
}

