/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.jersey.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.zookeeper.server.jersey.cfg.Credentials;
import org.apache.zookeeper.server.jersey.cfg.Endpoint;

public class RestCfg {
    private Properties cfg = new Properties();
    private Set<Endpoint> endpoints = new HashSet<Endpoint>();
    private Credentials credentials = new Credentials();

    public RestCfg(String resource) throws IOException {
        this(RestCfg.class.getClassLoader().getResourceAsStream(resource));
    }

    public RestCfg(InputStream io) throws IOException {
        try {
            this.cfg.load(io);
            this.extractEndpoints();
            this.extractCredentials();
        }
        finally {
            io.close();
        }
    }

    private void extractCredentials() {
        if (this.cfg.containsKey("rest.http.auth")) {
            this.credentials = new Credentials(this.cfg.getProperty("rest.http.auth", ""));
        }
    }

    private void extractEndpoints() {
        String e;
        int count = 1;
        while ((e = this.cfg.getProperty(String.format("rest.endpoint.%d", count), null)) != null) {
            String[] parts = e.split(";");
            if (parts.length != 2) {
                ++count;
                continue;
            }
            Endpoint point = new Endpoint(parts[0], parts[1]);
            String c = this.cfg.getProperty(String.format("rest.endpoint.%d.http.auth", count), "");
            point.setCredentials(c);
            String digest = this.cfg.getProperty(String.format("rest.endpoint.%d.zk.digest", count), "");
            point.setZooKeeperAuthInfo(digest);
            this.endpoints.add(point);
            ++count;
        }
    }

    public int getPort() {
        return Integer.parseInt(this.cfg.getProperty("rest.port", "9998"));
    }

    public boolean useSSL() {
        return Boolean.valueOf(this.cfg.getProperty("rest.ssl", "false"));
    }

    public final Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public final Credentials getCredentials() {
        return this.credentials;
    }

    public String getJKS() {
        return this.cfg.getProperty("rest.ssl.jks");
    }

    public String getJKS(String def) {
        return this.cfg.getProperty("rest.ssl.jks", def);
    }

    public String getJKSPassword() {
        return this.cfg.getProperty("rest.ssl.jks.pass");
    }
}

