/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.buf;

public final class Ascii {
    private static final byte[] toUpper = new byte[256];
    private static final byte[] toLower = new byte[256];
    private static final boolean[] isAlpha = new boolean[256];
    private static final boolean[] isUpper = new boolean[256];
    private static final boolean[] isLower = new boolean[256];
    private static final boolean[] isWhite = new boolean[256];
    private static final boolean[] isDigit = new boolean[256];

    public static int toUpper(int c) {
        return toUpper[c & 0xFF] & 0xFF;
    }

    public static int toLower(int c) {
        return toLower[c & 0xFF] & 0xFF;
    }

    public static boolean isAlpha(int c) {
        return isAlpha[c & 0xFF];
    }

    public static boolean isUpper(int c) {
        return isUpper[c & 0xFF];
    }

    public static boolean isLower(int c) {
        return isLower[c & 0xFF];
    }

    public static boolean isWhite(int c) {
        return isWhite[c & 0xFF];
    }

    public static boolean isDigit(int c) {
        return isDigit[c & 0xFF];
    }

    public static int parseInt(byte[] b, int off, int len) throws NumberFormatException {
        byte c;
        if (b == null || len <= 0 || !Ascii.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        int n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            n = n * 10 + c - 48;
        }
        return n;
    }

    public static int parseInt(char[] b, int off, int len) throws NumberFormatException {
        char c;
        if (b == null || len <= 0 || !Ascii.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        int n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            n = n * 10 + c - 48;
        }
        return n;
    }

    public static long parseLong(byte[] b, int off, int len) throws NumberFormatException {
        byte c;
        if (b == null || len <= 0 || !Ascii.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        long n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            long m = n * 10L + (long)c - 48L;
            if (m < n) {
                throw new NumberFormatException();
            }
            n = m;
        }
        return n;
    }

    public static long parseLong(char[] b, int off, int len) throws NumberFormatException {
        char c;
        if (b == null || len <= 0 || !Ascii.isDigit(c = b[off++])) {
            throw new NumberFormatException();
        }
        long n = c - 48;
        while (--len > 0) {
            if (!Ascii.isDigit(c = b[off++])) {
                throw new NumberFormatException();
            }
            long m = n * 10L + (long)c - 48L;
            if (m < n) {
                throw new NumberFormatException();
            }
            n = m;
        }
        return n;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Ascii.toUpper[i] = (byte)i;
            Ascii.toLower[i] = (byte)i;
        }
        for (int lc = 97; lc <= 122; ++lc) {
            int uc = lc + 65 - 97;
            Ascii.toUpper[lc] = (byte)uc;
            Ascii.toLower[uc] = (byte)lc;
            Ascii.isAlpha[lc] = true;
            Ascii.isAlpha[uc] = true;
            Ascii.isLower[lc] = true;
            Ascii.isUpper[uc] = true;
        }
        Ascii.isWhite[32] = true;
        Ascii.isWhite[9] = true;
        Ascii.isWhite[13] = true;
        Ascii.isWhite[10] = true;
        Ascii.isWhite[12] = true;
        Ascii.isWhite[8] = true;
        for (int d = 48; d <= 57; ++d) {
            Ascii.isDigit[d] = true;
        }
    }
}

