/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.db.index.IndexNotAvailableException;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDeliveryTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MessageDeliveryTask.class);
    private final MessageIn message;
    private final int id;
    private final long constructionTime;
    private final boolean isCrossNodeTimestamp;
    private static final EnumSet<MessagingService.Verb> GOSSIP_VERBS = EnumSet.of(MessagingService.Verb.GOSSIP_DIGEST_ACK, MessagingService.Verb.GOSSIP_DIGEST_ACK2, MessagingService.Verb.GOSSIP_DIGEST_SYN);

    public MessageDeliveryTask(MessageIn message, int id, long timestamp, boolean isCrossNodeTimestamp) {
        assert (message != null);
        this.message = message;
        this.id = id;
        this.constructionTime = timestamp;
        this.isCrossNodeTimestamp = isCrossNodeTimestamp;
    }

    @Override
    public void run() {
        MessagingService.Verb verb = this.message.verb;
        if (MessagingService.DROPPABLE_VERBS.contains((Object)verb) && System.currentTimeMillis() > this.constructionTime + this.message.getTimeout()) {
            MessagingService.instance().incrementDroppedMessages(verb, this.isCrossNodeTimestamp);
            return;
        }
        IVerbHandler verbHandler = MessagingService.instance().getVerbHandler(verb);
        if (verbHandler == null) {
            logger.trace("Unknown verb {}", (Object)verb);
            return;
        }
        try {
            verbHandler.doVerb(this.message, this.id);
        }
        catch (IOException ioe) {
            this.handleFailure(ioe);
            throw new RuntimeException(ioe);
        }
        catch (TombstoneOverwhelmingException | IndexNotAvailableException e) {
            this.handleFailure(e);
            logger.error(e.getMessage());
        }
        catch (Throwable t) {
            this.handleFailure(t);
            throw t;
        }
        if (GOSSIP_VERBS.contains((Object)this.message.verb)) {
            Gossiper.instance.setLastProcessedMessageAt(this.constructionTime);
        }
    }

    private void handleFailure(Throwable t) {
        if (this.message.doCallbackOnFailure()) {
            MessageOut response = new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE).withParameter("FAIL", MessagingService.ONE_BYTE);
            MessagingService.instance().sendReply(response, this.id, this.message.from);
        }
    }
}

