/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.simpletext.SimpleTextCodec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MismatchedDirectoryReader;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public abstract class BaseStoredFieldsFormatTestCase
extends BaseIndexFileFormatTestCase {
    @Override
    protected void addRandomFields(Document d) {
        int numValues = BaseStoredFieldsFormatTestCase.random().nextInt(3);
        for (int i = 0; i < numValues; ++i) {
            d.add((IndexableField)new StoredField("f", TestUtil.randomSimpleString(BaseStoredFieldsFormatTestCase.random(), 100)));
        }
    }

    public void testRandomStoredFields() throws IOException {
        BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
        Random rand = BaseStoredFieldsFormatTestCase.random();
        RandomIndexWriter w = new RandomIndexWriter(rand, (Directory)dir, BaseStoredFieldsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseStoredFieldsFormatTestCase.random())).setMaxBufferedDocs(TestUtil.nextInt(rand, 5, 20)));
        int docCount = BaseStoredFieldsFormatTestCase.atLeast(200);
        int fieldCount = TestUtil.nextInt(rand, 1, 5);
        ArrayList<Integer> fieldIDs = new ArrayList<Integer>();
        FieldType customType = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        customType.setTokenized(false);
        Field idField = BaseStoredFieldsFormatTestCase.newField("id", "", customType);
        for (int i = 0; i < fieldCount; ++i) {
            fieldIDs.add(i);
        }
        HashMap<String, Document> docs = new HashMap<String, Document>();
        if (VERBOSE) {
            System.out.println("TEST: build index docCount=" + docCount);
        }
        FieldType customType2 = new FieldType();
        customType2.setStored(true);
        for (int i = 0; i < docCount; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)idField);
            String id = "" + i;
            idField.setStringValue(id);
            docs.put(id, doc);
            if (VERBOSE) {
                System.out.println("TEST: add doc id=" + id);
            }
            Iterator iterator = fieldIDs.iterator();
            while (iterator.hasNext()) {
                String s;
                int field = (Integer)iterator.next();
                if (rand.nextInt(4) != 3) {
                    s = TestUtil.randomUnicodeString(rand, 1000);
                    doc.add((IndexableField)BaseStoredFieldsFormatTestCase.newField("f" + field, s, customType2));
                    continue;
                }
                s = null;
            }
            w.addDocument(doc);
            if (rand.nextInt(50) == 17) {
                Collections.shuffle(fieldIDs, BaseStoredFieldsFormatTestCase.random());
            }
            if (rand.nextInt(5) != 3 || i <= 0) continue;
            String delID = "" + rand.nextInt(i);
            if (VERBOSE) {
                System.out.println("TEST: delete doc id=" + delID);
            }
            w.deleteDocuments(new Term("id", delID));
            docs.remove(delID);
        }
        if (VERBOSE) {
            System.out.println("TEST: " + docs.size() + " docs in index; now load fields");
        }
        if (docs.size() > 0) {
            String[] idsList = docs.keySet().toArray(new String[docs.size()]);
            for (int x = 0; x < 2; ++x) {
                DirectoryReader r = this.maybeWrapWithMergingReader(w.getReader());
                IndexSearcher s = BaseStoredFieldsFormatTestCase.newSearcher((IndexReader)r);
                if (VERBOSE) {
                    System.out.println("TEST: cycle x=" + x + " r=" + r);
                }
                int num = BaseStoredFieldsFormatTestCase.atLeast(100);
                for (int iter = 0; iter < num; ++iter) {
                    String testID = idsList[rand.nextInt(idsList.length)];
                    if (VERBOSE) {
                        System.out.println("TEST: test id=" + testID);
                    }
                    TopDocs hits = s.search((Query)new TermQuery(new Term("id", testID)), 1);
                    BaseStoredFieldsFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value);
                    Document doc = r.document(hits.scoreDocs[0].doc);
                    Document docExp = (Document)docs.get(testID);
                    for (int i = 0; i < fieldCount; ++i) {
                        BaseStoredFieldsFormatTestCase.assertEquals((String)("doc " + testID + ", field f" + fieldCount + " is wrong"), (Object)docExp.get("f" + i), (Object)doc.get("f" + i));
                    }
                }
                r.close();
                w.forceMerge(1);
            }
        }
        w.close();
        dir.close();
    }

    public void testStoredFieldsOrder() throws Throwable {
        BaseDirectoryWrapper d = BaseStoredFieldsFormatTestCase.newDirectory();
        IndexWriter w = new IndexWriter((Directory)d, BaseStoredFieldsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseStoredFieldsFormatTestCase.random())));
        Document doc = new Document();
        FieldType customType = new FieldType();
        customType.setStored(true);
        doc.add((IndexableField)BaseStoredFieldsFormatTestCase.newField("zzz", "a b c", customType));
        doc.add((IndexableField)BaseStoredFieldsFormatTestCase.newField("aaa", "a b c", customType));
        doc.add((IndexableField)BaseStoredFieldsFormatTestCase.newField("zzz", "1 2 3", customType));
        w.addDocument((Iterable)doc);
        DirectoryReader r = this.maybeWrapWithMergingReader(w.getReader());
        Document doc2 = r.document(0);
        Iterator it = doc2.getFields().iterator();
        BaseStoredFieldsFormatTestCase.assertTrue((boolean)it.hasNext());
        Field f = (Field)it.next();
        BaseStoredFieldsFormatTestCase.assertEquals((Object)f.name(), (Object)"zzz");
        BaseStoredFieldsFormatTestCase.assertEquals((Object)f.stringValue(), (Object)"a b c");
        BaseStoredFieldsFormatTestCase.assertTrue((boolean)it.hasNext());
        f = (Field)it.next();
        BaseStoredFieldsFormatTestCase.assertEquals((Object)f.name(), (Object)"aaa");
        BaseStoredFieldsFormatTestCase.assertEquals((Object)f.stringValue(), (Object)"a b c");
        BaseStoredFieldsFormatTestCase.assertTrue((boolean)it.hasNext());
        f = (Field)it.next();
        BaseStoredFieldsFormatTestCase.assertEquals((Object)f.name(), (Object)"zzz");
        BaseStoredFieldsFormatTestCase.assertEquals((Object)f.stringValue(), (Object)"1 2 3");
        BaseStoredFieldsFormatTestCase.assertFalse((boolean)it.hasNext());
        r.close();
        w.close();
        d.close();
    }

    public void testBinaryFieldOffsetLength() throws IOException {
        BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
        IndexWriter w = new IndexWriter((Directory)dir, BaseStoredFieldsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseStoredFieldsFormatTestCase.random())));
        byte[] b = new byte[50];
        for (int i = 0; i < 50; ++i) {
            b[i] = (byte)(i + 77);
        }
        Document doc = new Document();
        StoredField f = new StoredField("binary", b, 10, 17);
        byte[] bx = f.binaryValue().bytes;
        BaseStoredFieldsFormatTestCase.assertTrue((bx != null ? 1 : 0) != 0);
        BaseStoredFieldsFormatTestCase.assertEquals((long)50L, (long)bx.length);
        BaseStoredFieldsFormatTestCase.assertEquals((long)10L, (long)f.binaryValue().offset);
        BaseStoredFieldsFormatTestCase.assertEquals((long)17L, (long)f.binaryValue().length);
        doc.add((IndexableField)f);
        w.addDocument((Iterable)doc);
        w.close();
        DirectoryReader ir = DirectoryReader.open((Directory)dir);
        Document doc2 = ir.document(0);
        IndexableField f2 = doc2.getField("binary");
        b = f2.binaryValue().bytes;
        BaseStoredFieldsFormatTestCase.assertTrue((b != null ? 1 : 0) != 0);
        BaseStoredFieldsFormatTestCase.assertEquals((float)17.0f, (float)b.length, (float)17.0f);
        BaseStoredFieldsFormatTestCase.assertEquals((long)87L, (long)b[0]);
        ir.close();
        dir.close();
    }

    public void testNumericField() throws Exception {
        BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
        RandomIndexWriter w = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir);
        int numDocs = BaseStoredFieldsFormatTestCase.atLeast(500);
        Number[] answers = new Number[numDocs];
        Class[] typeAnswers = new Class[numDocs];
        for (int id = 0; id < numDocs; ++id) {
            Class typeAnswer;
            StoredField nf;
            Number answer;
            Document doc = new Document();
            if (BaseStoredFieldsFormatTestCase.random().nextBoolean()) {
                if (BaseStoredFieldsFormatTestCase.random().nextBoolean()) {
                    float f = BaseStoredFieldsFormatTestCase.random().nextFloat();
                    answer = Float.valueOf(f);
                    nf = new StoredField("nf", f);
                    typeAnswer = Float.class;
                } else {
                    double d = BaseStoredFieldsFormatTestCase.random().nextDouble();
                    answer = d;
                    nf = new StoredField("nf", d);
                    typeAnswer = Double.class;
                }
            } else if (BaseStoredFieldsFormatTestCase.random().nextBoolean()) {
                int i = BaseStoredFieldsFormatTestCase.random().nextInt();
                answer = i;
                nf = new StoredField("nf", i);
                typeAnswer = Integer.class;
            } else {
                long l = BaseStoredFieldsFormatTestCase.random().nextLong();
                answer = l;
                nf = new StoredField("nf", l);
                typeAnswer = Long.class;
            }
            doc.add((IndexableField)nf);
            answers[id] = answer;
            typeAnswers[id] = typeAnswer;
            doc.add((IndexableField)new StoredField("id", id));
            doc.add((IndexableField)new IntPoint("id", new int[]{id}));
            doc.add((IndexableField)new NumericDocValuesField("id", (long)id));
            w.addDocument(doc);
        }
        DirectoryReader r = this.maybeWrapWithMergingReader(w.getReader());
        w.close();
        BaseStoredFieldsFormatTestCase.assertEquals((long)numDocs, (long)r.numDocs());
        for (LeafReaderContext ctx : r.leaves()) {
            LeafReader sub = ctx.reader();
            NumericDocValues ids = DocValues.getNumeric((LeafReader)sub, (String)"id");
            for (int docID = 0; docID < sub.numDocs(); ++docID) {
                Document doc = sub.document(docID);
                Field f = (Field)doc.getField("nf");
                BaseStoredFieldsFormatTestCase.assertTrue((String)("got f=" + f), (boolean)(f instanceof StoredField));
                BaseStoredFieldsFormatTestCase.assertEquals((long)docID, (long)ids.nextDoc());
                BaseStoredFieldsFormatTestCase.assertEquals((Object)answers[(int)ids.longValue()], (Object)f.numericValue());
            }
        }
        r.close();
        dir.close();
    }

    public void testIndexedBit() throws Exception {
        BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
        RandomIndexWriter w = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir);
        Document doc = new Document();
        FieldType onlyStored = new FieldType();
        onlyStored.setStored(true);
        doc.add((IndexableField)new Field("field", (CharSequence)"value", (IndexableFieldType)onlyStored));
        doc.add((IndexableField)new StringField("field2", "value", Field.Store.YES));
        w.addDocument(doc);
        DirectoryReader r = this.maybeWrapWithMergingReader(w.getReader());
        w.close();
        BaseStoredFieldsFormatTestCase.assertEquals((Object)IndexOptions.NONE, (Object)r.document(0).getField("field").fieldType().indexOptions());
        BaseStoredFieldsFormatTestCase.assertNotNull((Object)r.document(0).getField("field2").fieldType().indexOptions());
        r.close();
        dir.close();
    }

    public void testReadSkip() throws IOException {
        BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
        IndexWriterConfig iwConf = BaseStoredFieldsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseStoredFieldsFormatTestCase.random()));
        iwConf.setMaxBufferedDocs(RandomNumbers.randomIntBetween((Random)BaseStoredFieldsFormatTestCase.random(), (int)2, (int)30));
        RandomIndexWriter iw = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir, iwConf);
        FieldType ft = new FieldType();
        ft.setStored(true);
        ft.freeze();
        String string = TestUtil.randomSimpleString(BaseStoredFieldsFormatTestCase.random(), 50);
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        long l = BaseStoredFieldsFormatTestCase.random().nextBoolean() ? (long)BaseStoredFieldsFormatTestCase.random().nextInt(42) : BaseStoredFieldsFormatTestCase.random().nextLong();
        int i = BaseStoredFieldsFormatTestCase.random().nextBoolean() ? BaseStoredFieldsFormatTestCase.random().nextInt(42) : BaseStoredFieldsFormatTestCase.random().nextInt();
        float f = BaseStoredFieldsFormatTestCase.random().nextFloat();
        double d = BaseStoredFieldsFormatTestCase.random().nextDouble();
        List<Field> fields = Arrays.asList(new Field("bytes", bytes, (IndexableFieldType)ft), new Field("string", (CharSequence)string, (IndexableFieldType)ft), new StoredField("long", l), new StoredField("int", i), new StoredField("float", f), new StoredField("double", d));
        for (int k = 0; k < 100; ++k) {
            Document doc = new Document();
            for (Field fld : fields) {
                doc.add((IndexableField)fld);
            }
            iw.w.addDocument((Iterable)doc);
        }
        iw.commit();
        DirectoryReader reader = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        int docID = BaseStoredFieldsFormatTestCase.random().nextInt(100);
        for (Field fld : fields) {
            String fldName = fld.name();
            Document sDoc = reader.document(docID, Collections.singleton(fldName));
            IndexableField sField = sDoc.getField(fldName);
            if (Field.class.equals(fld.getClass())) {
                BaseStoredFieldsFormatTestCase.assertEquals((Object)fld.binaryValue(), (Object)sField.binaryValue());
                BaseStoredFieldsFormatTestCase.assertEquals((Object)fld.stringValue(), (Object)sField.stringValue());
                continue;
            }
            BaseStoredFieldsFormatTestCase.assertEquals((Object)fld.numericValue(), (Object)sField.numericValue());
        }
        reader.close();
        iw.close();
        dir.close();
    }

    public void testEmptyDocs() throws IOException {
        BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
        IndexWriterConfig iwConf = BaseStoredFieldsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseStoredFieldsFormatTestCase.random()));
        iwConf.setMaxBufferedDocs(RandomNumbers.randomIntBetween((Random)BaseStoredFieldsFormatTestCase.random(), (int)2, (int)30));
        RandomIndexWriter iw = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir, iwConf);
        Document emptyDoc = new Document();
        int numDocs = BaseStoredFieldsFormatTestCase.random().nextBoolean() ? 1 : BaseStoredFieldsFormatTestCase.atLeast(1000);
        for (int i = 0; i < numDocs; ++i) {
            iw.addDocument(emptyDoc);
        }
        iw.commit();
        DirectoryReader rd = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        for (int i = 0; i < numDocs; ++i) {
            Document doc = rd.document(i);
            BaseStoredFieldsFormatTestCase.assertNotNull((Object)doc);
            BaseStoredFieldsFormatTestCase.assertTrue((boolean)doc.getFields().isEmpty());
        }
        rd.close();
        iw.close();
        dir.close();
    }

    public void testConcurrentReads() throws Exception {
        BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
        IndexWriterConfig iwConf = BaseStoredFieldsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseStoredFieldsFormatTestCase.random()));
        iwConf.setMaxBufferedDocs(RandomNumbers.randomIntBetween((Random)BaseStoredFieldsFormatTestCase.random(), (int)2, (int)30));
        RandomIndexWriter iw = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir, iwConf);
        Document doc = new Document();
        StringField field = new StringField("fld", "", Field.Store.YES);
        doc.add((IndexableField)field);
        final int numDocs = BaseStoredFieldsFormatTestCase.atLeast(1000);
        for (int i = 0; i < numDocs; ++i) {
            field.setStringValue("" + i);
            iw.addDocument(doc);
        }
        iw.commit();
        final DirectoryReader rd = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        final IndexSearcher searcher = new IndexSearcher((IndexReader)rd);
        int concurrentReads = BaseStoredFieldsFormatTestCase.atLeast(5);
        final int readsPerThread = BaseStoredFieldsFormatTestCase.atLeast(50);
        ArrayList<1> readThreads = new ArrayList<1>();
        final AtomicReference ex = new AtomicReference();
        for (int i = 0; i < concurrentReads; ++i) {
            readThreads.add(new Thread(){
                int[] queries;
                {
                    this.queries = new int[readsPerThread];
                    for (int i = 0; i < this.queries.length; ++i) {
                        this.queries[i] = LuceneTestCase.random().nextInt(numDocs);
                    }
                }

                @Override
                public void run() {
                    for (int q : this.queries) {
                        TermQuery query = new TermQuery(new Term("fld", "" + q));
                        try {
                            TopDocs topDocs = searcher.search((Query)query, 1);
                            if (topDocs.totalHits.value != 1L) {
                                throw new IllegalStateException("Expected 1 hit, got " + topDocs.totalHits.value);
                            }
                            Document sdoc = rd.document(topDocs.scoreDocs[0].doc);
                            if (sdoc == null || sdoc.get("fld") == null) {
                                throw new IllegalStateException("Could not find document " + q);
                            }
                            if (Integer.toString(q).equals(sdoc.get("fld"))) continue;
                            throw new IllegalStateException("Expected " + q + ", but got " + sdoc.get("fld"));
                        }
                        catch (Exception e) {
                            ex.compareAndSet(null, e);
                        }
                    }
                }
            });
        }
        for (Thread thread : readThreads) {
            thread.start();
        }
        for (Thread thread : readThreads) {
            thread.join();
        }
        rd.close();
        if (ex.get() != null) {
            throw (Exception)ex.get();
        }
        iw.close();
        dir.close();
    }

    private byte[] randomByteArray(int length, int max) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)BaseStoredFieldsFormatTestCase.random().nextInt(max);
        }
        return result;
    }

    public void testWriteReadMerge() throws IOException {
        int i;
        Object otherCodec = "SimpleText".equals(Codec.getDefault().getName()) ? TestUtil.getDefaultCodec() : new SimpleTextCodec();
        BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
        IndexWriterConfig iwConf = BaseStoredFieldsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseStoredFieldsFormatTestCase.random()));
        iwConf.setMaxBufferedDocs(RandomNumbers.randomIntBetween((Random)BaseStoredFieldsFormatTestCase.random(), (int)2, (int)30));
        RandomIndexWriter iw = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir, iwConf);
        int docCount = BaseStoredFieldsFormatTestCase.atLeast(200);
        byte[][][] data = new byte[docCount][][];
        for (int i2 = 0; i2 < docCount; ++i2) {
            int fieldCount = BaseStoredFieldsFormatTestCase.rarely() ? RandomNumbers.randomIntBetween((Random)BaseStoredFieldsFormatTestCase.random(), (int)1, (int)500) : RandomNumbers.randomIntBetween((Random)BaseStoredFieldsFormatTestCase.random(), (int)1, (int)5);
            data[i2] = new byte[fieldCount][];
            for (int j = 0; j < fieldCount; ++j) {
                int length = BaseStoredFieldsFormatTestCase.rarely() ? BaseStoredFieldsFormatTestCase.random().nextInt(1000) : BaseStoredFieldsFormatTestCase.random().nextInt(10);
                int max = BaseStoredFieldsFormatTestCase.rarely() ? 256 : 2;
                data[i2][j] = this.randomByteArray(length, max);
            }
        }
        FieldType type = new FieldType((IndexableFieldType)StringField.TYPE_STORED);
        type.setIndexOptions(IndexOptions.NONE);
        type.freeze();
        IntPoint id = new IntPoint("id", new int[]{0});
        StoredField idStored = new StoredField("id", 0);
        for (i = 0; i < data.length; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)id);
            doc.add((IndexableField)idStored);
            id.setIntValue(i);
            idStored.setIntValue(i);
            for (int j = 0; j < data[i].length; ++j) {
                Field f = new Field("bytes" + j, data[i][j], (IndexableFieldType)type);
                doc.add((IndexableField)f);
            }
            iw.w.addDocument((Iterable)doc);
            if (!BaseStoredFieldsFormatTestCase.random().nextBoolean() || i % (data.length / 10) != 0) continue;
            iw.w.close();
            IndexWriterConfig iwConfNew = BaseStoredFieldsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseStoredFieldsFormatTestCase.random()));
            if (iwConf.getCodec() == otherCodec) {
                iwConfNew.setCodec(Codec.getDefault());
            } else {
                iwConfNew.setCodec(otherCodec);
            }
            iwConf = iwConfNew;
            iw = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir, iwConf);
        }
        for (i = 0; i < 10; ++i) {
            int min = BaseStoredFieldsFormatTestCase.random().nextInt(data.length);
            int max = min + BaseStoredFieldsFormatTestCase.random().nextInt(20);
            iw.deleteDocuments(IntPoint.newRangeQuery((String)"id", (int)min, (int)(max - 1)));
        }
        iw.forceMerge(2);
        iw.commit();
        DirectoryReader ir = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        BaseStoredFieldsFormatTestCase.assertTrue((ir.numDocs() > 0 ? 1 : 0) != 0);
        int numDocs = 0;
        for (int i3 = 0; i3 < ir.maxDoc(); ++i3) {
            Document doc = ir.document(i3);
            if (doc == null) continue;
            ++numDocs;
            int docId = doc.getField("id").numericValue().intValue();
            BaseStoredFieldsFormatTestCase.assertEquals((long)(data[docId].length + 1), (long)doc.getFields().size());
            for (int j = 0; j < data[docId].length; ++j) {
                byte[] arr = data[docId][j];
                BytesRef arr2Ref = doc.getBinaryValue("bytes" + j);
                byte[] arr2 = BytesRef.deepCopyOf((BytesRef)arr2Ref).bytes;
                BaseStoredFieldsFormatTestCase.assertArrayEquals((byte[])arr, (byte[])arr2);
            }
        }
        BaseStoredFieldsFormatTestCase.assertTrue((ir.numDocs() <= numDocs ? 1 : 0) != 0);
        ir.close();
        iw.deleteAll();
        iw.commit();
        iw.forceMerge(1);
        iw.close();
        dir.close();
    }

    public void testMergeFilterReader() throws IOException {
        BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
        RandomIndexWriter w = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir);
        int numDocs = BaseStoredFieldsFormatTestCase.atLeast(200);
        Object[] stringValues = new String[10];
        for (int i = 0; i < stringValues.length; ++i) {
            stringValues[i] = RandomStrings.randomRealisticUnicodeOfLength((Random)BaseStoredFieldsFormatTestCase.random(), (int)10);
        }
        Document[] docs = new Document[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)new StringField("to_delete", BaseStoredFieldsFormatTestCase.random().nextBoolean() ? "yes" : "no", Field.Store.NO));
            doc.add((IndexableField)new StoredField("id", i));
            doc.add((IndexableField)new StoredField("i", BaseStoredFieldsFormatTestCase.random().nextInt(50)));
            doc.add((IndexableField)new StoredField("l", BaseStoredFieldsFormatTestCase.random().nextLong()));
            doc.add((IndexableField)new StoredField("d", BaseStoredFieldsFormatTestCase.random().nextDouble()));
            doc.add((IndexableField)new StoredField("f", BaseStoredFieldsFormatTestCase.random().nextFloat()));
            doc.add((IndexableField)new StoredField("s", (String)RandomPicks.randomFrom((Random)BaseStoredFieldsFormatTestCase.random(), (Object[])stringValues)));
            doc.add((IndexableField)new StoredField("b", new BytesRef((CharSequence)RandomPicks.randomFrom((Random)BaseStoredFieldsFormatTestCase.random(), (Object[])stringValues))));
            docs[i] = doc;
            w.addDocument(doc);
        }
        if (BaseStoredFieldsFormatTestCase.random().nextBoolean()) {
            w.deleteDocuments(new Term("to_delete", "yes"));
        }
        w.commit();
        w.close();
        DummyFilterDirectoryReader reader = new DummyFilterDirectoryReader(this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir)));
        BaseDirectoryWrapper dir2 = BaseStoredFieldsFormatTestCase.newDirectory();
        w = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir2);
        TestUtil.addIndexesSlowly(w.w, new DirectoryReader[]{reader});
        reader.close();
        dir.close();
        reader = this.maybeWrapWithMergingReader(w.getReader());
        for (int i = 0; i < reader.maxDoc(); ++i) {
            Document doc = reader.document(i);
            int id = doc.getField("id").numericValue().intValue();
            Document expected = docs[id];
            BaseStoredFieldsFormatTestCase.assertEquals((Object)expected.get("s"), (Object)doc.get("s"));
            BaseStoredFieldsFormatTestCase.assertEquals((Object)expected.getField("i").numericValue(), (Object)doc.getField("i").numericValue());
            BaseStoredFieldsFormatTestCase.assertEquals((Object)expected.getField("l").numericValue(), (Object)doc.getField("l").numericValue());
            BaseStoredFieldsFormatTestCase.assertEquals((Object)expected.getField("d").numericValue(), (Object)doc.getField("d").numericValue());
            BaseStoredFieldsFormatTestCase.assertEquals((Object)expected.getField("f").numericValue(), (Object)doc.getField("f").numericValue());
            BaseStoredFieldsFormatTestCase.assertEquals((Object)expected.getField("b").binaryValue(), (Object)doc.getField("b").binaryValue());
        }
        reader.close();
        w.close();
        TestUtil.checkIndex((Directory)dir2);
        dir2.close();
    }

    @LuceneTestCase.Nightly
    public void testBigDocuments() throws IOException {
        int i;
        BaseStoredFieldsFormatTestCase.assumeWorkingMMapOnWindows();
        MockDirectoryWrapper dir = new MockDirectoryWrapper(BaseStoredFieldsFormatTestCase.random(), (Directory)new MMapDirectory(BaseStoredFieldsFormatTestCase.createTempDir("testBigDocuments")));
        IndexWriterConfig iwConf = BaseStoredFieldsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseStoredFieldsFormatTestCase.random()));
        iwConf.setMaxBufferedDocs(RandomNumbers.randomIntBetween((Random)BaseStoredFieldsFormatTestCase.random(), (int)2, (int)30));
        RandomIndexWriter iw = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir, iwConf);
        if (dir instanceof MockDirectoryWrapper) {
            dir.setThrottling(MockDirectoryWrapper.Throttling.NEVER);
        }
        Document emptyDoc = new Document();
        Document bigDoc1 = new Document();
        Document bigDoc2 = new Document();
        StringField idField = new StringField("id", "", Field.Store.NO);
        emptyDoc.add((IndexableField)idField);
        bigDoc1.add((IndexableField)idField);
        bigDoc2.add((IndexableField)idField);
        FieldType onlyStored = new FieldType((IndexableFieldType)StringField.TYPE_STORED);
        onlyStored.setIndexOptions(IndexOptions.NONE);
        Field smallField = new Field("fld", this.randomByteArray(BaseStoredFieldsFormatTestCase.random().nextInt(10), 256), (IndexableFieldType)onlyStored);
        int numFields = RandomNumbers.randomIntBetween((Random)BaseStoredFieldsFormatTestCase.random(), (int)500000, (int)1000000);
        for (int i2 = 0; i2 < numFields; ++i2) {
            bigDoc1.add((IndexableField)smallField);
        }
        Field bigField = new Field("fld", this.randomByteArray(RandomNumbers.randomIntBetween((Random)BaseStoredFieldsFormatTestCase.random(), (int)1000000, (int)5000000), 2), (IndexableFieldType)onlyStored);
        bigDoc2.add((IndexableField)bigField);
        int numDocs = BaseStoredFieldsFormatTestCase.atLeast(5);
        Document[] docs = new Document[numDocs];
        for (i = 0; i < numDocs; ++i) {
            docs[i] = (Document)RandomPicks.randomFrom((Random)BaseStoredFieldsFormatTestCase.random(), Arrays.asList(emptyDoc, bigDoc1, bigDoc2));
        }
        for (i = 0; i < numDocs; ++i) {
            idField.setStringValue("" + i);
            iw.addDocument(docs[i]);
            if (BaseStoredFieldsFormatTestCase.random().nextInt(numDocs) != 0) continue;
            iw.commit();
        }
        iw.commit();
        iw.forceMerge(1);
        DirectoryReader rd = this.maybeWrapWithMergingReader(DirectoryReader.open((Directory)dir));
        IndexSearcher searcher = new IndexSearcher((IndexReader)rd);
        for (int i3 = 0; i3 < numDocs; ++i3) {
            TermQuery query = new TermQuery(new Term("id", "" + i3));
            TopDocs topDocs = searcher.search((Query)query, 1);
            BaseStoredFieldsFormatTestCase.assertEquals((String)("" + i3), (long)1L, (long)topDocs.totalHits.value);
            Document doc = rd.document(topDocs.scoreDocs[0].doc);
            BaseStoredFieldsFormatTestCase.assertNotNull((Object)doc);
            IndexableField[] fieldValues = doc.getFields("fld");
            BaseStoredFieldsFormatTestCase.assertEquals((long)docs[i3].getFields("fld").length, (long)fieldValues.length);
            if (fieldValues.length <= 0) continue;
            BaseStoredFieldsFormatTestCase.assertEquals((Object)docs[i3].getFields("fld")[0].binaryValue(), (Object)fieldValues[0].binaryValue());
        }
        rd.close();
        iw.close();
        dir.close();
    }

    public void testBulkMergeWithDeletes() throws IOException {
        int numDocs = BaseStoredFieldsFormatTestCase.atLeast(200);
        BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
        RandomIndexWriter w = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir, BaseStoredFieldsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseStoredFieldsFormatTestCase.random())).setMergePolicy(NoMergePolicy.INSTANCE));
        for (int i = 0; i < numDocs; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", Integer.toString(i), Field.Store.YES));
            doc.add((IndexableField)new StoredField("f", TestUtil.randomSimpleString(BaseStoredFieldsFormatTestCase.random())));
            w.addDocument(doc);
        }
        int deleteCount = TestUtil.nextInt(BaseStoredFieldsFormatTestCase.random(), 5, numDocs);
        for (int i = 0; i < deleteCount; ++i) {
            int id = BaseStoredFieldsFormatTestCase.random().nextInt(numDocs);
            w.deleteDocuments(new Term("id", Integer.toString(id)));
        }
        w.commit();
        w.close();
        w = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir);
        w.forceMerge(TestUtil.nextInt(BaseStoredFieldsFormatTestCase.random(), 1, 3));
        w.commit();
        w.close();
        TestUtil.checkIndex((Directory)dir);
        dir.close();
    }

    public void testMismatchedFields() throws Exception {
        Document doc;
        Directory[] dirs = new Directory[10];
        for (int i = 0; i < dirs.length; ++i) {
            int j;
            BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
            IndexWriterConfig iwc = new IndexWriterConfig(null);
            IndexWriter iw = new IndexWriter((Directory)dir, iwc);
            doc = new Document();
            for (j = 0; j < 10; ++j) {
                doc.add((IndexableField)new StringField(Integer.toString(j), Integer.toString(j), Field.Store.YES));
            }
            for (j = 0; j < 10; ++j) {
                iw.addDocument((Iterable)doc);
            }
            Object reader = this.maybeWrapWithMergingReader(DirectoryReader.open((IndexWriter)iw));
            if (BaseStoredFieldsFormatTestCase.random().nextBoolean()) {
                reader = new MismatchedDirectoryReader((DirectoryReader)reader, BaseStoredFieldsFormatTestCase.random());
            }
            dirs[i] = BaseStoredFieldsFormatTestCase.newDirectory();
            IndexWriter adder = new IndexWriter(dirs[i], new IndexWriterConfig(null));
            TestUtil.addIndexesSlowly(adder, new DirectoryReader[]{reader});
            adder.commit();
            adder.close();
            IOUtils.close((Closeable[])new Closeable[]{reader, iw, dir});
        }
        BaseDirectoryWrapper everything = BaseStoredFieldsFormatTestCase.newDirectory();
        IndexWriter iw = new IndexWriter((Directory)everything, new IndexWriterConfig(null));
        iw.addIndexes(dirs);
        iw.forceMerge(1);
        LeafReader ir = BaseStoredFieldsFormatTestCase.getOnlyLeafReader((IndexReader)DirectoryReader.open((IndexWriter)iw));
        for (int i = 0; i < ir.maxDoc(); ++i) {
            doc = ir.document(i);
            BaseStoredFieldsFormatTestCase.assertEquals((long)10L, (long)doc.getFields().size());
            for (int j = 0; j < 10; ++j) {
                BaseStoredFieldsFormatTestCase.assertEquals((Object)Integer.toString(j), (Object)doc.get(Integer.toString(j)));
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{iw, ir, everything});
        IOUtils.close((Closeable[])dirs);
    }

    public void testRandomStoredFieldsWithIndexSort() throws Exception {
        SortField[] sortFields = BaseStoredFieldsFormatTestCase.random().nextBoolean() ? new SortField[]{new SortField("sort-1", SortField.Type.LONG), new SortField("sort-2", SortField.Type.INT)} : new SortField[]{new SortField("sort-1", SortField.Type.LONG)};
        ArrayList<String> storedFields = new ArrayList<String>();
        int numFields = TestUtil.nextInt(BaseStoredFieldsFormatTestCase.random(), 1, 10);
        for (int i = 0; i < numFields; ++i) {
            storedFields.add("f-" + i);
        }
        FieldType storeType = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        storeType.setStored(true);
        Function<String, Document> documentFactory = id -> {
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", id, BaseStoredFieldsFormatTestCase.random().nextBoolean() ? Field.Store.YES : Field.Store.NO));
            if (BaseStoredFieldsFormatTestCase.random().nextInt(100) <= 5) {
                Collections.shuffle(storedFields, BaseStoredFieldsFormatTestCase.random());
            }
            for (String fieldName : storedFields) {
                if (!BaseStoredFieldsFormatTestCase.random().nextBoolean()) continue;
                String s = TestUtil.randomUnicodeString(BaseStoredFieldsFormatTestCase.random(), 100);
                doc.add((IndexableField)BaseStoredFieldsFormatTestCase.newField(fieldName, s, storeType));
            }
            for (SortField sortField : sortFields) {
                doc.add((IndexableField)new NumericDocValuesField(sortField.getField(), (long)TestUtil.nextInt(BaseStoredFieldsFormatTestCase.random(), 0, 10000)));
            }
            return doc;
        };
        HashMap<String, Document> docs = new HashMap<String, Document>();
        int numDocs = BaseStoredFieldsFormatTestCase.atLeast(100);
        for (int i = 0; i < numDocs; ++i) {
            String id2 = Integer.toString(i);
            docs.put(id2, documentFactory.apply(id2));
        }
        BaseDirectoryWrapper dir = BaseStoredFieldsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BaseStoredFieldsFormatTestCase.newIndexWriterConfig();
        iwc.setMaxBufferedDocs(TestUtil.nextInt(BaseStoredFieldsFormatTestCase.random(), 5, 20));
        iwc.setIndexSort(new Sort(sortFields));
        RandomIndexWriter iw = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)dir, iwc);
        ArrayList<String> addedIds = new ArrayList<String>();
        Runnable verifyStoreFields = () -> {
            if (addedIds.isEmpty()) {
                return;
            }
            try (DirectoryReader reader = this.maybeWrapWithMergingReader(iw.getReader());){
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                int iters = TestUtil.nextInt(BaseStoredFieldsFormatTestCase.random(), 1, 10);
                for (int i = 0; i < iters; ++i) {
                    String testID = (String)addedIds.get(BaseStoredFieldsFormatTestCase.random().nextInt(addedIds.size()));
                    if (VERBOSE) {
                        System.out.println("TEST: test id=" + testID);
                    }
                    TopDocs hits = searcher.search((Query)new TermQuery(new Term("id", testID)), 1);
                    BaseStoredFieldsFormatTestCase.assertEquals((long)1L, (long)hits.totalHits.value);
                    List expectedFields = ((Document)docs.get(testID)).getFields().stream().filter(f -> f.fieldType().stored()).collect(Collectors.toList());
                    Document actualDoc = reader.document(hits.scoreDocs[0].doc);
                    BaseStoredFieldsFormatTestCase.assertEquals((long)expectedFields.size(), (long)actualDoc.getFields().size());
                    for (IndexableField expectedField : expectedFields) {
                        IndexableField[] actualFields = actualDoc.getFields(expectedField.name());
                        BaseStoredFieldsFormatTestCase.assertEquals((long)1L, (long)actualFields.length);
                        BaseStoredFieldsFormatTestCase.assertEquals((Object)expectedField.stringValue(), (Object)actualFields[0].stringValue());
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        ArrayList ids = new ArrayList(docs.keySet());
        Collections.shuffle(ids, BaseStoredFieldsFormatTestCase.random());
        for (String id3 : ids) {
            block44: {
                if (BaseStoredFieldsFormatTestCase.random().nextInt(100) < 5) {
                    IndexWriterConfig otherIwc = BaseStoredFieldsFormatTestCase.newIndexWriterConfig();
                    otherIwc.setIndexSort(new Sort(sortFields));
                    try (BaseDirectoryWrapper otherDir = BaseStoredFieldsFormatTestCase.newDirectory();
                         RandomIndexWriter otherIw = new RandomIndexWriter(BaseStoredFieldsFormatTestCase.random(), (Directory)otherDir, otherIwc);){
                        otherIw.addDocument((Iterable)docs.get(id3));
                        try (DirectoryReader otherReader = otherIw.getReader();){
                            TestUtil.addIndexesSlowly(iw.w, otherReader);
                            break block44;
                        }
                    }
                }
                iw.addDocument((Iterable)docs.get(id3));
            }
            addedIds.add(id3);
            if (BaseStoredFieldsFormatTestCase.random().nextInt(100) < 5) {
                String deletingId = (String)addedIds.remove(BaseStoredFieldsFormatTestCase.random().nextInt(addedIds.size()));
                if (BaseStoredFieldsFormatTestCase.random().nextBoolean()) {
                    iw.deleteDocuments((Query)new TermQuery(new Term("id", deletingId)));
                    addedIds.remove(deletingId);
                } else {
                    Document newDoc = documentFactory.apply(deletingId);
                    docs.put(deletingId, newDoc);
                    iw.updateDocument(new Term("id", deletingId), newDoc);
                }
            }
            if (BaseStoredFieldsFormatTestCase.random().nextInt(100) < 5) {
                verifyStoreFields.run();
            }
            if (BaseStoredFieldsFormatTestCase.random().nextInt(100) >= 2) continue;
            iw.forceMerge(TestUtil.nextInt(BaseStoredFieldsFormatTestCase.random(), 1, 3));
        }
        verifyStoreFields.run();
        iw.forceMerge(TestUtil.nextInt(BaseStoredFieldsFormatTestCase.random(), 1, 3));
        verifyStoreFields.run();
        IOUtils.close((Closeable[])new Closeable[]{iw, dir});
    }

    private static class DummyFilterDirectoryReader
    extends FilterDirectoryReader {
        public DummyFilterDirectoryReader(DirectoryReader in) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    return new DummyFilterLeafReader(reader);
                }
            });
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new DummyFilterDirectoryReader(in);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }

    private static class DummyFilterLeafReader
    extends FilterLeafReader {
        public DummyFilterLeafReader(LeafReader in) {
            super(in);
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            super.document(this.maxDoc() - 1 - docID, visitor);
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return null;
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }
}

