/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.igoweb.go.Go;
import org.igoweb.go.swing.StoneImages;

public class StoneIcon
implements Icon {
    private final StoneImages images;
    private int whiteImageId;
    private int color;
    private int mark;
    private String label;
    private boolean nigiri;

    public StoneIcon(int color, int id) {
        this(color, id, 0, null, 1.5);
    }

    public StoneIcon(int color, int id, double size) {
        this(color, id, 0, null, size);
    }

    public StoneIcon(int color, int id, int mark, String label) {
        this(color, id, mark, label, 1.5);
    }

    public StoneIcon(int color, int id, int mark, String label, double size) {
        this.color = color;
        this.whiteImageId = StoneImages.whiteImageId(id);
        this.mark = mark;
        this.label = label;
        this.images = StoneImages.create((int)(Math.floor((double)UIManager.getInt("org.igoweb.fontH") * size) / (1.0 + 2.0 * StoneImages.shadowOffsetRatio)));
    }

    public void setNigiri(boolean isNigiri) {
        this.nigiri = isNigiri;
    }

    @Override
    public int getIconWidth() {
        return this.images.size + 2 * this.images.shadowOffset;
    }

    @Override
    public int getIconHeight() {
        return this.images.size + 2 * this.images.shadowOffset;
    }

    @Override
    public void paintIcon(Component comp, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(x + this.images.shadowOffset, y + this.images.shadowOffset);
        int curMark = this.mark;
        if (!comp.isEnabled()) {
            curMark |= 0x80;
        }
        this.images.paintStone(g2d, this.color, curMark, this.whiteImageId, this.label, 0);
        if (this.nigiri) {
            GeneralPath path = new GeneralPath();
            path.moveTo(this.images.size, 0.0f);
            path.lineTo(0.0f, this.images.size);
            path.lineTo(this.images.size, this.images.size);
            path.closePath();
            g2d.clip(path);
            this.images.paintStone(g2d, Go.opponent(this.color), curMark, this.whiteImageId, this.label, 0);
        }
        g2d.dispose();
    }

    public boolean setColor(int newColor) {
        if (newColor != this.color) {
            this.color = newColor;
            return true;
        }
        return false;
    }

    public boolean setMark(int newMark) {
        if (newMark != this.mark) {
            this.mark = newMark;
            return true;
        }
        return false;
    }
}

