/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.ZoneId;
import java.time.ZoneOffset;
import org.elasticsearch.common.time.DateFormatter;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateUtils {
    private static final DateFormatter dateOnlyFormatter = DateFormatter.forPattern((String)"yyyy-MM-dd").withZone((ZoneId)ZoneOffset.UTC);
    private static final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime().withZoneUTC();

    public static long endOfTheDay(String date) {
        try {
            return dateTimeFormatter.parseDateTime(date).getMillis();
        }
        catch (IllegalArgumentException ex) {
            MutableDateTime dateTime = new MutableDateTime(dateOnlyFormatter.parseMillis(date));
            dateTime.millisOfDay().set(dateTime.millisOfDay().getMaximumValue());
            return dateTime.getMillis();
        }
    }

    public static long beginningOfTheDay(String date) {
        try {
            return dateTimeFormatter.parseDateTime(date).getMillis();
        }
        catch (IllegalArgumentException ex) {
            return dateOnlyFormatter.parseMillis(date);
        }
    }
}

