/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.params;

import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.time.TimeUtils;

public class TimeRange {
    public static final String START_PARAM = "start";
    public static final String END_PARAM = "end";
    public static final String NOW = "now";
    public static final int MILLISECONDS_IN_SECOND = 1000;
    private final Long start;
    private final Long end;

    private TimeRange(Long start, Long end) {
        this.start = start;
        this.end = end;
    }

    public String getStart() {
        return this.start == null ? "" : String.valueOf(this.start);
    }

    public String getEnd() {
        return this.end == null ? "" : String.valueOf(this.end);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeRange timeRange = (TimeRange)o;
        return Objects.equals(this.start, timeRange.start) && Objects.equals(this.end, timeRange.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public static class Builder {
        private String start = "";
        private String end = "";

        private Builder() {
        }

        public Builder startTime(String start) {
            this.start = (String)ExceptionsHelper.requireNonNull((Object)start, (String)TimeRange.START_PARAM);
            return this;
        }

        public Builder endTime(String end) {
            this.end = (String)ExceptionsHelper.requireNonNull((Object)end, (String)TimeRange.END_PARAM);
            return this;
        }

        public TimeRange build() {
            return this.createTimeRange(this.start, this.end);
        }

        private TimeRange createTimeRange(String start, String end) {
            Long epochStart = null;
            Long epochEnd = null;
            if (!start.isEmpty()) {
                epochStart = this.paramToEpochIfValidOrThrow(TimeRange.START_PARAM, start) / 1000L;
                epochEnd = this.paramToEpochIfValidOrThrow(TimeRange.END_PARAM, end) / 1000L;
                if (end.isEmpty() || epochEnd.equals(epochStart)) {
                    epochEnd = epochStart + 1L;
                }
                if (epochEnd < epochStart) {
                    String msg = Messages.getMessage((String)"Invalid time range: end time ''{0}'' is earlier than start time ''{1}''.", (Object[])new Object[]{end, start});
                    throw new IllegalArgumentException(msg);
                }
            } else if (!end.isEmpty()) {
                epochEnd = this.paramToEpochIfValidOrThrow(TimeRange.END_PARAM, end) / 1000L;
            }
            return new TimeRange(epochStart, epochEnd);
        }

        private long paramToEpochIfValidOrThrow(String paramName, String date) {
            if (TimeRange.NOW.equals(date)) {
                return System.currentTimeMillis();
            }
            long epoch = 0L;
            if (!date.isEmpty() && (epoch = TimeUtils.dateStringToEpoch((String)date)) < 0L) {
                String msg = Messages.getMessage((String)"Query param [{0}] with value [{1}] cannot be parsed as a date or converted to a number (epoch).", (Object[])new Object[]{paramName, date});
                throw new ElasticsearchParseException(msg, new Object[0]);
            }
            return epoch;
        }
    }
}

