/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JoinedEntry
extends ReadOnlyEntry {
    private static final long serialVersionUID = -6519864521813773703L;
    private final List<JoinedEntry> nestedJoinResults;

    public JoinedEntry(Entry entry, List<JoinedEntry> nestedJoinResults) {
        this(entry.getDN(), entry.getAttributes(), nestedJoinResults);
    }

    public JoinedEntry(String dn, Collection<Attribute> attributes, List<JoinedEntry> nestedJoinResults) {
        super(dn, attributes);
        this.nestedJoinResults = nestedJoinResults == null ? Collections.emptyList() : Collections.unmodifiableList(nestedJoinResults);
    }

    ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(new ASN1OctetString(this.getDN()));
        ArrayList<ASN1Sequence> attrElements = new ArrayList<ASN1Sequence>(20);
        for (Attribute a : this.getAttributes()) {
            attrElements.add(a.encode());
        }
        elements.add(new ASN1Sequence(attrElements));
        if (!this.nestedJoinResults.isEmpty()) {
            ArrayList<ASN1Element> nestedElements = new ArrayList<ASN1Element>(this.nestedJoinResults.size());
            for (JoinedEntry je : this.nestedJoinResults) {
                nestedElements.add(je.encode());
            }
            elements.add(new ASN1Sequence(nestedElements));
        }
        return new ASN1Sequence(elements);
    }

    static JoinedEntry decode(ASN1Element element) throws LDAPException {
        try {
            ArrayList<JoinedEntry> nestedJoinResults;
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            String dn = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            ASN1Element[] attrElements = ASN1Sequence.decodeAsSequence(elements[1]).elements();
            ArrayList<Attribute> attrs = new ArrayList<Attribute>(attrElements.length);
            for (ASN1Element e : attrElements) {
                attrs.add(Attribute.decode(ASN1Sequence.decodeAsSequence(e)));
            }
            if (elements.length == 3) {
                ASN1Element[] nestedElements = ASN1Sequence.decodeAsSequence(elements[2]).elements();
                nestedJoinResults = new ArrayList(nestedElements.length);
                for (ASN1Element e : nestedElements) {
                    nestedJoinResults.add(JoinedEntry.decode(e));
                }
            } else {
                nestedJoinResults = new ArrayList<JoinedEntry>(0);
            }
            return new JoinedEntry(dn, attrs, nestedJoinResults);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOINED_ENTRY_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public List<JoinedEntry> getNestedJoinResults() {
        return this.nestedJoinResults;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("JoinedEntry(dn='");
        buffer.append(this.getDN());
        buffer.append("', attributes={");
        Iterator<Attribute> attrIterator = this.getAttributes().iterator();
        while (attrIterator.hasNext()) {
            attrIterator.next().toString(buffer);
            if (!attrIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, nestedJoinResults={");
        Iterator<JoinedEntry> entryIterator = this.nestedJoinResults.iterator();
        while (entryIterator.hasNext()) {
            entryIterator.next().toString(buffer);
            if (!entryIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

