/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.raw.border;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.flexdock.demos.raw.border.DemoBorderManager;
import org.flexdock.demos.raw.border.DockablePanel;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.defaults.DefaultDockingPort;

public class BorderDemo
extends JFrame
implements DockingConstants {
    public BorderDemo() {
        super("Border Docking Demo");
        this.setContentPane(this.createContentPane());
    }

    private JPanel createContentPane() {
        JPanel p = new JPanel(new BorderLayout(5, 5));
        p.add((Component)this.buildDockingPort("North"), "North");
        p.add((Component)this.buildDockingPort("South"), "South");
        p.add((Component)this.buildDockingPort("East"), "East");
        p.add((Component)this.buildDockingPort("West"), "West");
        p.add((Component)this.createDockingPort(), "Center");
        return p;
    }

    private DefaultDockingPort buildDockingPort(String desc) {
        DefaultDockingPort port = this.createDockingPort();
        DockablePanel panel = new DockablePanel(desc);
        port.dock(panel.getDockable(), "CENTER");
        return port;
    }

    private DefaultDockingPort createDockingPort() {
        DefaultDockingPort port = new DefaultDockingPort();
        port.setPreferredSize(new Dimension(100, 100));
        port.setBorderManager(new DemoBorderManager());
        return port;
    }

    public static void main(String[] args) {
        BorderDemo f = new BorderDemo();
        f.setSize(600, 400);
        DemoUtility.setCloseOperation(f);
        f.setVisible(true);
    }
}

