/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.HashingClassLoaderFactory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.session.BuildSessionLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClassLoaderCache
implements ClassLoaderCache,
Stoppable,
BuildSessionLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClassLoaderCache.class);
    private final Object lock = new Object();
    private final Map<ClassLoaderId, CachedClassLoader> byId = new HashMap<ClassLoaderId, CachedClassLoader>();
    private final Map<ClassLoaderSpec, CachedClassLoader> bySpec = new HashMap<ClassLoaderSpec, CachedClassLoader>();
    private final Set<ClassLoaderId> usedInThisBuild = new HashSet<ClassLoaderId>();
    private final ClasspathHasher classpathHasher;
    private final HashingClassLoaderFactory classLoaderFactory;

    public DefaultClassLoaderCache(HashingClassLoaderFactory classLoaderFactory, ClasspathHasher classpathHasher) {
        this.classLoaderFactory = classLoaderFactory;
        this.classpathHasher = classpathHasher;
    }

    @Override
    public ClassLoader get(ClassLoaderId id, ClassPath classPath, @Nullable ClassLoader parent, @Nullable FilteringClassLoader.Spec filterSpec) {
        return this.get(id, classPath, parent, filterSpec, null);
    }

    @Override
    public ClassLoader get(ClassLoaderId id, ClassPath classPath, @Nullable ClassLoader parent, @Nullable FilteringClassLoader.Spec filterSpec, @Nullable HashCode implementationHash) {
        return this.doGet(id, classPath, parent, filterSpec, implementationHash, this::createClassLoader);
    }

    @Override
    public ClassLoader createIfAbsent(ClassLoaderId id, ClassPath classPath, @Nullable ClassLoader parent, Function<ClassLoader, ClassLoader> factoryFunction, @Nullable HashCode implementationHash) {
        return this.doGet(id, classPath, parent, null, implementationHash, spec -> (ClassLoader)factoryFunction.apply(((ManagedClassLoaderSpec)spec).parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader doGet(ClassLoaderId id, ClassPath classPath, @Nullable ClassLoader parent, @Nullable FilteringClassLoader.Spec filterSpec, @Nullable HashCode implementationHash, Function<ManagedClassLoaderSpec, ClassLoader> factoryFunction) {
        if (implementationHash == null) {
            implementationHash = this.classpathHasher.hash(classPath);
        }
        ManagedClassLoaderSpec spec = new ManagedClassLoaderSpec(id.toString(), parent, classPath, implementationHash, filterSpec);
        Object object = this.lock;
        synchronized (object) {
            this.usedInThisBuild.add(id);
            CachedClassLoader cachedLoader = this.byId.get(id);
            if (cachedLoader == null || !cachedLoader.is(spec)) {
                CachedClassLoader newLoader = this.getAndRetainLoader(spec, id, factoryFunction);
                this.byId.put(id, newLoader);
                if (cachedLoader != null) {
                    LOGGER.debug("Releasing previous classloader for {}", (Object)id);
                    cachedLoader.release(id);
                }
                return newLoader.classLoader;
            }
            return cachedLoader.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ClassLoaderId id) {
        Object object = this.lock;
        synchronized (object) {
            CachedClassLoader cachedClassLoader = this.byId.remove(id);
            if (cachedClassLoader != null) {
                cachedClassLoader.release(id);
            }
            this.usedInThisBuild.remove(id);
        }
    }

    private CachedClassLoader getAndRetainLoader(ManagedClassLoaderSpec spec, ClassLoaderId id, Function<ManagedClassLoaderSpec, ClassLoader> factoryFunction) {
        CachedClassLoader cachedLoader = this.bySpec.get(spec);
        if (cachedLoader == null) {
            ClassLoader classLoader;
            CachedClassLoader parentCachedLoader = null;
            if (spec.isFiltered()) {
                parentCachedLoader = this.getAndRetainLoader(spec.unfiltered(), id, factoryFunction);
                classLoader = this.classLoaderFactory.createFilteringClassLoader(parentCachedLoader.classLoader, spec.filterSpec);
            } else {
                classLoader = factoryFunction.apply(spec);
            }
            cachedLoader = new CachedClassLoader(classLoader, spec, parentCachedLoader);
            this.bySpec.put(spec, cachedLoader);
        }
        return cachedLoader.retain(id);
    }

    private ClassLoader createClassLoader(ManagedClassLoaderSpec spec) {
        return this.classLoaderFactory.createChildClassLoader(spec.name, spec.parent, spec.classPath, spec.implementationHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.bySpec.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            for (CachedClassLoader cachedClassLoader : this.byId.values()) {
                ClassLoaderUtils.tryClose((ClassLoader)cachedClassLoader.classLoader);
            }
            this.byId.clear();
            this.bySpec.clear();
            this.usedInThisBuild.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeComplete() {
        Object object = this.lock;
        synchronized (object) {
            HashSet unused = Sets.newHashSet(this.byId.keySet());
            unused.removeAll(this.usedInThisBuild);
            for (ClassLoaderId id : unused) {
                this.remove(id);
            }
            this.usedInThisBuild.clear();
        }
        this.assertInternalIntegrity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertInternalIntegrity() {
        Object object = this.lock;
        synchronized (object) {
            HashMap<ClassLoaderId, CachedClassLoader> orphaned = new HashMap<ClassLoaderId, CachedClassLoader>();
            for (Map.Entry<ClassLoaderId, CachedClassLoader> entry : this.byId.entrySet()) {
                if (this.bySpec.containsKey(entry.getValue().spec)) continue;
                orphaned.put(entry.getKey(), entry.getValue());
            }
            if (!orphaned.isEmpty()) {
                throw new IllegalStateException("The following class loaders are orphaned: " + Joiner.on((String)",").withKeyValueSeparator(":").join(orphaned));
            }
        }
    }

    private class CachedClassLoader {
        private final ClassLoader classLoader;
        private final ClassLoaderSpec spec;
        private final CachedClassLoader parent;
        private final Multiset<ClassLoaderId> usedBy = HashMultiset.create();

        private CachedClassLoader(ClassLoader classLoader, @Nullable ClassLoaderSpec spec, CachedClassLoader parent) {
            this.classLoader = classLoader;
            this.spec = spec;
            this.parent = parent;
        }

        public boolean is(ClassLoaderSpec spec) {
            return this.spec.equals(spec);
        }

        public CachedClassLoader retain(ClassLoaderId loaderId) {
            this.usedBy.add((Object)loaderId);
            return this;
        }

        public void release(ClassLoaderId loaderId) {
            if (this.usedBy.isEmpty()) {
                throw new IllegalStateException("Cannot release already released classloader: " + this.classLoader);
            }
            if (this.usedBy.remove((Object)loaderId)) {
                if (this.usedBy.isEmpty()) {
                    if (this.parent != null) {
                        this.parent.release(loaderId);
                    }
                    DefaultClassLoaderCache.this.bySpec.remove(this.spec);
                }
            } else {
                throw new IllegalStateException("Classloader '" + this + "' not used by '" + loaderId + "'");
            }
        }
    }

    private static class ManagedClassLoaderSpec
    extends ClassLoaderSpec {
        private final String name;
        private final ClassLoader parent;
        private final ClassPath classPath;
        private final HashCode implementationHash;
        private final FilteringClassLoader.Spec filterSpec;

        public ManagedClassLoaderSpec(String name, ClassLoader parent, ClassPath classPath, HashCode implementationHash, FilteringClassLoader.Spec filterSpec) {
            this.name = name;
            this.parent = parent;
            this.classPath = classPath;
            this.implementationHash = implementationHash;
            this.filterSpec = filterSpec;
        }

        public ManagedClassLoaderSpec unfiltered() {
            return new ManagedClassLoaderSpec(this.name, this.parent, this.classPath, this.implementationHash, null);
        }

        public boolean isFiltered() {
            return this.filterSpec != null;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ManagedClassLoaderSpec that = (ManagedClassLoaderSpec)o;
            return Objects.equal((Object)this.parent, (Object)that.parent) && this.implementationHash.equals((Object)that.implementationHash) && this.classPath.equals(that.classPath) && Objects.equal((Object)this.filterSpec, (Object)that.filterSpec);
        }

        public int hashCode() {
            int result = this.implementationHash.hashCode();
            result = 31 * result + this.classPath.hashCode();
            result = 31 * result + (this.filterSpec != null ? this.filterSpec.hashCode() : 0);
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            return result;
        }
    }

    private static abstract class ClassLoaderSpec {
        private ClassLoaderSpec() {
        }
    }
}

