/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import com.google.gwt.safehtml.shared.SafeHtml;
import java.sql.Date;
import java.util.Map;

public class Type {
    public static final Type BOOLEAN = new Type("boolean");
    public static final Type BYTE = new Type("byte");
    public static final Type CHAR = new Type("char");
    public static final Type DATE = new Type(Date.class.getCanonicalName());
    public static final Type DOUBLE = new Type("double");
    public static final Type FLOAT = new Type("float");
    public static final Type INT = new Type("int");
    public static final Type LONG = new Type("long");
    public static final Type NUMBER = new Type("Number");
    public static final Type OBJECT = new Type("Object");
    public static final Type SHORT = new Type("short");
    public static final Type SAFEHTML = new Type(SafeHtml.class.getCanonicalName());
    public static final Type STRING = new Type("String");
    public static final Type STRING_MAP = new Type(Map.class.getCanonicalName() + "<String, String>");
    private final String sourceName;

    public Type(String sourceName) {
        this.sourceName = sourceName;
    }

    public Type getComponentType() {
        return null;
    }

    public String[] getEnumValues() {
        return null;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        return this.sourceName;
    }

    public static class ListType
    extends Type {
        private final Type componentType;

        public ListType(String sourceName, Type componentType) {
            super(sourceName);
            this.componentType = componentType;
        }

        @Override
        public Type getComponentType() {
            return this.componentType;
        }
    }

    public static class EnumType
    extends Type {
        private final String[] values;

        public EnumType(String sourceName, String[] values) {
            super(sourceName);
            this.values = values;
        }

        @Override
        public String[] getEnumValues() {
            return this.values;
        }

        public int getOrdinal(String name) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(name)) continue;
                return i;
            }
            return -1;
        }
    }

    public static class ArrayType
    extends Type {
        private final Type componentType;

        public ArrayType(String sourceName, Type componentType) {
            super(sourceName);
            this.componentType = componentType;
        }

        @Override
        public Type getComponentType() {
            return this.componentType;
        }
    }
}

