/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.server;

import com.google.gwt.typedarrays.server.Uint8ArrayImpl;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Uint8ClampedArray;

public final class Uint8ClampedArrayImpl
extends Uint8ArrayImpl
implements Uint8ClampedArray {
    public Uint8ClampedArrayImpl(ArrayBuffer buffer, int byteOffset, int byteLength) {
        super(buffer, byteOffset, byteLength);
    }

    @Override
    public void set(int index, int value) {
        super.set(index, Math.max(0, Math.min(value, 255)));
    }

    @Override
    public Uint8ClampedArray subarray(int begin) {
        int count = this.byteLength() - this.byteOffset();
        return this.subarray(begin, count);
    }

    @Override
    public Uint8ClampedArray subarray(int begin, int end) {
        int count = this.byteLength() - this.byteOffset();
        if (begin < 0) {
            if ((begin += count) < 0) {
                begin = 0;
            }
        } else if (begin > count) {
            begin = count;
        }
        if (end < 0) {
            if ((end += count) < 0) {
                end = 0;
            }
        } else if (end > count) {
            end = count;
        }
        if (end < begin) {
            end = begin;
        }
        return new Uint8ClampedArrayImpl(this.buffer(), begin, end);
    }
}

