/*
 * Decompiled with CFR 0.152.
 */
package free.jin;

import free.util.BeanProperties;
import free.util.EventListenerList;
import free.util.FilteringEnumeration;
import free.util.FormatException;
import free.util.IOUtilities;
import free.util.MappingEnumeration;
import free.util.RectDouble;
import free.util.StringEncoder;
import free.util.StringParser;
import java.awt.Color;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public abstract class Preferences {
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public abstract void addChangeListener(PropertyChangeListener var1);

    public abstract void removeChangeListener(PropertyChangeListener var1);

    public abstract Enumeration getPreferenceNames();

    public boolean hasPreference(String string) {
        return this.get(string, null) != null;
    }

    public abstract void set(String var1, Object var2);

    public abstract Object get(String var1, Object var2);

    public Object get(String string) {
        Object object = this.get(string, null);
        if (object == null) {
            throw new NoSuchElementException(string);
        }
        return object;
    }

    public void remove(String string) {
        this.set(string, null);
    }

    public Object lookup(String string, Object object) {
        if (this.hasPreference(string)) {
            return this.get(string);
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return object;
        }
        return this.lookup(string.substring(0, n), object);
    }

    public Object lookup(String string) {
        Object object = this.lookup(string, null);
        if (object == null) {
            throw new NoSuchElementException(string);
        }
        return object;
    }

    public boolean getBool(String string, boolean bl) {
        return (Boolean)this.get(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getBool(String string) {
        return (Boolean)this.get(string);
    }

    public int getInt(String string, int n) {
        return (Integer)this.get(string, new Integer(n));
    }

    public int getInt(String string) {
        return (Integer)this.get(string);
    }

    public double getDouble(String string, double d) {
        return (Double)this.get(string, new Double(d));
    }

    public double getDouble(String string) {
        return (Double)this.get(string);
    }

    public String getString(String string, String string2) {
        return (String)this.get(string, string2);
    }

    public String getString(String string) {
        return (String)this.get(string);
    }

    public int[] getIntList(String string, int[] nArray) {
        return (int[])this.get(string, nArray);
    }

    public int[] getIntList(String string) {
        return (int[])this.get(string);
    }

    public Color getColor(String string, Color color) {
        return (Color)this.get(string, color);
    }

    public Color getColor(String string) {
        return (Color)this.get(string);
    }

    public Rectangle getRect(String string, Rectangle rectangle) {
        return (Rectangle)this.get(string, rectangle);
    }

    public Rectangle getRect(String string) {
        return (Rectangle)this.get(string);
    }

    public RectDouble getRectDouble(String string, RectDouble rectDouble) {
        return (RectDouble)this.get(string, rectDouble);
    }

    public RectDouble getRectDouble(String string) {
        return (RectDouble)this.get(string);
    }

    public void setBool(String string, boolean bl) {
        this.set(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setInt(String string, int n) {
        this.set(string, new Integer(n));
    }

    public void setDouble(String string, double d) {
        this.set(string, new Double(d));
    }

    public void setString(String string, String string2) {
        this.set(string, string2);
    }

    public void setIntList(String string, int[] nArray) {
        this.set(string, nArray);
    }

    public void setColor(String string, Color color) {
        this.set(string, color);
    }

    public void setRect(String string, Rectangle rectangle) {
        this.set(string, rectangle);
    }

    public void setRectDouble(String string, RectDouble rectDouble) {
        this.set(string, rectDouble);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.save(fileOutputStream);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        Enumeration enumeration = this.getPreferenceNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.get(string);
            bufferedWriter.write(string);
            bufferedWriter.write("=");
            bufferedWriter.write(Preferences.encodePreference(object));
            bufferedWriter.write("\n");
        }
        bufferedWriter.flush();
    }

    public static Preferences createNew() {
        return new BeanPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Preferences load(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Preferences preferences = Preferences.load(fileInputStream);
            return preferences;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public static Preferences load(InputStream inputStream) throws IOException {
        BeanPreferences beanPreferences = new BeanPreferences();
        String string = IOUtilities.loadText(inputStream);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            int n2;
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            int n3 = string2.length();
            boolean bl = true;
            for (n2 = 0; n2 < n3; ++n2) {
                if (string2.charAt(n2) <= ' ') continue;
                bl = false;
            }
            if (bl) continue;
            n2 = string2.indexOf("=");
            if (n2 == -1) {
                throw new FormatException("No '=' found on line: " + string2);
            }
            for (n = n2 - 1; n >= 0 && string2.charAt(n) <= ' '; --n) {
            }
            int n4 = n2 + 1;
            while (n < n3 && string2.charAt(n4) <= ' ') {
                ++n4;
            }
            String string3 = string2.substring(0, n + 1).trim();
            String string4 = string2.substring(n4).trim();
            beanPreferences.set(string3, Preferences.parsePreference(string4));
        }
        return beanPreferences;
    }

    public static Preferences createBackedUp(Preferences preferences, Preferences preferences2) {
        return new BackedUpPreferences(preferences, preferences2);
    }

    public static Preferences createWrapped(Preferences preferences, String string) {
        return new WrapperPreferences(preferences, string);
    }

    private static Object parsePreference(String string) {
        if (string.startsWith("boolean;")) {
            return Boolean.valueOf(string.substring("boolean;".length()));
        }
        if (string.startsWith("integer;")) {
            return new Integer(string.substring("integer;".length()));
        }
        if (string.startsWith("double;")) {
            return new Double(string.substring("double;".length()));
        }
        if (string.startsWith("string;")) {
            return StringParser.parseString(string.substring("string;".length()));
        }
        if (string.startsWith("intlist;")) {
            return StringParser.parseIntList(string.substring("intlist;".length()));
        }
        if (string.startsWith("color;")) {
            return StringParser.parseColor(string.substring("color;".length()));
        }
        if (string.startsWith("rect.int;")) {
            return StringParser.parseRectangle(string.substring("rect.int;".length()));
        }
        if (string.startsWith("rect.double;")) {
            return StringParser.parseRectDouble(string.substring("rect.double;".length()));
        }
        return string;
    }

    private static String encodePreference(Object object) {
        if (object instanceof Boolean) {
            return "boolean;" + object;
        }
        if (object instanceof Integer) {
            return "integer;" + object;
        }
        if (object instanceof Double) {
            return "double;" + object;
        }
        if (object instanceof String) {
            return "string;" + StringEncoder.encodeString((String)object);
        }
        if (object instanceof int[]) {
            return "intlist;" + StringEncoder.encodeIntList((int[])object);
        }
        if (object instanceof Color) {
            return "color;" + StringEncoder.encodeColor((Color)object);
        }
        if (object instanceof Rectangle) {
            return "rect.int;" + StringEncoder.encodeRectangle((Rectangle)object);
        }
        if (object instanceof RectDouble) {
            return "rect.double;" + StringEncoder.encodeRectDouble((RectDouble)object);
        }
        throw new IllegalArgumentException("Unsupported preference type: " + object.getClass().getName());
    }

    private static class BackedUpPreferences
    extends Preferences
    implements PropertyChangeListener {
        private final Preferences mainDelegate;
        private final Preferences defaultDelegate;
        private final EventListenerList listenerList = new EventListenerList();

        public BackedUpPreferences(Preferences preferences, Preferences preferences2) {
            if (preferences == null || preferences2 == null) {
                throw new IllegalArgumentException("Neither of the delegates may be null");
            }
            this.mainDelegate = preferences;
            this.defaultDelegate = preferences2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            Object object2 = propertyChangeEvent.getOldValue();
            Object object3 = propertyChangeEvent.getNewValue();
            if (object == this.defaultDelegate && this.mainDelegate.hasPreference(string)) {
                return;
            }
            PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(this, string, object2, object3);
            propertyChangeEvent2.setPropagationId(propertyChangeEvent.getPropagationId());
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != (class$java$beans$PropertyChangeListener == null ? Preferences.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)objectArray[i + 1];
                propertyChangeListener.propertyChange(propertyChangeEvent2);
            }
        }

        public void set(String string, Object object) {
            if (object.equals(this.get(string, null))) {
                return;
            }
            this.mainDelegate.set(string, object);
        }

        public Object get(String string, Object object) {
            return this.mainDelegate.get(string, this.defaultDelegate.get(string, object));
        }

        public void addChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.listenerList.getListenerCount(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Preferences.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener) == 0) {
                this.mainDelegate.addChangeListener(this);
                this.defaultDelegate.addChangeListener(this);
            }
            this.listenerList.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Preferences.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
        }

        public void removeChangeListener(PropertyChangeListener propertyChangeListener) {
            this.listenerList.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Preferences.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
            if (this.listenerList.getListenerCount(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Preferences.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener) == 0) {
                this.mainDelegate.removeChangeListener(this);
                this.defaultDelegate.removeChangeListener(this);
            }
        }

        public Enumeration getPreferenceNames() {
            Object e;
            Hashtable hashtable = new Hashtable();
            Enumeration enumeration = this.mainDelegate.getPreferenceNames();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                hashtable.put(e, e);
            }
            enumeration = this.defaultDelegate.getPreferenceNames();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                hashtable.put(e, e);
            }
            return hashtable.keys();
        }
    }

    private static class WrapperPreferences
    extends Preferences
    implements PropertyChangeListener {
        private final Preferences delegate;
        private final String prefix;
        private final EventListenerList listenerList = new EventListenerList();

        public WrapperPreferences(Preferences preferences, String string) {
            if (preferences == null) {
                throw new IllegalArgumentException("The delegate may not be null");
            }
            if (string == null) {
                throw new IllegalArgumentException("The prefix may not be null - use an empty string instead");
            }
            this.delegate = preferences;
            this.prefix = string;
        }

        private String prefix(String string) {
            return this.prefix + string;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!string.startsWith(this.prefix)) {
                return;
            }
            string = string.substring(this.prefix.length());
            PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(this, string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            propertyChangeEvent2.setPropagationId(propertyChangeEvent.getPropagationId());
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != (class$java$beans$PropertyChangeListener == null ? Preferences.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)objectArray[i + 1];
                propertyChangeListener.propertyChange(propertyChangeEvent2);
            }
        }

        public void set(String string, Object object) {
            this.delegate.set(this.prefix(string), object);
        }

        public Object get(String string, Object object) {
            return this.delegate.get(this.prefix(string), object);
        }

        public void addChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.listenerList.getListenerCount(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Preferences.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener) == 0) {
                this.delegate.addChangeListener(this);
            }
            this.listenerList.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Preferences.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
        }

        public void removeChangeListener(PropertyChangeListener propertyChangeListener) {
            this.listenerList.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Preferences.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
            if (this.listenerList.getListenerCount(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Preferences.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener) == 0) {
                this.delegate.removeChangeListener(this);
            }
        }

        public Enumeration getPreferenceNames() {
            FilteringEnumeration filteringEnumeration = new FilteringEnumeration(this.delegate.getPreferenceNames()){

                public boolean accept(Object object) {
                    return ((String)object).startsWith(WrapperPreferences.this.prefix);
                }
            };
            return new MappingEnumeration(filteringEnumeration){

                public Object map(Object object) {
                    String string = (String)object;
                    return string.substring(WrapperPreferences.this.prefix.length());
                }
            };
        }
    }

    private static class BeanPreferences
    extends Preferences {
        private final BeanProperties props = new BeanProperties(this);

        public void set(String string, Object object) {
            this.props.setProperty(string, object);
        }

        public Object get(String string, Object object) {
            return this.props.getProperty(string, object);
        }

        public void addChangeListener(PropertyChangeListener propertyChangeListener) {
            this.props.addPropertyChangeListener(propertyChangeListener);
        }

        public void removeChangeListener(PropertyChangeListener propertyChangeListener) {
            this.props.removePropertyChangeListener(propertyChangeListener);
        }

        public Enumeration getPreferenceNames() {
            return this.props.getPropertyNames();
        }
    }
}

