/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.ConnectionDetails;
import free.jin.I18n;
import free.jin.Jin;
import free.jin.Server;
import free.jin.User;
import free.jin.UsernamePolicy;
import free.jin.ui.DialogPanel;
import free.jin.ui.OptionPanel;
import free.util.BrowserControl;
import free.util.StringEncoder;
import free.util.TableLayout;
import free.util.Utilities;
import free.workarounds.FixedJComboBox;
import free.workarounds.FixedJPasswordField;
import free.workarounds.FixedJTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;

public class LoginPanel
extends DialogPanel {
    private final I18n i18n = I18n.get(LoginPanel.class);
    private Server[] servers;
    private User[] users;
    private final JComboBox serverBox = new FixedJComboBox();
    private final JComboBox userBox = new FixedJComboBox();
    private final JTextField usernameField = new FixedJTextField();
    private final JPasswordField passwordField = new FixedJPasswordField();
    private final JCheckBox savePasswordCheckBox = this.i18n.createCheckBox("savePasswordCheckBox");
    private final JButton retrievePasswordButton = this.i18n.createButton("retrievePasswordButton");
    private final JComboBox hostnameBox = new FixedJComboBox();
    private final JTextField portsField = new FixedJTextField(7);
    private final JButton connectButton = this.i18n.createButton("connectButton");
    private final JButton registerButton = this.i18n.createButton("registerButton");
    private JComponent defaultFocusedComponent = null;

    public LoginPanel(ConnectionDetails connectionDetails) {
        this(connectionDetails.getServer(), connectionDetails);
    }

    public LoginPanel(Server server) {
        this(server, null);
    }

    private LoginPanel(Server server, ConnectionDetails connectionDetails) {
        this.createUI();
        this.servers = Jin.getInstance().getServers();
        this.serverBox.setModel(this.createServerBoxModel());
        this.setData(server, connectionDetails);
    }

    private void setData(Server server, ConnectionDetails connectionDetails) {
        User user;
        this.serverBox.setSelectedIndex(Utilities.indexOf(this.servers, server));
        this.users = this.getServerUsers(server);
        this.userBox.setModel(this.createUserBoxModel());
        User user2 = user = connectionDetails == null ? null : Jin.getInstance().getUser(server, connectionDetails.getUsername());
        if (user == null) {
            this.userBox.setSelectedIndex(0);
        } else {
            this.userBox.setSelectedIndex(Utilities.indexOf(this.users, user) + 1);
        }
        if (connectionDetails == null || connectionDetails.isGuest()) {
            this.usernameField.setText("");
            this.passwordField.setText("");
            this.savePasswordCheckBox.setSelected(false);
        } else {
            this.usernameField.setText(connectionDetails.getUsername());
            this.passwordField.setText(connectionDetails.getPassword());
            this.savePasswordCheckBox.setSelected(connectionDetails.isSavePassword());
        }
        this.usernameField.setColumns(10);
        this.passwordField.setColumns(10);
        this.hostnameBox.setModel(new DefaultComboBoxModel<String>(server.getHosts()));
        this.hostnameBox.setSelectedItem(connectionDetails == null ? server.getDefaultHost() : connectionDetails.getHost());
        int[] nArray = connectionDetails == null ? server.getPorts() : connectionDetails.getPorts();
        this.portsField.setText(StringEncoder.encodeIntList(nArray));
        this.retrievePasswordButton.setVisible(server.getPasswordRetrievalPage() != null);
        this.registerButton.setVisible(server.getRegistrationPage() != null);
        if (!this.isShowing()) {
            this.defaultFocusedComponent = this.usernameField.getText().length() == 0 ? this.usernameField : (this.passwordField.getText().length() == 0 ? this.passwordField : this.connectButton);
        }
    }

    private ComboBoxModel createServerBoxModel() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.servers.length; ++i) {
            defaultComboBoxModel.addElement(this.servers[i].getLongName());
        }
        return defaultComboBoxModel;
    }

    private User[] getServerUsers(Server server) {
        Vector<User> vector = new Vector<User>();
        ListModel listModel = Jin.getInstance().getUsers();
        for (int i = 0; i < listModel.getSize(); ++i) {
            User user = (User)listModel.getElementAt(i);
            if (user.getServer() != server) continue;
            vector.addElement(user);
        }
        Object[] objectArray = new User[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private ComboBoxModel createUserBoxModel() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(this.i18n.getString("accountComboBox.newAccount"));
        for (int i = 0; i < this.users.length; ++i) {
            defaultComboBoxModel.addElement(this.users[i].getUsername());
        }
        return defaultComboBoxModel;
    }

    public ConnectionDetails askConnectionDetails() {
        return (ConnectionDetails)super.askResult();
    }

    protected String getTitle() {
        return this.i18n.getString("title");
    }

    private void showIllegalPortsError() {
        this.i18n.error("invalidPortsDialog", this);
    }

    private Server getServer() {
        return this.servers[this.serverBox.getSelectedIndex()];
    }

    private void createUI() {
        this.serverBox.setEditable(false);
        this.serverBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Server server = LoginPanel.this.servers[LoginPanel.this.serverBox.getSelectedIndex()];
                User[] userArray = LoginPanel.this.getServerUsers(server);
                if (userArray.length == 1) {
                    LoginPanel.this.setData(server, userArray[0].getPreferredConnDetails());
                } else {
                    LoginPanel.this.setData(server, null);
                }
            }
        });
        this.userBox.setEditable(false);
        this.userBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LoginPanel.this.userBox.getSelectedIndex() == 0) {
                    LoginPanel.this.setData(LoginPanel.this.getServer(), null);
                } else {
                    LoginPanel.this.setData(LoginPanel.this.getServer(), LoginPanel.this.users[LoginPanel.this.userBox.getSelectedIndex() - 1].getPreferredConnDetails());
                }
            }
        });
        this.hostnameBox.setFont(UIManager.getFont("TextField.font"));
        this.hostnameBox.setEditable(true);
        this.connectButton.setDefaultCapable(true);
        this.setDefaultButton(this.connectButton);
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Server server = LoginPanel.this.getServer();
                String string = LoginPanel.this.usernameField.getText();
                UsernamePolicy usernamePolicy = server.getUsernamePolicy();
                String string2 = usernamePolicy.invalidityReason(string);
                if (string2 != null) {
                    OptionPanel.error(LoginPanel.this.i18n.getString("invalidUsernameDialog.title"), string2, LoginPanel.this);
                    return;
                }
                int[] nArray = LoginPanel.parsePorts(LoginPanel.this.portsField.getText());
                if (nArray == null) {
                    LoginPanel.this.showIllegalPortsError();
                    return;
                }
                String string3 = new String(LoginPanel.this.passwordField.getPassword());
                if ("".equals(string3)) {
                    string3 = null;
                }
                boolean bl = LoginPanel.this.savePasswordCheckBox != null && LoginPanel.this.savePasswordCheckBox.isSelected();
                User user = Jin.getInstance().getUser(server, string);
                if (user == null) {
                    user = new User(server, string);
                }
                ConnectionDetails connectionDetails = usernamePolicy.isSame(string, usernamePolicy.getGuestUsername()) ? ConnectionDetails.createGuest(server, string, (String)LoginPanel.this.hostnameBox.getSelectedItem(), nArray) : ConnectionDetails.create(server, user, string, string3, bl, (String)LoginPanel.this.hostnameBox.getSelectedItem(), nArray);
                LoginPanel.this.close(connectionDetails);
            }
        });
        this.retrievePasswordButton.setDefaultCapable(false);
        this.retrievePasswordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = LoginPanel.this.getServer().getPasswordRetrievalPage();
                if (!BrowserControl.displayURL(string)) {
                    BrowserControl.showDisplayBrowserFailedDialog(string, LoginPanel.this, true);
                }
            }
        });
        JButton jButton = this.i18n.createButton("loginAsGuestButton");
        jButton.setDefaultCapable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = LoginPanel.parsePorts(LoginPanel.this.portsField.getText());
                if (nArray == null) {
                    LoginPanel.this.showIllegalPortsError();
                    return;
                }
                String string = LoginPanel.this.getServer().getUsernamePolicy().getGuestUsername();
                LoginPanel.this.close(ConnectionDetails.createGuest(LoginPanel.this.getServer(), string, (String)LoginPanel.this.hostnameBox.getSelectedItem(), nArray));
            }
        });
        this.registerButton.setDefaultCapable(false);
        this.registerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = LoginPanel.this.getServer().getRegistrationPage();
                if (!BrowserControl.displayURL(string)) {
                    BrowserControl.showDisplayBrowserFailedDialog(string, LoginPanel.this, true);
                }
            }
        });
        JButton jButton2 = this.i18n.createButton("cancelButton");
        jButton2.setDefaultCapable(false);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginPanel.this.close(null);
            }
        });
        if (Jin.getInstance().getPasswordSaveWarning() != null) {
            this.savePasswordCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionPanel optionPanel;
                    if (LoginPanel.this.savePasswordCheckBox.isSelected() && (optionPanel = new OptionPanel(LoginPanel.this, OptionPanel.WARNING, LoginPanel.this.i18n.getString("passwordSaveWarningPanel.title"), new Object[]{OptionPanel.YES, OptionPanel.NO}, OptionPanel.YES, Jin.getInstance().getPasswordSaveWarning())).display() != OptionPanel.YES) {
                        LoginPanel.this.savePasswordCheckBox.setSelected(false);
                    }
                }
            });
        }
        Component component = this.createServerUserPanel(this.serverBox, this.userBox);
        Component component2 = this.createGuestPanel(jButton, this.registerButton);
        Component component3 = this.createAdvancedPanel(this.hostnameBox, this.portsField);
        Component component4 = this.createMembersPanel(this.usernameField, this.passwordField, this.savePasswordCheckBox, this.retrievePasswordButton, this.connectButton);
        Component component5 = this.createCancelPanel(jButton2);
        this.setLayout(new BorderLayout(20, 20));
        Box box = new Box(0);
        Box box2 = new Box(0);
        box.add(component2);
        box.add(Box.createHorizontalStrut(10));
        box.add(component3);
        box2.add(component4);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(component5);
        Box box3 = new Box(1);
        box3.add(box);
        box3.add(Box.createVerticalStrut(10));
        box3.add(box2);
        this.add(component, "North");
        this.add((Component)box3, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    private Component createServerUserPanel(JComboBox jComboBox, JComboBox jComboBox2) {
        JLabel jLabel = this.i18n.createLabel("serverLabel");
        jLabel.setLabelFor(jComboBox);
        JLabel jLabel2 = this.i18n.createLabel("accountLabel");
        jLabel2.setLabelFor(jComboBox2);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add(jComboBox);
        box.add(Box.createHorizontalStrut(20));
        box.add(jLabel2);
        box.add(Box.createHorizontalStrut(5));
        box.add(jComboBox2);
        box.add(Box.createHorizontalStrut(10));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add("Center", box);
        jPanel.add("South", new JSeparator());
        return jPanel;
    }

    private Component createGuestPanel(JButton jButton, JButton jButton2) {
        JPanel jPanel = new JPanel(new TableLayout(1, 10, 10));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.setBorder(BorderFactory.createCompoundBorder(this.i18n.createTitledBorder("guestsBorder"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return jPanel;
    }

    private Component createAdvancedPanel(JComboBox jComboBox, JTextField jTextField) {
        JLabel jLabel = this.i18n.createLabel("hostnameLabel");
        jLabel.setLabelFor(jComboBox);
        JLabel jLabel2 = this.i18n.createLabel("portsLabel");
        jLabel2.setLabelFor(jTextField);
        JPanel jPanel = new JPanel(new TableLayout(2, 10, 10));
        jPanel.add(jComboBox);
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        jPanel.add(jLabel2);
        jTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, jTextField.getPreferredSize().height));
        jPanel.setBorder(BorderFactory.createCompoundBorder(this.i18n.createTitledBorder("advancedOptionsBorder"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return jPanel;
    }

    private Component createMembersPanel(JTextField jTextField, JPasswordField jPasswordField, JCheckBox jCheckBox, JButton jButton, JButton jButton2) {
        boolean bl;
        JLabel jLabel = this.i18n.createLabel("handleLabel");
        jLabel.setLabelFor(jTextField);
        JLabel jLabel2 = this.i18n.createLabel("passwordLabel");
        jLabel2.setLabelFor(jPasswordField);
        JPanel jPanel = new JPanel(new TableLayout(2, 10, 7));
        jPanel.add(jTextField);
        jPanel.add(jLabel);
        jPanel.add(jPasswordField);
        jPanel.add(jLabel2);
        Box box = new Box(0);
        boolean bl2 = jCheckBox != null;
        boolean bl3 = bl = jButton != null;
        if (bl2) {
            box.add(jCheckBox);
        }
        if (bl) {
            if (bl2) {
                box.add(Box.createHorizontalStrut(10));
            }
            box.add(jButton);
        }
        box.add(Box.createHorizontalGlue());
        Box box2 = new Box(0);
        box2.add(jButton2);
        box2.add(Box.createHorizontalGlue());
        Box box3 = new Box(1);
        box3.add(jPanel);
        box3.add(Box.createVerticalStrut(10));
        box3.add(box);
        box3.add(Box.createVerticalStrut(10));
        box3.add(box2);
        box3.add(Box.createVerticalStrut(10));
        box3.setBorder(BorderFactory.createCompoundBorder(this.i18n.createTitledBorder("membersBorder"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return box3;
    }

    private Component createCancelPanel(JButton jButton) {
        Box box = new Box(1);
        box.add(Box.createVerticalGlue());
        box.add(jButton);
        return box;
    }

    private static int[] parsePorts(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int[] nArray = new int[stringTokenizer.countTokens()];
        if (nArray.length == 0) {
            return null;
        }
        try {
            for (int i = 0; i < nArray.length; ++i) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (n < 0 || n > Short.MAX_VALUE) {
                    return null;
                }
                nArray[i] = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return nArray;
    }

    public void paint(Graphics graphics) {
        if (this.defaultFocusedComponent != null) {
            this.defaultFocusedComponent.requestFocus();
            this.defaultFocusedComponent = null;
        }
        super.paint(graphics);
    }
}

