/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console.prefs;

import free.jin.I18n;
import free.jin.console.ConsoleManager;
import free.jin.console.prefs.TextPrefsPanel;
import free.jin.console.prefs.TextStyleChooserPanel;
import free.util.TextUtilities;
import free.util.swing.IntegerStrictPlainDocument;
import free.workarounds.FixedJTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ChannelTextPrefsPanel
extends TextPrefsPanel {
    private Vector channelPanels;
    static /* synthetic */ Class class$free$jin$console$prefs$ChannelTextPrefsPanel;

    public ChannelTextPrefsPanel(ConsoleManager consoleManager) {
        super(consoleManager);
    }

    protected TextPrefsPanel.CategoryPanel createCustomCategoryPanel(String string) {
        if (string.endsWith("channels-panel")) {
            I18n i18n = this.consoleManager.getI18n();
            String string2 = this.prefs.getString("preferences.categories." + string + ".nameKey");
            String string3 = i18n.getString(string2);
            String[] stringArray = TextUtilities.getTokens((String)this.prefs.getString("preferences.categories." + string + ".ids"), (String)";");
            int n = this.prefs.getInt("preferences.categories." + string + ".channels-count");
            ChannelsCategoryPanel channelsCategoryPanel = this.createChannelsCategoryPanel(string3, stringArray, n);
            if (this.channelPanels == null) {
                this.channelPanels = new Vector();
            }
            this.channelPanels.addElement(channelsCategoryPanel);
            return channelsCategoryPanel;
        }
        return super.createCustomCategoryPanel(string);
    }

    private ChannelsCategoryPanel createChannelsCategoryPanel(String string, String[] stringArray, int n) {
        String string2 = stringArray[0];
        Font font = this.getCategoryFont(string2);
        Color color = (Color)this.prefs.lookup("foreground." + string2, (Object)Color.white);
        Color color2 = this.prefs.getColor("background");
        boolean bl = this.prefs.getBool("output-text.antialias", false);
        TextStyleChooserPanel textStyleChooserPanel = new TextStyleChooserPanel(font, color, color2, bl, false, false);
        return new ChannelsCategoryPanel(string, textStyleChooserPanel, stringArray, n);
    }

    private class ChannelsCategoryPanel
    extends TextPrefsPanel.CategoryPanel {
        private final JTextField channelNumberField;

        public ChannelsCategoryPanel(String string, TextStyleChooserPanel textStyleChooserPanel, String[] stringArray, int n) {
            super(ChannelTextPrefsPanel.this, string, textStyleChooserPanel, stringArray);
            this.channelNumberField = new FixedJTextField((Document)new IntegerStrictPlainDocument(0L, (long)n), "", String.valueOf(n).length() + 1);
            this.channelNumberField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    ChannelsCategoryPanel.this.setChannel(ChannelsCategoryPanel.this.channelNumberField.getText());
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    ChannelsCategoryPanel.this.setChannel(ChannelsCategoryPanel.this.channelNumberField.getText());
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ChannelsCategoryPanel.this.setChannel(ChannelsCategoryPanel.this.channelNumberField.getText());
                }
            });
            this.setLayout(new BorderLayout(5, 5));
            JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
            jPanel.add(I18n.get((Class)(class$free$jin$console$prefs$ChannelTextPrefsPanel == null ? (class$free$jin$console$prefs$ChannelTextPrefsPanel = ChannelTextPrefsPanel.class$("free.jin.console.prefs.ChannelTextPrefsPanel")) : class$free$jin$console$prefs$ChannelTextPrefsPanel)).createLabel("channelNumberLabel"));
            jPanel.add(this.channelNumberField);
            JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)new JSeparator(0), "Center");
            this.add((Component)jPanel2, "North");
            this.add((Component)textStyleChooserPanel, "Center");
        }

        public void setChannel(String string) {
            TextStyleChooserPanel textStyleChooserPanel = this.getTextStyleChooser();
            textStyleChooserPanel.removeChangeListener(ChannelTextPrefsPanel.this.settingsChangeListener);
            String string2 = super.getMainCategory() + ("".equals(string) ? "" : "." + string);
            Font font = ChannelTextPrefsPanel.this.getCategoryFont(string2);
            Color color = (Color)ChannelTextPrefsPanel.this.prefs.lookup("foreground." + string2, (Object)Color.white);
            textStyleChooserPanel.setSelectedFont(font);
            textStyleChooserPanel.setSelectedForeground(color);
            textStyleChooserPanel.addChangeListener(ChannelTextPrefsPanel.this.settingsChangeListener);
        }

        public String getChannel() {
            return this.channelNumberField.getText();
        }

        public String[] getCategories() {
            String[] stringArray = super.getCategories();
            String string = this.getChannel();
            if (!"".equals(string)) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i] + "." + string;
                }
            }
            return stringArray;
        }
    }
}

