/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaFileCodeStyleFacade;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClsElementImpl
extends PsiElementBase
implements PsiCompiledElement {
    public static final Key<PsiCompiledElement> COMPILED_ELEMENT = Key.create("COMPILED_ELEMENT");
    private volatile Pair<TextRange, Identikit.ByType> myMirror;
    protected static final String NEXT_LINE = "go_to_next_line_and_indent";

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            ClsElementImpl.$$$reportNull$$$0(0);
        }
        return javaLanguage;
    }

    @Override
    public PsiManager getManager() {
        return this.getParent().getManager();
    }

    @Override
    public final boolean isWritable() {
        return false;
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    public boolean isValid() {
        PsiElement parent2 = this.getParent();
        return parent2 != null && parent2.isValid();
    }

    @Override
    public PsiElement copy() {
        return this;
    }

    protected PsiElement @NotNull [] getChildren(PsiElement ... children) {
        if (children == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                ClsElementImpl.$$$reportNull$$$0(1);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> list = new ArrayList<PsiElement>(children.length);
        for (PsiElement child : children) {
            if (child == null) continue;
            list.add(child);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(list);
        if (psiElementArray == null) {
            ClsElementImpl.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(3);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    @NotNull
    static IncorrectOperationException cannotModifyException(@NotNull PsiCompiledElement element) {
        VirtualFile virtualFile;
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(4);
        }
        String path = (virtualFile = PsiUtilCore.getVirtualFile(element)) == null ? "?" : virtualFile.getPresentableUrl();
        return new IncorrectOperationException(JavaPsiBundle.message("psi.error.attempt.to.edit.class.file", path));
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(5);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(6);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(7);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            ClsElementImpl.$$$reportNull$$$0(8);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    public abstract void appendMirrorText(int var1, @NotNull StringBuilder var2);

    protected int getIndentSize() {
        return JavaFileCodeStyleFacade.forContext(this.getContainingFile()).getIndentSize();
    }

    protected abstract void setMirror(@NotNull TreeElement var1) throws InvalidMirrorException;

    @Override
    public PsiElement getMirror() {
        PsiFile mirrorFile = ((ClsFileImpl)this.getContainingFile()).getMirror().getContainingFile();
        Pair<TextRange, Identikit.ByType> mirror = this.myMirror;
        return mirror == null ? null : ((Identikit.ByType)mirror.second).findPsiElement(mirrorFile, ((TextRange)mirror.first).getStartOffset(), ((TextRange)mirror.first).getEndOffset());
    }

    @Override
    public final TextRange getTextRange() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getTextRange() : TextRange.EMPTY_RANGE;
    }

    @Override
    public final int getStartOffsetInParent() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getStartOffsetInParent() : -1;
    }

    @Override
    public int getTextLength() {
        String text = this.getText();
        return text == null ? 0 : text.length();
    }

    @Override
    public PsiElement findElementAt(int offset2) {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.findElementAt(offset2) : null;
    }

    @Override
    public PsiReference findReferenceAt(int offset2) {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.findReferenceAt(offset2) : null;
    }

    @Override
    public final int getTextOffset() {
        PsiElement mirror = this.getMirror();
        return mirror != null ? mirror.getTextOffset() : -1;
    }

    @Override
    public String getText() {
        PsiElement mirror = this.getMirror();
        if (mirror != null) {
            return mirror.getText();
        }
        StringBuilder buffer = new StringBuilder();
        this.appendMirrorText(0, buffer);
        Logger.getInstance(ClsElementImpl.class).warn("Mirror wasn't set for " + this + " in " + this.getContainingFile() + ", expected text '" + buffer + "'");
        return buffer.toString();
    }

    @Override
    public char @NotNull [] textToCharArray() {
        PsiElement mirror = this.getMirror();
        char[] cArray = mirror != null ? mirror.textToCharArray() : ArrayUtilRt.EMPTY_CHAR_ARRAY;
        if (cArray == null) {
            ClsElementImpl.$$$reportNull$$$0(9);
        }
        return cArray;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            ClsElementImpl.$$$reportNull$$$0(10);
        }
        return this.getText().equals(text.toString());
    }

    @Override
    public ASTNode getNode() {
        return null;
    }

    static void goNextLine(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsElementImpl.$$$reportNull$$$0(11);
        }
        buffer.append('\n');
        for (int i = 0; i < indentLevel; ++i) {
            buffer.append(' ');
        }
    }

    protected static void appendText(@Nullable PsiElement stub, int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsElementImpl.$$$reportNull$$$0(12);
        }
        if (stub == null) {
            return;
        }
        ((ClsElementImpl)stub).appendMirrorText(indentLevel, buffer);
    }

    protected static void appendText(@Nullable PsiElement stub, int indentLevel, @NotNull StringBuilder buffer, @NotNull String separator) {
        if (buffer == null) {
            ClsElementImpl.$$$reportNull$$$0(13);
        }
        if (separator == null) {
            ClsElementImpl.$$$reportNull$$$0(14);
        }
        if (stub == null) {
            return;
        }
        int pos = buffer.length();
        ((ClsElementImpl)stub).appendMirrorText(indentLevel, buffer);
        if (buffer.length() != pos) {
            if (Strings.areSameInstance(separator, NEXT_LINE)) {
                ClsElementImpl.goNextLine(indentLevel, buffer);
            } else {
                buffer.append(separator);
            }
        }
    }

    protected void setMirrorCheckingType(@NotNull TreeElement element, @Nullable IElementType type2) throws InvalidMirrorException {
        if (element == null) {
            ClsElementImpl.$$$reportNull$$$0(15);
        }
        if (type2 != null && element.getElementType() != type2) {
            throw new InvalidMirrorException(element.getElementType() + " != " + type2);
        }
        PsiElement psi = element.getPsi();
        psi.putUserData(COMPILED_ELEMENT, this);
        this.myMirror = Pair.create(element.getTextRange(), Identikit.fromPsi(psi, JavaLanguage.INSTANCE));
    }

    protected static <T extends PsiElement> void setMirror(@Nullable T stub, @Nullable T mirror) throws InvalidMirrorException {
        if (stub == null || mirror == null) {
            throw new InvalidMirrorException(stub, mirror);
        }
        ((ClsElementImpl)stub).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirror));
    }

    protected static <T extends PsiElement> void setMirrorIfPresent(@Nullable T stub, @Nullable T mirror) throws InvalidMirrorException {
        if (stub == null != (mirror == null)) {
            throw new InvalidMirrorException(stub, mirror);
        }
        if (stub != null) {
            ((ClsElementImpl)stub).setMirror(SourceTreeToPsiMap.psiToTreeNotNull(mirror));
        }
    }

    protected static <T extends PsiElement> void setMirrors(T @NotNull [] stubs, T @NotNull [] mirrors) throws InvalidMirrorException {
        if (stubs == null) {
            ClsElementImpl.$$$reportNull$$$0(16);
        }
        if (mirrors == null) {
            ClsElementImpl.$$$reportNull$$$0(17);
        }
        ClsElementImpl.setMirrors(Arrays.asList(stubs), Arrays.asList(mirrors));
    }

    protected static <T extends PsiElement> void setMirrors(@NotNull List<? extends T> stubs, @NotNull List<? extends T> mirrors) throws InvalidMirrorException {
        if (stubs == null) {
            ClsElementImpl.$$$reportNull$$$0(18);
        }
        if (mirrors == null) {
            ClsElementImpl.$$$reportNull$$$0(19);
        }
        if (stubs.size() != mirrors.size()) {
            throw new InvalidMirrorException(stubs, mirrors);
        }
        for (int i = 0; i < stubs.size(); ++i) {
            ClsElementImpl.setMirror((PsiElement)stubs.get(i), (PsiElement)mirrors.get(i));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsElementImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubs";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mirrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsElementImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cannotModifyException";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "goNextLine";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setMirrorCheckingType";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setMirrors";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class InvalidMirrorException
    extends RuntimeException {
        public InvalidMirrorException(@NotNull String message) {
            if (message == null) {
                InvalidMirrorException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        public InvalidMirrorException(@Nullable PsiElement stubElement, @Nullable PsiElement mirrorElement) {
            this("stub:" + stubElement + "; mirror:" + mirrorElement);
        }

        public InvalidMirrorException(@NotNull List<? extends PsiElement> stubElements, @NotNull List<? extends PsiElement> mirrorElements) {
            if (stubElements == null) {
                InvalidMirrorException.$$$reportNull$$$0(1);
            }
            if (mirrorElements == null) {
                InvalidMirrorException.$$$reportNull$$$0(2);
            }
            this("stub:" + stubElements + "; mirror:" + mirrorElements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stubElements";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mirrorElements";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/compiled/ClsElementImpl$InvalidMirrorException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

