/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.opensolaris.opengrok.search.CustomQueryParser;

public class QueryBuilder {
    public static final String FULL = "full";
    public static final String DEFS = "defs";
    public static final String REFS = "refs";
    public static final String PATH = "path";
    public static final String HIST = "hist";
    public static final String TYPE = "type";
    public static final String U = "u";
    public static final String TAGS = "tags";
    public static final String T = "t";
    public static final String FULLPATH = "fullpath";
    public static final String PROJECT = "project";
    public static final String DATE = "date";
    private final Map<String, String> queries = new TreeMap<String, String>();

    public QueryBuilder setFreetext(String freetext) {
        return this.addQueryText(FULL, freetext);
    }

    public String getFreetext() {
        return this.getQueryText(FULL);
    }

    public QueryBuilder setDefs(String defs) {
        return this.addQueryText(DEFS, defs);
    }

    public String getDefs() {
        return this.getQueryText(DEFS);
    }

    public QueryBuilder setRefs(String refs) {
        return this.addQueryText(REFS, refs);
    }

    public String getRefs() {
        return this.getQueryText(REFS);
    }

    public QueryBuilder setPath(String path) {
        return this.addQueryText(PATH, path);
    }

    public String getPath() {
        return this.getQueryText(PATH);
    }

    public QueryBuilder setHist(String hist) {
        return this.addQueryText(HIST, hist);
    }

    public String getHist() {
        return this.getQueryText(HIST);
    }

    public QueryBuilder setType(String type) {
        return this.addQueryText(TYPE, type);
    }

    public String getType() {
        return this.getQueryText(TYPE);
    }

    public Map<String, String> getQueries() {
        return Collections.unmodifiableMap(this.queries);
    }

    public int getSize() {
        return this.queries.size();
    }

    public boolean isDefSearch() {
        return this.getQueryText(FULL) == null && this.getQueryText(REFS) == null && this.getQueryText(PATH) == null && this.getQueryText(HIST) == null && this.getQueryText(DEFS) != null;
    }

    public Query build() throws ParseException {
        if (this.queries.isEmpty()) {
            return null;
        }
        ArrayList<Query> queryList = new ArrayList<Query>(this.queries.size());
        for (Map.Entry<String, String> entry : this.queries.entrySet()) {
            String field = entry.getKey();
            String queryText = entry.getValue();
            queryList.add(this.buildQuery(field, this.escapeQueryString(field, queryText)));
        }
        if (queryList.size() == 1) {
            return (Query)queryList.get(0);
        }
        BooleanQuery combinedQuery = new BooleanQuery();
        for (Query query : queryList) {
            if (query instanceof BooleanQuery) {
                BooleanQuery boolQuery = (BooleanQuery)query;
                if (this.hasClause(boolQuery, BooleanClause.Occur.SHOULD) && !this.hasClause(boolQuery, BooleanClause.Occur.MUST)) {
                    combinedQuery.add(query, BooleanClause.Occur.MUST);
                    continue;
                }
                for (BooleanClause clause : boolQuery) {
                    combinedQuery.add(clause);
                }
                continue;
            }
            combinedQuery.add(query, BooleanClause.Occur.MUST);
        }
        return combinedQuery;
    }

    private QueryBuilder addQueryText(String field, String query) {
        if (query == null || query.isEmpty()) {
            this.queries.remove(field);
        } else {
            this.queries.put(field, query);
        }
        return this;
    }

    private String getQueryText(String field) {
        return this.queries.get(field);
    }

    private String escapeQueryString(String field, String query) {
        switch (field) {
            case "full": {
                return query.replace("::", "\\:\\:");
            }
            case "path": {
                if (query.startsWith("/") && query.endsWith("/")) break;
                return query.replace(":", "\\:").replace("/", "\\/");
            }
        }
        return query.replace(":", "\\:");
    }

    private Query buildQuery(String field, String queryText) throws ParseException {
        return new CustomQueryParser(field).parse(queryText);
    }

    private boolean hasClause(BooleanQuery query, BooleanClause.Occur occur) {
        for (BooleanClause clause : query) {
            if (!clause.getOccur().equals((Object)occur)) continue;
            return true;
        }
        return false;
    }
}

