/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jvnet.lafwidget.LafWidgetSupport;
import org.jvnet.lafwidget.utils.LafConstants;
import org.jvnet.substance.SubstanceDesktopIconUI;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTabbedPaneUI;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTitlePane;
import org.jvnet.substance.utils.SubstanceWidgetManager;

public class SubstanceWidgetSupport
extends LafWidgetSupport {
    @Override
    public JComponent getComponentForHover(JInternalFrame.JDesktopIcon desktopIcon) {
        SubstanceDesktopIconUI ui = (SubstanceDesktopIconUI)desktopIcon.getUI();
        return ui.getComponentForHover();
    }

    @Override
    public boolean toInstallMenuSearch(JMenuBar menuBar) {
        if (!SubstanceWidgetManager.getInstance().isAllowed(SwingUtilities.getRootPane(menuBar), SubstanceConstants.SubstanceWidgetType.MENU_SEARCH)) {
            return false;
        }
        if (menuBar instanceof SubstanceTitlePane.SubstanceMenuBar) {
            return false;
        }
        return super.toInstallMenuSearch(menuBar);
    }

    @Override
    public Icon getSearchIcon(int dimension, ComponentOrientation componentOrientation) {
        return SubstanceImageCreator.getSearchIcon(dimension, SubstanceColorSchemeUtilities.getColorScheme(null, ComponentState.ACTIVE), componentOrientation.isLeftToRight());
    }

    @Override
    public Icon getArrowIcon(int orientation) {
        return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getControlFontSize(), orientation, SubstanceColorSchemeUtilities.getColorScheme(null, ComponentState.ACTIVE));
    }

    @Override
    public Icon getNumberIcon(int number) {
        SubstanceColorScheme colorScheme = SubstanceLookAndFeel.getCurrentSkin(null).getMainActiveColorScheme(DecorationAreaType.HEADER);
        return SubstanceImageCreator.getHexaMarker(number, colorScheme);
    }

    @Override
    public void markButtonAsFlat(AbstractButton button) {
        button.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        button.setOpaque(false);
    }

    @Override
    public int getRolloverTabIndex(JTabbedPane tabbedPane) {
        SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)tabbedPane.getUI();
        return ui.getRolloverTabIndex();
    }

    @Override
    public void setTabAreaInsets(JTabbedPane tabbedPane, Insets tabAreaInsets) {
        SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)tabbedPane.getUI();
        ui.setTabAreaInsets(tabAreaInsets);
    }

    @Override
    public Insets getTabAreaInsets(JTabbedPane tabbedPane) {
        SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)tabbedPane.getUI();
        return ui.getTabAreaInsets();
    }

    @Override
    public Rectangle getTabRectangle(JTabbedPane tabbedPane, int tabIndex) {
        SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)tabbedPane.getUI();
        return ui.getTabRectangle(tabIndex);
    }

    @Override
    public void paintPasswordStrengthMarker(Graphics g, int x, int y, int width, int height, LafConstants.PasswordStrength pStrength) {
        Graphics2D g2 = (Graphics2D)g.create();
        SubstanceColorScheme colorScheme = null;
        if (pStrength == LafConstants.PasswordStrength.WEAK) {
            colorScheme = SubstanceColorSchemeUtilities.ORANGE;
        }
        if (pStrength == LafConstants.PasswordStrength.MEDIUM) {
            colorScheme = SubstanceColorSchemeUtilities.YELLOW;
        }
        if (pStrength == LafConstants.PasswordStrength.STRONG) {
            colorScheme = SubstanceColorSchemeUtilities.GREEN;
        }
        if (colorScheme != null) {
            SubstanceImageCreator.paintRectangularBackground(null, g, x, y, width, height, colorScheme, 0.5f, false);
        }
        g2.dispose();
    }

    @Override
    public boolean hasLockIcon(Component comp) {
        if (!SubstanceCoreUtilities.toShowExtraWidgets(comp)) {
            return false;
        }
        return super.hasLockIcon(comp);
    }

    @Override
    public Icon getLockIcon() {
        return SubstanceImageCreator.makeTransparent(null, SubstanceImageCreator.getSmallLockIcon(SubstanceColorSchemeUtilities.getColorScheme(null, ComponentState.DEFAULT)), 0.3);
    }

    @Override
    public boolean toInstallExtraElements(Component comp) {
        return SubstanceCoreUtilities.toShowExtraWidgets(comp);
    }

    @Override
    public int getLookupIconSize() {
        int result = 2 + SubstanceSizeUtils.getControlFontSize();
        if (result % 2 == 1) {
            ++result;
        }
        return result;
    }

    @Override
    public int getLookupButtonSize() {
        return 4 + SubstanceSizeUtils.getControlFontSize();
    }
}

