/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sos;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.sos.SOS;
import org.apache.tools.ant.types.Commandline;

public class SOSCheckout
extends SOS {
    Commandline commandLine;

    public void execute() throws BuildException {
        int result = 0;
        this.buildCmdLine();
        result = this.run(this.commandLine);
        if (result == 255) {
            String msg = "Failed executing: " + this.commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    protected Commandline buildCmdLine() {
        this.commandLine = new Commandline();
        this.commandLine.setExecutable(this.getSosCommand());
        if (this.getFilename() != null) {
            this.commandLine.createArgument().setValue("-command");
            this.commandLine.createArgument().setValue("CheckOutFile");
            this.commandLine.createArgument().setValue("-file");
            this.commandLine.createArgument().setValue(this.getFilename());
        } else {
            this.commandLine.createArgument().setValue("-command");
            this.commandLine.createArgument().setValue("CheckOutProject");
            this.commandLine.createArgument().setValue(this.getRecursive());
        }
        if (this.getSosServerPath() == null) {
            throw new BuildException("sosserverpath attribute must be set!", this.location);
        }
        this.commandLine.createArgument().setValue("-server");
        this.commandLine.createArgument().setValue(this.getSosServerPath());
        if (this.getUsername() == null) {
            throw new BuildException("username attribute must be set!", this.location);
        }
        this.commandLine.createArgument().setValue("-name");
        this.commandLine.createArgument().setValue(this.getUsername());
        this.commandLine.createArgument().setValue("-password");
        this.commandLine.createArgument().setValue(this.getPassword());
        if (this.getVssServerPath() == null) {
            throw new BuildException("vssserverpath attribute must be set!", this.location);
        }
        this.commandLine.createArgument().setValue("-database");
        this.commandLine.createArgument().setValue(this.getVssServerPath());
        if (this.getProjectPath() == null) {
            throw new BuildException("projectpath attribute must be set!", this.location);
        }
        this.commandLine.createArgument().setValue("-project");
        this.commandLine.createArgument().setValue(this.getProjectPath());
        this.commandLine.createArgument().setValue(this.getVerbose());
        this.commandLine.createArgument().setValue(this.getNoCompress());
        if (this.getSosHome() == null) {
            this.commandLine.createArgument().setValue(this.getNoCache());
        } else {
            this.commandLine.createArgument().setValue("-soshome");
            this.commandLine.createArgument().setValue(this.getSosHome());
        }
        if (this.getLocalPath() != null) {
            this.commandLine.createArgument().setValue("-workdir");
            this.commandLine.createArgument().setValue(this.getLocalPath());
        }
        return this.commandLine;
    }
}

