/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Requests;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class QueryTrace {
    private static final String SELECT_SESSIONS_FORMAT = "SELECT * FROM system_traces.sessions WHERE session_id = %s";
    private static final String SELECT_EVENTS_FORMAT = "SELECT * FROM system_traces.events WHERE session_id = %s";
    private static final int MAX_TRIES = 5;
    private static final long BASE_SLEEP_BETWEEN_TRIES_IN_MS = 3L;
    private final UUID traceId;
    private volatile String requestType;
    private volatile int duration = Integer.MIN_VALUE;
    private volatile InetAddress coordinator;
    private volatile Map<String, String> parameters;
    private volatile long startedAt;
    private volatile List<Event> events;
    private final SessionManager session;
    private final Lock fetchLock = new ReentrantLock();

    QueryTrace(UUID traceId, SessionManager session) {
        this.traceId = traceId;
        this.session = session;
    }

    public UUID getTraceId() {
        return this.traceId;
    }

    public String getRequestType() {
        this.maybeFetchTrace();
        return this.requestType;
    }

    public int getDurationMicros() {
        this.maybeFetchTrace();
        return this.duration;
    }

    public InetAddress getCoordinator() {
        this.maybeFetchTrace();
        return this.coordinator;
    }

    public Map<String, String> getParameters() {
        this.maybeFetchTrace();
        return this.parameters;
    }

    public long getStartedAt() {
        this.maybeFetchTrace();
        return this.startedAt;
    }

    public List<Event> getEvents() {
        this.maybeFetchTrace();
        return this.events;
    }

    public String toString() {
        this.maybeFetchTrace();
        return String.format("%s [%s] - %d\u00b5s", this.requestType, this.traceId, this.duration);
    }

    private void maybeFetchTrace() {
        if (this.duration != Integer.MIN_VALUE) {
            return;
        }
        this.fetchLock.lock();
        try {
            this.doFetchTrace();
        }
        finally {
            this.fetchLock.unlock();
        }
    }

    private void doFetchTrace() {
        int tries = 0;
        try {
            while (this.duration == Integer.MIN_VALUE && tries <= 5) {
                ++tries;
                ResultSetFuture sessionsFuture = this.session.executeQuery(new Requests.Query(String.format(SELECT_SESSIONS_FORMAT, this.traceId)), Statement.DEFAULT);
                ResultSetFuture eventsFuture = this.session.executeQuery(new Requests.Query(String.format(SELECT_EVENTS_FORMAT, this.traceId)), Statement.DEFAULT);
                Row sessRow = ((ResultSet)sessionsFuture.get()).one();
                if (sessRow != null && !sessRow.isNull("duration")) {
                    this.requestType = sessRow.getString("request");
                    this.coordinator = sessRow.getInet("coordinator");
                    if (!sessRow.isNull("parameters")) {
                        this.parameters = Collections.unmodifiableMap(sessRow.getMap("parameters", String.class, String.class));
                    }
                    this.startedAt = sessRow.getTimestamp("started_at").getTime();
                    this.events = new ArrayList<Event>();
                    for (Row evRow : (ResultSet)eventsFuture.get()) {
                        this.events.add(new Event(evRow.getString("activity"), evRow.getUUID("event_id").timestamp(), evRow.getInet("source"), evRow.getInt("source_elapsed"), evRow.getString("thread")));
                    }
                    this.events = Collections.unmodifiableList(this.events);
                    this.duration = sessRow.getInt("duration");
                    continue;
                }
                Uninterruptibles.sleepUninterruptibly((long)((long)tries * 3L), (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            throw new TraceRetrievalException("Unexpected exception while fetching query trace", e);
        }
        if (tries > 5) {
            throw new TraceRetrievalException(String.format("Unable to retrieve complete query trace after %d tries", 5));
        }
    }

    public static class Event {
        private final String name;
        private final long timestamp;
        private final InetAddress source;
        private final int sourceElapsed;
        private final String threadName;

        private Event(String name, long timestamp, InetAddress source, int sourceElapsed, String threadName) {
            this.name = name;
            this.timestamp = (timestamp - 122192928000000000L) / 10000L;
            this.source = source;
            this.sourceElapsed = sourceElapsed;
            this.threadName = threadName;
        }

        public String getDescription() {
            return this.name;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public InetAddress getSource() {
            return this.source;
        }

        public int getSourceElapsedMicros() {
            return this.sourceElapsed;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public String toString() {
            return String.format("%s on %s[%s] at %s", this.name, this.source, this.threadName, new Date(this.timestamp));
        }
    }
}

