/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RestClient;

public abstract class HttpResource {
    protected final String resourceOwnerName;
    protected final AtomicReference<State> state;

    protected HttpResource(String resourceOwnerName) {
        this(resourceOwnerName, true);
    }

    protected HttpResource(String resourceOwnerName, boolean dirty) {
        this.resourceOwnerName = Objects.requireNonNull(resourceOwnerName);
        this.state = new AtomicReference<State>(dirty ? State.DIRTY : State.CLEAN);
    }

    public String getResourceOwnerName() {
        return this.resourceOwnerName;
    }

    public boolean isDirty() {
        return this.state.get() != State.CLEAN;
    }

    public final void markDirty() {
        this.state.set(State.DIRTY);
    }

    public final void checkAndPublishIfDirty(RestClient client, ActionListener<Boolean> listener) {
        if (this.state.get() == State.CLEAN) {
            listener.onResponse((Object)true);
        } else {
            this.checkAndPublish(client, listener);
        }
    }

    public final void checkAndPublish(RestClient client, ActionListener<Boolean> listener) {
        if (this.state.getAndSet(State.CHECKING) != State.CHECKING) {
            this.doCheckAndPublish(client, (ActionListener<Boolean>)ActionListener.wrap(success -> {
                this.state.compareAndSet(State.CHECKING, success != false ? State.CLEAN : State.DIRTY);
                listener.onResponse(success);
            }, e -> {
                this.state.compareAndSet(State.CHECKING, State.DIRTY);
                listener.onFailure(e);
            }));
        } else {
            listener.onResponse((Object)false);
        }
    }

    protected abstract void doCheckAndPublish(RestClient var1, ActionListener<Boolean> var2);

    static enum State {
        CLEAN,
        CHECKING,
        DIRTY;

    }
}

