/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.filter;

import java.io.IOException;
import java.util.function.Predicate;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.privilege.HealthAndStatsPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.security.action.SecurityActionMapper;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;

public class SecurityActionFilter
extends AbstractComponent
implements ActionFilter {
    private static final Predicate<String> LICENSE_EXPIRATION_ACTION_MATCHER = HealthAndStatsPrivilege.INSTANCE.predicate();
    private static final Predicate<String> SECURITY_ACTION_MATCHER = Automatons.predicate((String[])new String[]{"cluster:admin/xpack/security*"});
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final SecurityActionMapper actionMapper = new SecurityActionMapper();
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final SecurityContext securityContext;
    private final DestructiveOperations destructiveOperations;

    public SecurityActionFilter(AuthenticationService authcService, AuthorizationService authzService, XPackLicenseState licenseState, ThreadPool threadPool, SecurityContext securityContext, DestructiveOperations destructiveOperations) {
        this.authcService = authcService;
        this.authzService = authzService;
        this.licenseState = licenseState;
        this.threadContext = threadPool.getThreadContext();
        this.securityContext = securityContext;
        this.destructiveOperations = destructiveOperations;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        block17: {
            if (!this.licenseState.isStatsAndHealthAllowed() && LICENSE_EXPIRATION_ACTION_MATCHER.test(action)) {
                this.logger.error("blocking [{}] operation due to expired license. Cluster health, cluster stats and indices stats \noperations are blocked on license expiration. All data operations (read and write) continue to work. \nIf you have a new license, please update it. Otherwise, please reach out to your support contact.", (Object)action);
                throw LicenseUtils.newComplianceException((String)"security");
            }
            if (this.licenseState.isAuthAllowed()) {
                ContextPreservingActionListener contextPreservingListener = ContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)this.threadContext);
                ActionListener authenticatedListener = ActionListener.wrap(arg_0 -> SecurityActionFilter.lambda$apply$0(chain, task, action, request, (ActionListener)contextPreservingListener, arg_0), arg_0 -> ((ActionListener)contextPreservingListener).onFailure(arg_0));
                boolean useSystemUser = AuthorizationUtils.shouldReplaceUserWithSystem(this.threadContext, action);
                try {
                    if (useSystemUser) {
                        this.securityContext.executeAsUser(SystemUser.INSTANCE, original -> {
                            try {
                                this.applyInternal(action, request, (ActionListener<Void>)authenticatedListener);
                            }
                            catch (IOException e) {
                                listener.onFailure((Exception)e);
                            }
                        }, Version.CURRENT);
                        break block17;
                    }
                    if (AuthorizationUtils.shouldSetUserBasedOnActionOrigin(this.threadContext)) {
                        AuthorizationUtils.switchUserBasedOnActionOriginAndExecute(this.threadContext, this.securityContext, original -> {
                            try {
                                this.applyInternal(action, request, (ActionListener<Void>)authenticatedListener);
                            }
                            catch (IOException e) {
                                listener.onFailure((Exception)e);
                            }
                        });
                        break block17;
                    }
                    try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext(true);){
                        this.applyInternal(action, request, (ActionListener<Void>)authenticatedListener);
                    }
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            } else if (SECURITY_ACTION_MATCHER.test(action)) {
                if (this.licenseState.isSecurityDisabledByLicenseDefaults()) {
                    listener.onFailure((Exception)new ElasticsearchException("Security must be explicitly enabled when using a [" + this.licenseState.getOperationMode().description() + "] license. Enable security by setting [xpack.security.enabled] to [true] in the elasticsearch.yml file and restart the node.", new Object[0]));
                } else {
                    listener.onFailure((Exception)((Object)LicenseUtils.newComplianceException((String)"security")));
                }
            } else {
                chain.proceed(task, action, request, listener);
            }
        }
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    private <Request extends ActionRequest> void applyInternal(String action, Request request, ActionListener<Void> listener) throws IOException {
        if ("indices:admin/close".equals(action) || "indices:admin/open".equals(action) || "indices:admin/delete".equals(action)) {
            IndicesRequest indicesRequest = (IndicesRequest)request;
            try {
                this.destructiveOperations.failDestructive(indicesRequest.indices());
            }
            catch (IllegalArgumentException e) {
                listener.onFailure((Exception)e);
                return;
            }
        }
        String securityAction = this.actionMapper.action(action, (TransportRequest)request);
        this.authcService.authenticate(securityAction, (TransportMessage)request, SystemUser.INSTANCE, (ActionListener<Authentication>)ActionListener.wrap(authc -> {
            if (authc != null) {
                this.authorizeRequest((Authentication)authc, securityAction, request, listener);
            } else if (!this.licenseState.isAuthAllowed()) {
                listener.onResponse(null);
            } else {
                listener.onFailure((Exception)new IllegalStateException("no authentication present but auth is allowed"));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private <Request extends ActionRequest> void authorizeRequest(Authentication authentication, String securityAction, Request request, ActionListener<Void> listener) {
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalArgumentException("authentication must be non null for authorization"));
        } else {
            this.authzService.authorize(authentication, securityAction, (TransportRequest)request, (ActionListener<Void>)ActionListener.wrap(ignore -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private static /* synthetic */ void lambda$apply$0(ActionFilterChain chain, Task task, String action, ActionRequest request, ActionListener contextPreservingListener, Void aVoid) throws Exception {
        chain.proceed(task, action, request, contextPreservingListener);
    }
}

