/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.validate.nrl.IntSet;
import org.xml.sax.Attributes;

class FilteredAttributes
implements Attributes {
    private final Attributes attributes;
    private final IntSet indexSet;
    private int[] reverseIndexMap;

    public FilteredAttributes(IntSet indexSet, Attributes attributes) {
        this.indexSet = indexSet;
        this.attributes = attributes;
    }

    private int reverseIndex(int k) {
        if (this.reverseIndexMap == null) {
            this.reverseIndexMap = new int[this.attributes.getLength()];
            int len = this.indexSet.size();
            for (int i = 0; i < len; ++i) {
                this.reverseIndexMap[this.indexSet.get((int)i)] = i + 1;
            }
        }
        return this.reverseIndexMap[k] - 1;
    }

    public int getLength() {
        return this.indexSet.size();
    }

    public String getURI(int index) {
        if (index < 0 || index >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getURI(this.indexSet.get(index));
    }

    public String getLocalName(int index) {
        if (index < 0 || index >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getLocalName(this.indexSet.get(index));
    }

    public String getQName(int index) {
        if (index < 0 || index >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getQName(this.indexSet.get(index));
    }

    public String getType(int index) {
        if (index < 0 || index >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getType(this.indexSet.get(index));
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getValue(this.indexSet.get(index));
    }

    public int getIndex(String uri, String localName) {
        int n = this.attributes.getIndex(uri, localName);
        if (n < 0) {
            return n;
        }
        return this.reverseIndex(n);
    }

    public int getIndex(String qName) {
        int n = this.attributes.getIndex(qName);
        if (n < 0) {
            return n;
        }
        return this.reverseIndex(n);
    }

    private int getRealIndex(String uri, String localName) {
        int index = this.attributes.getIndex(uri, localName);
        if (index < 0 || this.reverseIndex(index) < 0) {
            return -1;
        }
        return index;
    }

    private int getRealIndex(String qName) {
        int index = this.attributes.getIndex(qName);
        if (index < 0 || this.reverseIndex(index) < 0) {
            return -1;
        }
        return index;
    }

    public String getType(String uri, String localName) {
        return this.attributes.getType(this.getRealIndex(uri, localName));
    }

    public String getValue(String uri, String localName) {
        return this.attributes.getValue(this.getRealIndex(uri, localName));
    }

    public String getType(String qName) {
        return this.attributes.getType(this.getRealIndex(qName));
    }

    public String getValue(String qName) {
        return this.attributes.getValue(this.getRealIndex(qName));
    }
}

