/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PasswordView;
import javax.swing.text.Position;

final class WindowsPasswordView
extends PasswordView {
    private static final char DOT_CHAR = '\u25cf';

    WindowsPasswordView(Element element) {
        super(element);
    }

    public float getPreferredSpan(int axis) {
        this.overrideEchoChar();
        return super.getPreferredSpan(axis);
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        this.overrideEchoChar();
        return super.modelToView(pos, a, b);
    }

    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        this.overrideEchoChar();
        return super.viewToModel(fx, fy, a, bias);
    }

    protected int drawEchoCharacter(Graphics g, int x, int y, char c) {
        Container container = this.getContainer();
        if (!(container instanceof JPasswordField)) {
            return super.drawEchoCharacter(g, x, y, c);
        }
        JPasswordField field = (JPasswordField)container;
        if (this.canOverrideEchoChar(field)) {
            c = (char)9679;
        }
        return super.drawEchoCharacter(g, x, y, c);
    }

    private void overrideEchoChar() {
        Container container = this.getContainer();
        if (!(container instanceof JPasswordField)) {
            return;
        }
        JPasswordField field = (JPasswordField)container;
        if (this.canOverrideEchoChar(field)) {
            field.setEchoChar('\u25cf');
        }
    }

    private boolean canOverrideEchoChar(JPasswordField field) {
        return field.echoCharIsSet() && field.getEchoChar() == '*';
    }
}

