/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.xmpp.extensions.colibri2.AbstractConferenceModificationIQ;
import org.jitsi.xmpp.extensions.colibri2.Connect;
import org.jitsi.xmpp.extensions.colibri2.Connects;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;

public class ConferenceModifyIQ
extends AbstractConferenceModificationIQ<ConferenceModifyIQ> {
    public static final String ELEMENT = "conference-modify";
    public static final String RTCSTATS_ENABLED_ATTR_NAME = "rtcstats-enabled";
    public static final boolean RTCSTATS_ENABLED_DEFAULT = true;
    public static final String NAME_ATTR_NAME = "name";
    public static final String MEETING_ID_ATTR_NAME = "meeting-id";
    public static final String CREATE_ATTR_NAME = "create";
    public static final String EXPIRE_ATTR_NAME = "expire";
    public static final boolean CREATE_DEFAULT = false;
    public static final boolean EXPIRE_DEFAULT = false;
    @NotNull
    private final String meetingId;
    @Nullable
    private final String name;
    private final boolean rtcstatsEnabled;
    private final boolean create;
    private final boolean expire;

    private ConferenceModifyIQ(Builder b) {
        super(b, ELEMENT);
        this.rtcstatsEnabled = b.rtcstatsEnabled;
        this.create = b.create;
        this.expire = b.expire;
        if (b.connects != null) {
            this.addExtension(b.connects);
        }
        if (StringUtils.isBlank(b.meetingId)) {
            throw new IllegalArgumentException("meeting-id must be set for conference-modify IQ");
        }
        this.meetingId = b.meetingId;
        this.name = b.conferenceName;
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.attribute(MEETING_ID_ATTR_NAME, this.meetingId);
        if (this.name != null) {
            xml.attribute(NAME_ATTR_NAME, this.name);
        }
        if (!this.rtcstatsEnabled) {
            xml.attribute(RTCSTATS_ENABLED_ATTR_NAME, this.rtcstatsEnabled);
        }
        if (this.create) {
            xml.attribute(CREATE_ATTR_NAME, this.create);
        }
        if (this.expire) {
            xml.attribute(EXPIRE_ATTR_NAME, this.expire);
        }
        xml.setEmptyElement();
        return xml;
    }

    @Nullable
    public String getConferenceName() {
        return this.name;
    }

    @NotNull
    public String getMeetingId() {
        return this.meetingId;
    }

    public boolean isRtcstatsEnabled() {
        return this.rtcstatsEnabled;
    }

    public boolean getCreate() {
        return this.create;
    }

    public boolean getExpire() {
        return this.expire;
    }

    @Nullable
    public Connects getConnects() {
        return this.getExtension(Connects.class);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Builder builder(XMPPConnection connection) {
        return new Builder(connection);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Builder builder(IqData iqData) {
        return new Builder(iqData);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Builder builder(String stanzaId) {
        return new Builder(stanzaId);
    }

    public static final class Builder
    extends AbstractConferenceModificationIQ.Builder<ConferenceModifyIQ> {
        private boolean rtcstatsEnabled = true;
        private boolean create = false;
        private boolean expire = false;
        private String conferenceName;
        private String meetingId;
        private Connects connects = null;

        private Builder(IqData iqCommon) {
            super(iqCommon);
        }

        private Builder(XMPPConnection connection) {
            super(connection);
        }

        private Builder(String stanzaId) {
            super(stanzaId);
        }

        public Builder setRtcstatsEnabled(boolean rtcstatsEnabled) {
            this.rtcstatsEnabled = rtcstatsEnabled;
            return this;
        }

        public Builder setEmptyConnects() {
            this.connects = new Connects();
            return this;
        }

        public Builder addConnect(@NotNull Connect connect) {
            if (this.connects == null) {
                this.connects = new Connects();
            }
            this.connects.addConnect(connect);
            return this;
        }

        public Builder setConferenceName(String name) {
            this.conferenceName = name;
            return this;
        }

        public Builder setMeetingId(String id) {
            this.meetingId = id;
            return this;
        }

        public Builder setCreate(boolean create) {
            this.create = create;
            return this;
        }

        public Builder setExpire(boolean expire) {
            this.expire = expire;
            return this;
        }

        @Override
        @Contract(value=" -> new")
        @NotNull
        public ConferenceModifyIQ build() {
            return new ConferenceModifyIQ(this);
        }
    }
}

